/*
 * Decompiled with CFR 0.152.
 */
package top.shjibi.plugineer.command.base;

import java.util.List;
import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.shjibi.plugineer.command.base.CommandInfo;
import top.shjibi.plugineer.util.StringUtil;

public abstract class BasicCommand
implements TabExecutor {
    @NotNull
    protected final JavaPlugin plugin;
    @NotNull
    protected final String name;
    protected final int minArgs;
    @NotNull
    protected final String[] usage;

    public BasicCommand(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        CommandInfo[] infoArray = (CommandInfo[])this.getClass().getAnnotationsByType(CommandInfo.class);
        if (infoArray.length == 0) {
            throw new RuntimeException("\u65e0\u6307\u4ee4\u4fe1\u606f");
        }
        CommandInfo info = infoArray[0];
        this.name = info.name();
        this.minArgs = info.minArgs();
        this.usage = info.usage();
    }

    public void register() {
        PluginCommand command = Objects.requireNonNull(this.plugin.getCommand(this.name));
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    protected final void sendUsage(@NotNull CommandSender sender, Object ... replacement) {
        if (this.usage.length == 0) {
            return;
        }
        for (String line : this.usage) {
            sender.sendMessage(StringUtil.color(String.format(line, replacement)));
        }
    }

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length < this.minArgs) {
            this.sendUsage(sender, label);
            return true;
        }
        this.execute(sender, command, label, args);
        return true;
    }

    public final List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        return this.completeTab(sender, command, label, args);
    }

    @Nullable
    public List<String> completeTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return null;
    }

    public abstract void execute(@NotNull CommandSender var1, @NotNull Command var2, @NotNull String var3, @NotNull String[] var4);

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    @NotNull
    public String[] getUsage() {
        return this.usage;
    }
}

