/*
 * Decompiled with CFR 0.152.
 */
package top.shjibi.plugineer.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.shjibi.plugineer.config.Configurable;

public class Config
extends Configurable<YamlConfiguration> {
    protected final JavaPlugin plugin;
    protected final File folder;
    protected final File[] files;
    protected final YamlConfiguration config;
    protected final String name;

    public Config(@NotNull JavaPlugin plugin, @NotNull String name) {
        this(plugin, name, null);
    }

    public Config(@NotNull JavaPlugin plugin, @NotNull String name, @Nullable String folderPath) {
        this.plugin = plugin;
        this.name = name;
        this.folder = this.mkdirs((Plugin)plugin, folderPath);
        this.files = new File[]{new File(this.folder.getAbsolutePath() + "\\" + name + ".yml")};
        this.config = this.load(this.files[0]);
    }

    @NotNull
    public ConfigurationSection createSection(@NotNull String path, @NotNull Map<?, ?> map) {
        return this.config.createSection(path, map);
    }

    @NotNull
    public ConfigurationSection createSection(@NotNull String path) {
        return this.config.createSection(path);
    }

    public void setConfig(@NotNull String path, @Nullable Object value) {
        this.config.set(path, value);
    }

    @NotNull
    public String getConfig(@NotNull String path) {
        return Objects.toString(this.config.get(path));
    }

    @Nullable
    public <T> T getConfig(@NotNull Class<T> clazz, @NotNull String path) {
        return (T)this.config.getObject(path, clazz);
    }

    @NotNull
    public List<String> getComments(@NotNull String path) {
        return this.config.getComments(path);
    }

    @NotNull
    public List<String> getInlineComments(@NotNull String path) {
        return this.config.getInlineComments(path);
    }

    public void setComments(@NotNull String path, @Nullable List<String> comments) {
        this.config.setComments(path, comments);
    }

    public void setInlineComments(@NotNull String path, @Nullable List<String> comments) {
        this.config.setInlineComments(path, comments);
    }

    @Override
    public void save() {
        File file = this.files[0];
        try {
            this.config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u65e0\u6cd5\u4fdd\u5b58\u6587\u4ef6: " + file.getName());
        }
    }

    public void reload() {
        File file = this.files[0];
        try {
            this.config.load(file);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException("\u65e0\u6cd5\u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6: " + file.getName());
        }
    }

    @Override
    @NotNull
    protected YamlConfiguration load(@NotNull File file) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            if (!file.exists()) {
                InputStream inputStream = this.plugin.getResource(this.name + ".yml");
                if (inputStream == null) {
                    return config;
                }
                config.load((Reader)new InputStreamReader(inputStream));
                return config;
            }
            config.load(file);
            return config;
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException("\u65e0\u6cd5\u52a0\u8f7d\u6570\u636e: " + file.getName());
        }
    }

    @Override
    @NotNull
    public File[] getFiles() {
        return this.files;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public File getFolder() {
        return this.folder;
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public YamlConfiguration getData() {
        return this.config;
    }
}

