/*
 * Decompiled with CFR 0.152.
 */
package top.shjibi.plugineer.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.shjibi.plugineer.config.Configurable;

public class Data
extends Configurable<Map<UUID, JsonObject>> {
    protected final Plugin plugin;
    protected final File folder;
    protected final File[] files;
    protected final Map<UUID, JsonObject> data;
    protected final String name;

    public Data(@NotNull Plugin plugin, @NotNull String name) {
        this(plugin, name, name);
    }

    public Data(@NotNull Plugin plugin, @NotNull String name, @NotNull String folderPath) {
        this.plugin = plugin;
        this.name = name;
        this.folder = this.mkdirs(plugin, folderPath);
        this.files = this.folder.listFiles(f -> f.isFile() && f.getName().endsWith(".json"));
        this.data = this.load(this.folder);
    }

    public void removeData(@Nullable UUID uuid) {
        this.data.remove(uuid);
    }

    public void addData(@NotNull UUID uuid, @NotNull JsonObject obj) {
        this.data.putIfAbsent(uuid, obj);
    }

    @Nullable
    public JsonObject setData(@NotNull UUID uuid, @NotNull JsonObject obj) {
        return this.data.put(uuid, obj);
    }

    @Nullable
    public JsonObject getData(@NotNull UUID uuid) {
        return this.data.get(uuid);
    }

    public void saveData(@NotNull UUID uuid) {
        File file = new File(this.folder.getAbsolutePath() + "\\" + uuid + ".json");
        try {
            Files.writeString(file.toPath(), (CharSequence)this.data.get(uuid).toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e");
        }
    }

    @Override
    public void save() {
        for (UUID uuid : this.data.keySet()) {
            this.saveData(uuid);
        }
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Map<UUID, JsonObject> getData() {
        return this.data;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public File getFolder() {
        return this.folder;
    }

    @Override
    @NotNull
    public File[] getFiles() {
        return this.files;
    }

    @Override
    @NotNull
    protected Map<UUID, JsonObject> load(@NotNull File folder) {
        HashMap<UUID, JsonObject> map = new HashMap<UUID, JsonObject>();
        if (this.files.length == 0) {
            return map;
        }
        for (File file : this.files) {
            try {
                String name = file.getName();
                UUID uuid = UUID.fromString(name.substring(0, name.length() - 5));
                String value = Files.readString(file.toPath(), StandardCharsets.UTF_8);
                JsonElement element = JsonParser.parseString((String)value);
                if (!(element instanceof JsonObject)) continue;
                JsonObject obj = (JsonObject)element;
                map.put(uuid, obj);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("\u65e0\u6cd5\u52a0\u8f7d\u6570\u636e: " + file.getName());
            }
        }
        return map;
    }
}

