/*
 * Decompiled with CFR 0.152.
 */
package top.shjibi.plugineer.util;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class ItemBuilder {
    private final ItemStack itemStack;
    private final ItemMeta itemMeta;

    private ItemBuilder(ItemStack item, ItemMeta meta) {
        this.itemStack = item;
        this.itemMeta = meta;
    }

    private ItemBuilder(Material material, int amount) {
        this.itemStack = new ItemStack(material, amount);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    private ItemBuilder(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemMeta = itemStack.getItemMeta();
    }

    @NotNull
    public static ItemBuilder of(@NotNull Material material, int amount) {
        return new ItemBuilder(material, amount);
    }

    @NotNull
    public static ItemBuilder of(@NotNull Material material) {
        return ItemBuilder.of(material, 1);
    }

    @NotNull
    public static ItemBuilder of(@NotNull ItemStack itemStack) {
        return new ItemBuilder(itemStack);
    }

    @NotNull
    public ItemBuilder withDisplayName(@NotNull String name) {
        this.itemMeta.setDisplayName(name);
        return this;
    }

    @NotNull
    public ItemBuilder withLore(String ... lore) {
        this.itemMeta.setLore(Arrays.asList(lore));
        return this;
    }

    @NotNull
    public ItemBuilder withLore(List<String> lore) {
        this.itemMeta.setLore(lore);
        return this;
    }

    @NotNull
    public ItemBuilder withAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        this.itemMeta.addAttributeModifier(attribute, modifier);
        return this;
    }

    @NotNull
    public ItemBuilder withoutAttributeModifier(@NotNull Attribute attribute) {
        this.itemMeta.removeAttributeModifier(attribute);
        return this;
    }

    @NotNull
    public ItemBuilder withoutAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        this.itemMeta.removeAttributeModifier(attribute);
        return this;
    }

    @NotNull
    public ItemBuilder withItemFlags(ItemFlag ... flags) {
        this.itemMeta.addItemFlags(flags);
        return this;
    }

    @NotNull
    public ItemBuilder withoutItemFlags(ItemFlag ... flags) {
        this.itemMeta.removeItemFlags(flags);
        return this;
    }

    @NotNull
    public ItemBuilder withEnchant(@NotNull Enchantment enchantment, int level, boolean ignoreLevelRestriction) {
        this.itemMeta.addEnchant(enchantment, level, ignoreLevelRestriction);
        return this;
    }

    @NotNull
    public ItemBuilder withoutEnchant(@NotNull Enchantment enchantment) {
        this.itemMeta.removeEnchant(enchantment);
        return this;
    }

    @NotNull
    public <T, Z> ItemBuilder withPersistentData(NamespacedKey key, PersistentDataType<T, Z> type, Z z) {
        this.itemMeta.getPersistentDataContainer().set(key, type, z);
        return this;
    }

    @NotNull
    public ItemBuilder withoutPersistentData(NamespacedKey key) {
        this.itemMeta.getPersistentDataContainer().remove(key);
        return this;
    }

    @NotNull
    public ItemMeta getItemMeta() {
        return this.itemMeta;
    }

    @NotNull
    public ItemStack build() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }

    public String toString() {
        return "ItemBuilder {material: " + this.itemStack.getType() + ", amount: " + this.itemStack.getAmount() + ", itemMeta: " + this.itemMeta + "}";
    }
}

