/*
 * Decompiled with CFR 0.152.
 */
package top.shjibi.plugineer.util;

import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NMSUtil {
    private NMSUtil() {
    }

    @NotNull
    public static String getVersion() {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(".") + 1);
    }

    @Nullable
    public static Class<?> getNMClass(@NotNull String name) {
        try {
            return Class.forName("net.minecraft." + name);
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().log(Level.WARNING, "\u65e0\u6cd5\u627e\u5230\u7c7b! (" + name + ")");
            return null;
        }
    }

    @Nullable
    public static Class<?> getNMSClass(@NotNull String name) {
        try {
            return Class.forName("net.minecraft.server." + NMSUtil.getVersion() + "." + name);
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().log(Level.WARNING, "\u65e0\u6cd5\u627e\u5230\u7c7b! (" + name + ")");
            return null;
        }
    }

    @Nullable
    public static Class<?> getCraftBukkitClass(@NotNull String name) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + NMSUtil.getVersion() + "." + name);
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().log(Level.WARNING, "\u65e0\u6cd5\u627e\u5230\u7c7b! (" + name + ")");
            return null;
        }
    }

    public static boolean sendPacket(@NotNull Player p, @NotNull Object packet) {
        try {
            Class<?> packetClass = Class.forName("net.minecraft.network.protocol.Packet");
            if (!packetClass.isAssignableFrom(packet.getClass())) {
                return false;
            }
            Object entityPlayer = p.getClass().getMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
            Object connection = entityPlayer.getClass().getField("b").get(entityPlayer);
            connection.getClass().getMethod("a", packetClass).invoke(connection, packet);
            return true;
        }
        catch (ReflectiveOperationException e) {
            Bukkit.getLogger().log(Level.WARNING, "\u65e0\u6cd5\u53d1\u9001\u5305: " + packet.getClass().getSimpleName());
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    public static Object asNMSCopy(@NotNull ItemStack item) {
        try {
            Class<?> itemClass = NMSUtil.getCraftBukkitClass("inventory.CraftItemStack");
            if (itemClass == null) {
                throw new ReflectiveOperationException();
            }
            return itemClass.getMethod("asNMSCopy", ItemStack.class).invoke(null, item);
        }
        catch (ReflectiveOperationException e) {
            Bukkit.getLogger().log(Level.WARNING, "\u65e0\u6cd5\u83b7\u53d6NMS\u7269\u54c1");
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static String getItemNBT(@NotNull ItemStack item) {
        try {
            Object nmsItem = NMSUtil.asNMSCopy(item);
            if (nmsItem == null) {
                return null;
            }
            Object nbt = nmsItem.getClass().getMethod("u", new Class[0]).invoke(nmsItem, new Object[0]);
            return (String)nbt.getClass().getMethod("toString", new Class[0]).invoke(nbt, new Object[0]);
        }
        catch (NullPointerException | ReflectiveOperationException e) {
            Bukkit.getLogger().log(Level.WARNING, "\u65e0\u6cd5\u83b7\u53d6\u7269\u54c1NBT");
            e.printStackTrace();
            return null;
        }
    }
}

