/*
 * Decompiled with CFR 0.152.
 */
package top.shjibi.plugineer.util;

import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class StringUtil {
    private static final Pattern colorPattern = Pattern.compile("&([\\da-fk-orx])");
    private static final Pattern stripPattern = Pattern.compile("[&\u00a7]([\\da-fk-orx])");

    private StringUtil() {
    }

    @NotNull
    public static String color(@NotNull String s) {
        return colorPattern.matcher(s).replaceAll("\u00a7$1");
    }

    @NotNull
    public static String strip(@NotNull String s) {
        return stripPattern.matcher(s).replaceAll("");
    }

    @NotNull
    public static String remove(@NotNull String s, String ... remove) {
        for (String r : remove) {
            s = s.replace(r, "");
        }
        return s;
    }

    @NotNull
    public static String join(@NotNull String s, String ... elements) {
        return StringUtil.join(s, 0, elements);
    }

    @NotNull
    public static String join(@NotNull String s, int start, String ... elements) {
        if (start >= elements.length) {
            start = 0;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < elements.length; ++i) {
            builder.append(elements[i]).append(s);
        }
        return builder.substring(0, builder.length() - 1);
    }

    @NotNull
    public static String join(@NotNull String s, @NotNull List<String> elements) {
        return StringUtil.join(s, elements.toArray(new String[0]));
    }
}

