package top.snowed.word;

import java.io.FileInputStream;
import java.io.FileOutputStream;

class Main {

    public static void main(String[] args) throws Exception {
        String build = new WordUtil()
                .setHtmlConversionFactory(new WordUtil.HtmlConversionFactory() {
                    @Override
                    public HtmlUtil setHtmlUtil(HtmlUtil htmlUtil) {
                        //允许图片转为base64
                        htmlUtil.setConversionImage(true);
                        //设置编码格式
                        htmlUtil.setCharsetName("UTF-8");
                        //允许添加css样式-仿word
                        htmlUtil.setHtmlCssAppend(true);
                        //保留原有css样式
                        htmlUtil.setHtmlCssKeep(true);
                        //允许合并css样式
                        htmlUtil.setHtmlCssMerge(true);
                        //允许网页参数合并
                        htmlUtil.setHtmlParameterCombination(true);
                        //允许网页参数整改
                        htmlUtil.setHtmlParameterRectification(true);
                        //智能切割
                        htmlUtil.setSmartCutting(true);
                        //保留页眉
                        htmlUtil.setNeedHead(true);
                        //保留页脚
                        htmlUtil.setNeedFoot(true);
                        //限定宽度
                        htmlUtil.setHtmlCssTemplate(HtmlUtil.CSS_TEMPLATE_TWO);
                        return htmlUtil;
                    }
                })
                .setFileDelete(true)
                .build(new FileInputStream("D:\\保留文档\\电子枪装配记录卡.doc"));
        FileOutputStream fileOutputStream = new FileOutputStream("D:\\保留文档\\word.html");
        fileOutputStream.write(build.getBytes("UTF-8"));
        fileOutputStream.close();
        System.out.println("完成");
    }
}
