/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class W3CDom {
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public W3CDom() {
        this.factory.setNamespaceAware(true);
    }

    public static org.w3c.dom.Document convert(Document document) {
        return new W3CDom().fromJsoup(document);
    }

    public static String asString(org.w3c.dom.Document document, Map<String, String> map) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            if (map != null) {
                transformer.setOutputProperties(W3CDom.propertiesFromMap(map));
            }
            if (document.getDoctype() != null) {
                DocumentType documentType = document.getDoctype();
                if (!StringUtil.isBlank(documentType.getPublicId())) {
                    transformer.setOutputProperty("doctype-public", documentType.getPublicId());
                }
                if (!StringUtil.isBlank(documentType.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", documentType.getSystemId());
                } else if (documentType.getName().equalsIgnoreCase("html") && StringUtil.isBlank(documentType.getPublicId()) && StringUtil.isBlank(documentType.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", "about:legacy-compat");
                }
            }
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException);
        }
    }

    static Properties propertiesFromMap(Map<String, String> map) {
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    public static HashMap<String, String> OutputHtml() {
        return W3CDom.methodMap("html");
    }

    public static HashMap<String, String> OutputXml() {
        return W3CDom.methodMap("xml");
    }

    private static HashMap<String, String> methodMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("method", string);
        return hashMap;
    }

    public org.w3c.dom.Document fromJsoup(Document document) {
        Validate.notNull(document);
        try {
            DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            org.w3c.dom.Document document2 = documentBuilder.newDocument();
            org.jsoup.nodes.DocumentType documentType = document.documentType();
            if (documentType != null) {
                DocumentType documentType2 = dOMImplementation.createDocumentType(documentType.name(), documentType.publicId(), documentType.systemId());
                document2.appendChild(documentType2);
            }
            document2.setXmlStandalone(true);
            this.convert(document, document2);
            return document2;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
    }

    public void convert(Document document, org.w3c.dom.Document document2) {
        if (!StringUtil.isBlank(document.location())) {
            document2.setDocumentURI(document.location());
        }
        org.jsoup.nodes.Element element = document.child(0);
        NodeTraversor.traverse((NodeVisitor)new W3CBuilder(document2), element);
    }

    public String asString(org.w3c.dom.Document document) {
        return W3CDom.asString(document, null);
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "xmlns";
        private static final String xmlnsPrefix = "xmlns:";
        private final org.w3c.dom.Document doc;
        private final Stack<HashMap<String, String>> namespacesStack = new Stack();
        private Element dest;

        public W3CBuilder(org.w3c.dom.Document document) {
            this.doc = document;
            this.namespacesStack.push(new HashMap());
        }

        @Override
        public void head(Node node, int n) {
            this.namespacesStack.push(new HashMap(this.namespacesStack.peek()));
            if (node instanceof org.jsoup.nodes.Element) {
                org.jsoup.nodes.Element element = (org.jsoup.nodes.Element)node;
                String string = this.updateNamespaces(element);
                String string2 = this.namespacesStack.peek().get(string);
                String string3 = element.tagName();
                Element element2 = string2 == null && string3.contains(":") ? this.doc.createElementNS("", string3) : this.doc.createElementNS(string2, string3);
                this.copyAttributes(element, element2);
                if (this.dest == null) {
                    this.doc.appendChild(element2);
                } else {
                    this.dest.appendChild(element2);
                }
                this.dest = element2;
            } else if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                Text text = this.doc.createTextNode(textNode.getWholeText());
                this.dest.appendChild(text);
            } else if (node instanceof org.jsoup.nodes.Comment) {
                org.jsoup.nodes.Comment comment = (org.jsoup.nodes.Comment)node;
                Comment comment2 = this.doc.createComment(comment.getData());
                this.dest.appendChild(comment2);
            } else if (node instanceof DataNode) {
                DataNode dataNode = (DataNode)node;
                Text text = this.doc.createTextNode(dataNode.getWholeData());
                this.dest.appendChild(text);
            }
        }

        @Override
        public void tail(Node node, int n) {
            if (node instanceof org.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = (Element)this.dest.getParentNode();
            }
            this.namespacesStack.pop();
        }

        private void copyAttributes(Node node, Element element) {
            for (Attribute attribute : node.attributes()) {
                String string = attribute.getKey().replaceAll("[^-a-zA-Z0-9_:.]", "");
                if (!string.matches("[a-zA-Z_:][-a-zA-Z0-9_:.]*")) continue;
                element.setAttribute(string, attribute.getValue());
            }
        }

        private String updateNamespaces(org.jsoup.nodes.Element element) {
            Attributes attributes = element.attributes();
            for (Attribute attribute : attributes) {
                String string;
                String string2 = attribute.getKey();
                if (string2.equals(xmlnsKey)) {
                    string = "";
                } else {
                    if (!string2.startsWith(xmlnsPrefix)) continue;
                    string = string2.substring(xmlnsPrefix.length());
                }
                this.namespacesStack.peek().put(string, attribute.getValue());
            }
            int n = element.tagName().indexOf(":");
            return n > 0 ? element.tagName().substring(0, n) : "";
        }
    }
}

