/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.jsoup.helper.Validate;

public final class ConstrainableInputStream
extends BufferedInputStream {
    private static final int DefaultSize = 32768;
    private final boolean capped;
    private final int maxSize;
    private long startTime;
    private long timeout = 0L;
    private int remaining;
    private boolean interrupted;

    private ConstrainableInputStream(InputStream inputStream, int n, int n2) {
        super(inputStream, n);
        Validate.isTrue(n2 >= 0);
        this.maxSize = n2;
        this.remaining = n2;
        this.capped = n2 != 0;
        this.startTime = System.nanoTime();
    }

    public static ConstrainableInputStream wrap(InputStream inputStream, int n, int n2) {
        return inputStream instanceof ConstrainableInputStream ? (ConstrainableInputStream)inputStream : new ConstrainableInputStream(inputStream, n, n2);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.interrupted || this.capped && this.remaining <= 0) {
            return -1;
        }
        if (Thread.interrupted()) {
            this.interrupted = true;
            return -1;
        }
        if (this.expired()) {
            throw new SocketTimeoutException("Read timeout");
        }
        if (this.capped && n2 > this.remaining) {
            n2 = this.remaining;
        }
        try {
            int n3 = super.read(byArray, n, n2);
            this.remaining -= n3;
            return n3;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return 0;
        }
    }

    public ByteBuffer readToByteBuffer(int n) throws IOException {
        int n2;
        Validate.isTrue(n >= 0, "maxSize must be 0 (unlimited) or larger");
        boolean bl = n > 0;
        int n3 = bl && n < 32768 ? n : 32768;
        byte[] byArray = new byte[n3];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        int n4 = n;
        while ((n2 = this.read(byArray)) != -1) {
            if (bl) {
                if (n2 >= n4) {
                    byteArrayOutputStream.write(byArray, 0, n4);
                    break;
                }
                n4 -= n2;
            }
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.remaining = this.maxSize - this.markpos;
    }

    public ConstrainableInputStream timeout(long l, long l2) {
        this.startTime = l;
        this.timeout = l2 * 1000000L;
        return this;
    }

    private boolean expired() {
        if (this.timeout == 0L) {
            return false;
        }
        long l = System.nanoTime();
        long l2 = l - this.startTime;
        return l2 > this.timeout;
    }
}

