/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.jsoup.helper.Validate;

public final class StringUtil {
    static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   ", "                    "};
    private static final Stack<StringBuilder> builders = new Stack();
    private static final int MaxCachedBuilderSize = 8192;
    private static final int MaxIdleBuilders = 8;

    public static String join(Collection collection, String string) {
        return StringUtil.join(collection.iterator(), string);
    }

    public static String join(Iterator iterator, String string) {
        if (!iterator.hasNext()) {
            return "";
        }
        String string2 = iterator.next().toString();
        if (!iterator.hasNext()) {
            return string2;
        }
        StringBuilder stringBuilder = StringUtil.borrowBuilder().append(string2);
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(iterator.next());
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    public static String join(String[] stringArray, String string) {
        return StringUtil.join(Arrays.asList(stringArray), string);
    }

    public static String padding(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (n < padding.length) {
            return padding[n];
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return String.valueOf(cArray);
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (StringUtil.isWhitespace(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 12 || n == 13;
    }

    public static boolean isActuallyWhitespace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 12 || n == 13 || n == 160;
    }

    public static boolean isInvisibleChar(int n) {
        return n == 8203 || n == 173;
    }

    public static String normaliseWhitespace(String string) {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        StringUtil.appendNormalisedWhitespace(stringBuilder, string, false);
        return StringUtil.releaseBuilder(stringBuilder);
    }

    public static void appendNormalisedWhitespace(StringBuilder stringBuilder, String string, boolean bl) {
        int n;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (StringUtil.isActuallyWhitespace(n)) {
                if (bl && !bl3 || bl2) continue;
                stringBuilder.append(' ');
                bl2 = true;
                continue;
            }
            if (StringUtil.isInvisibleChar(n)) continue;
            stringBuilder.appendCodePoint(n);
            bl2 = false;
            bl3 = true;
        }
    }

    public static boolean in(String string, String ... stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean inSorted(String string, String[] stringArray) {
        return Arrays.binarySearch(stringArray, string) >= 0;
    }

    public static URL resolve(URL uRL, String string) throws MalformedURLException {
        if (string.startsWith("?")) {
            string = uRL.getPath() + string;
        }
        if (string.indexOf(46) == 0 && uRL.getFile().indexOf(47) != 0) {
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/" + uRL.getFile());
        }
        return new URL(uRL, string);
    }

    public static String resolve(String string, String string2) {
        try {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                URL uRL2 = new URL(string2);
                return uRL2.toExternalForm();
            }
            return StringUtil.resolve(uRL, string2).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder borrowBuilder() {
        Stack<StringBuilder> stack = builders;
        synchronized (stack) {
            return builders.empty() ? new StringBuilder(8192) : builders.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String releaseBuilder(StringBuilder stringBuilder) {
        Validate.notNull(stringBuilder);
        String string = stringBuilder.toString();
        if (stringBuilder.length() > 8192) {
            stringBuilder = new StringBuilder(8192);
        } else {
            stringBuilder.delete(0, stringBuilder.length());
        }
        Stack<StringBuilder> stack = builders;
        synchronized (stack) {
            builders.push(stringBuilder);
            while (builders.size() > 8) {
                builders.pop();
            }
        }
        return string;
    }
}

