/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;

public class Attribute
implements Cloneable,
Map.Entry<String, String> {
    private static final String[] booleanAttributes = new String[]{"allowfullscreen", "async", "autofocus", "checked", "compact", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "inert", "ismap", "itemscope", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "readonly", "required", "reversed", "seamless", "selected", "sortable", "truespeed", "typemustmatch"};
    private String key;
    private String val;
    Attributes parent;

    public Attribute(String string, String string2) {
        this(string, string2, null);
    }

    public Attribute(String string, String string2, Attributes attributes) {
        Validate.notNull(string);
        string = string.trim();
        Validate.notEmpty(string);
        this.key = string;
        this.val = string2;
        this.parent = attributes;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        int n;
        Validate.notNull(string);
        string = string.trim();
        Validate.notEmpty(string);
        if (this.parent != null && (n = this.parent.indexOfKey(this.key)) != -1) {
            this.parent.keys[n] = string;
        }
        this.key = string;
    }

    @Override
    public String getValue() {
        return Attributes.checkNotNull(this.val);
    }

    public boolean hasDeclaredValue() {
        return this.val != null;
    }

    @Override
    public String setValue(String string) {
        String string2 = this.val;
        if (this.parent != null) {
            string2 = this.parent.get(this.key);
            int n = this.parent.indexOfKey(this.key);
            if (n != -1) {
                this.parent.vals[n] = string;
            }
        }
        this.val = string;
        return Attributes.checkNotNull(string2);
    }

    public String html() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        try {
            this.html(stringBuilder, new Document("").outputSettings());
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    protected static void html(String string, String string2, Appendable appendable, Document.OutputSettings outputSettings) throws IOException {
        appendable.append(string);
        if (!Attribute.shouldCollapseAttribute(string, string2, outputSettings)) {
            appendable.append("=\"");
            Entities.escape(appendable, Attributes.checkNotNull(string2), outputSettings, true, false, false);
            appendable.append('\"');
        }
    }

    protected void html(Appendable appendable, Document.OutputSettings outputSettings) throws IOException {
        Attribute.html(this.key, this.val, appendable, outputSettings);
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String string, String string2) {
        String string3 = Entities.unescape(string2, true);
        return new Attribute(string, string3, null);
    }

    protected boolean isDataAttribute() {
        return Attribute.isDataAttribute(this.key);
    }

    protected static boolean isDataAttribute(String string) {
        return string.startsWith("data-") && string.length() > "data-".length();
    }

    protected final boolean shouldCollapseAttribute(Document.OutputSettings outputSettings) {
        return Attribute.shouldCollapseAttribute(this.key, this.val, outputSettings);
    }

    protected static boolean shouldCollapseAttribute(String string, String string2, Document.OutputSettings outputSettings) {
        return outputSettings.syntax() == Document.OutputSettings.Syntax.html && (string2 == null || ("".equals(string2) || string2.equalsIgnoreCase(string)) && Attribute.isBooleanAttribute(string));
    }

    protected static boolean isBooleanAttribute(String string) {
        return Arrays.binarySearch(booleanAttributes, string) >= 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        if (this.key != null ? !this.key.equals(attribute.key) : attribute.key != null) {
            return false;
        }
        return this.val != null ? this.val.equals(attribute.val) : attribute.val == null;
    }

    @Override
    public int hashCode() {
        int n = this.key != null ? this.key.hashCode() : 0;
        n = 31 * n + (this.val != null ? this.val.hashCode() : 0);
        return n;
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

