/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Parser;

public class Comment
extends LeafNode {
    public Comment(String string) {
        this.value = string;
    }

    @Override
    public String nodeName() {
        return "#comment";
    }

    public String getData() {
        return this.coreValue();
    }

    public Comment setData(String string) {
        this.coreValue(string);
        return this;
    }

    @Override
    void outerHtmlHead(Appendable appendable, int n, Document.OutputSettings outputSettings) throws IOException {
        if (outputSettings.prettyPrint() && (this.siblingIndex() == 0 && this.parentNode instanceof Element && ((Element)this.parentNode).tag().formatAsBlock() || outputSettings.outline())) {
            this.indent(appendable, n, outputSettings);
        }
        appendable.append("<!--").append(this.getData()).append("-->");
    }

    @Override
    void outerHtmlTail(Appendable appendable, int n, Document.OutputSettings outputSettings) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public Comment clone() {
        return (Comment)super.clone();
    }

    public boolean isXmlDeclaration() {
        String string = this.getData();
        return string.length() > 1 && (string.startsWith("!") || string.startsWith("?"));
    }

    public XmlDeclaration asXmlDeclaration() {
        String string = this.getData();
        Document document = Jsoup.parse("<" + string.substring(1, string.length() - 1) + ">", this.baseUri(), Parser.xmlParser());
        XmlDeclaration xmlDeclaration = null;
        if (document.children().size() > 0) {
            Element element = document.child(0);
            xmlDeclaration = new XmlDeclaration(NodeUtils.parser(document).settings().normalizeTag(element.tagName()), string.startsWith("!"));
            xmlDeclaration.attributes().addAll(element.attributes());
        }
        return xmlDeclaration;
    }
}

