/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jsoup.helper.ChangeNotifyingArrayList;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.QueryParser;
import org.jsoup.select.Selector;

public class Element
extends Node {
    private static final List<Node> EMPTY_NODES = Collections.emptyList();
    private static final Pattern classSplit = Pattern.compile("\\s+");
    private static final String baseUriKey = Attributes.internalKey("baseUri");
    private Tag tag;
    private WeakReference<List<Element>> shadowChildrenRef;
    List<Node> childNodes;
    private Attributes attributes;

    public Element(String string) {
        this(Tag.valueOf(string), "", null);
    }

    public Element(Tag tag, String string, Attributes attributes) {
        Validate.notNull(tag);
        this.childNodes = EMPTY_NODES;
        this.attributes = attributes;
        this.tag = tag;
        if (string != null) {
            this.setBaseUri(string);
        }
    }

    public Element(Tag tag, String string) {
        this(tag, string, null);
    }

    @Override
    protected List<Node> ensureChildNodes() {
        if (this.childNodes == EMPTY_NODES) {
            this.childNodes = new NodeList(this, 4);
        }
        return this.childNodes;
    }

    @Override
    protected boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public Attributes attributes() {
        if (!this.hasAttributes()) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public String baseUri() {
        return Element.searchUpForAttribute(this, baseUriKey);
    }

    private static String searchUpForAttribute(Element element, String string) {
        for (Element element2 = element; element2 != null; element2 = element2.parent()) {
            if (!element2.hasAttributes() || !element2.attributes.hasKey(string)) continue;
            return element2.attributes.get(string);
        }
        return "";
    }

    @Override
    protected void doSetBaseUri(String string) {
        this.attributes().put(baseUriKey, string);
    }

    @Override
    public int childNodeSize() {
        return this.childNodes.size();
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    public String normalName() {
        return this.tag.normalName();
    }

    public Element tagName(String string) {
        Validate.notEmpty(string, "Tag name must not be empty.");
        this.tag = Tag.valueOf(string, NodeUtils.parser(this).settings());
        return this;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        return this.hasAttributes() ? this.attributes.getIgnoreCase("id") : "";
    }

    @Override
    public Element attr(String string, String string2) {
        super.attr(string, string2);
        return this;
    }

    public Element attr(String string, boolean bl) {
        this.attributes().put(string, bl);
        return this;
    }

    public Map<String, String> dataset() {
        return this.attributes().dataset();
    }

    @Override
    public final Element parent() {
        return (Element)this.parentNode;
    }

    public Elements parents() {
        Elements elements = new Elements();
        Element.accumulateParents(this, elements);
        return elements;
    }

    private static void accumulateParents(Element element, Elements elements) {
        Element element2 = element.parent();
        if (element2 != null && !element2.tagName().equals("#root")) {
            elements.add(element2);
            Element.accumulateParents(element2, elements);
        }
    }

    public Element child(int n) {
        return this.childElementsList().get(n);
    }

    public int childrenSize() {
        return this.childElementsList().size();
    }

    public Elements children() {
        return new Elements(this.childElementsList());
    }

    private List<Element> childElementsList() {
        ArrayList<Element> arrayList;
        if (this.shadowChildrenRef == null || (arrayList = (ArrayList<Element>)this.shadowChildrenRef.get()) == null) {
            int n = this.childNodes.size();
            arrayList = new ArrayList<Element>(n);
            for (int i = 0; i < n; ++i) {
                Node node = this.childNodes.get(i);
                if (!(node instanceof Element)) continue;
                arrayList.add((Element)node);
            }
            this.shadowChildrenRef = new WeakReference(arrayList);
        }
        return arrayList;
    }

    @Override
    void nodelistChanged() {
        super.nodelistChanged();
        this.shadowChildrenRef = null;
    }

    public List<TextNode> textNodes() {
        ArrayList<TextNode> arrayList = new ArrayList<TextNode>();
        for (Node node : this.childNodes) {
            if (!(node instanceof TextNode)) continue;
            arrayList.add((TextNode)node);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<DataNode> dataNodes() {
        ArrayList<DataNode> arrayList = new ArrayList<DataNode>();
        for (Node node : this.childNodes) {
            if (!(node instanceof DataNode)) continue;
            arrayList.add((DataNode)node);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Elements select(String string) {
        return Selector.select(string, this);
    }

    public Elements select(Evaluator evaluator) {
        return Selector.select(evaluator, this);
    }

    public Element selectFirst(String string) {
        return Selector.selectFirst(string, this);
    }

    public Element selectFirst(Evaluator evaluator) {
        return Collector.findFirst(evaluator, this);
    }

    public boolean is(String string) {
        return this.is(QueryParser.parse(string));
    }

    public boolean is(Evaluator evaluator) {
        return evaluator.matches(this.root(), this);
    }

    public Element closest(String string) {
        return this.closest(QueryParser.parse(string));
    }

    public Element closest(Evaluator evaluator) {
        Validate.notNull(evaluator);
        Element element = this;
        Element element2 = this.root();
        do {
            if (!evaluator.matches(element2, element)) continue;
            return element;
        } while ((element = element.parent()) != null);
        return null;
    }

    public Element appendChild(Node node) {
        Validate.notNull(node);
        this.reparentChild(node);
        this.ensureChildNodes();
        this.childNodes.add(node);
        node.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    public Element appendTo(Element element) {
        Validate.notNull(element);
        element.appendChild(this);
        return this;
    }

    public Element prependChild(Node node) {
        Validate.notNull(node);
        this.addChildren(0, node);
        return this;
    }

    public Element insertChildren(int n, Collection<? extends Node> collection) {
        Validate.notNull(collection, "Children collection to be inserted must not be null.");
        int n2 = this.childNodeSize();
        if (n < 0) {
            n += n2 + 1;
        }
        Validate.isTrue(n >= 0 && n <= n2, "Insert position out of bounds.");
        ArrayList<? extends Node> arrayList = new ArrayList<Node>(collection);
        Node[] nodeArray = arrayList.toArray(new Node[0]);
        this.addChildren(n, nodeArray);
        return this;
    }

    public Element insertChildren(int n, Node ... nodeArray) {
        Validate.notNull(nodeArray, "Children collection to be inserted must not be null.");
        int n2 = this.childNodeSize();
        if (n < 0) {
            n += n2 + 1;
        }
        Validate.isTrue(n >= 0 && n <= n2, "Insert position out of bounds.");
        this.addChildren(n, nodeArray);
        return this;
    }

    public Element appendElement(String string) {
        Element element = new Element(Tag.valueOf(string, NodeUtils.parser(this).settings()), this.baseUri());
        this.appendChild(element);
        return element;
    }

    public Element prependElement(String string) {
        Element element = new Element(Tag.valueOf(string, NodeUtils.parser(this).settings()), this.baseUri());
        this.prependChild(element);
        return element;
    }

    public Element appendText(String string) {
        Validate.notNull(string);
        TextNode textNode = new TextNode(string);
        this.appendChild(textNode);
        return this;
    }

    public Element prependText(String string) {
        Validate.notNull(string);
        TextNode textNode = new TextNode(string);
        this.prependChild(textNode);
        return this;
    }

    public Element append(String string) {
        Validate.notNull(string);
        List<Node> list = NodeUtils.parser(this).parseFragmentInput(string, this, this.baseUri());
        this.addChildren(list.toArray(new Node[0]));
        return this;
    }

    public Element prepend(String string) {
        Validate.notNull(string);
        List<Node> list = NodeUtils.parser(this).parseFragmentInput(string, this, this.baseUri());
        this.addChildren(0, list.toArray(new Node[0]));
        return this;
    }

    @Override
    public Element before(String string) {
        return (Element)super.before(string);
    }

    @Override
    public Element before(Node node) {
        return (Element)super.before(node);
    }

    @Override
    public Element after(String string) {
        return (Element)super.after(string);
    }

    @Override
    public Element after(Node node) {
        return (Element)super.after(node);
    }

    @Override
    public Element empty() {
        this.childNodes.clear();
        return this;
    }

    @Override
    public Element wrap(String string) {
        return (Element)super.wrap(string);
    }

    public String cssSelector() {
        if (this.id().length() > 0) {
            return "#" + this.id();
        }
        String string = this.tagName().replace(':', '|');
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = StringUtil.join(this.classNames(), ".");
        if (string2.length() > 0) {
            stringBuilder.append('.').append(string2);
        }
        if (this.parent() == null || this.parent() instanceof Document) {
            return stringBuilder.toString();
        }
        stringBuilder.insert(0, " > ");
        if (this.parent().select(stringBuilder.toString()).size() > 1) {
            stringBuilder.append(String.format(":nth-child(%d)", this.elementSiblingIndex() + 1));
        }
        return this.parent().cssSelector() + stringBuilder.toString();
    }

    public Elements siblingElements() {
        if (this.parentNode == null) {
            return new Elements(0);
        }
        List<Element> list = this.parent().childElementsList();
        Elements elements = new Elements(list.size() - 1);
        for (Element element : list) {
            if (element == this) continue;
            elements.add(element);
        }
        return elements;
    }

    public Element nextElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Element> list = this.parent().childElementsList();
        int n = Element.indexInList(this, list);
        if (list.size() > n + 1) {
            return list.get(n + 1);
        }
        return null;
    }

    public Elements nextElementSiblings() {
        return this.nextElementSiblings(true);
    }

    public Element previousElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Element> list = this.parent().childElementsList();
        int n = Element.indexInList(this, list);
        if (n > 0) {
            return list.get(n - 1);
        }
        return null;
    }

    public Elements previousElementSiblings() {
        return this.nextElementSiblings(false);
    }

    private Elements nextElementSiblings(boolean bl) {
        Elements elements = new Elements();
        if (this.parentNode == null) {
            return elements;
        }
        elements.add(this);
        return bl ? elements.nextAll() : elements.prevAll();
    }

    public Element firstElementSibling() {
        List<Element> list = this.parent().childElementsList();
        return list.size() > 1 ? list.get(0) : null;
    }

    public int elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().childElementsList());
    }

    public Element lastElementSibling() {
        List<Element> list = this.parent().childElementsList();
        return list.size() > 1 ? list.get(list.size() - 1) : null;
    }

    private static <E extends Element> int indexInList(Element element, List<E> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return 0;
    }

    public Elements getElementsByTag(String string) {
        Validate.notEmpty(string);
        string = Normalizer.normalize(string);
        return Collector.collect(new Evaluator.Tag(string), this);
    }

    public Element getElementById(String string) {
        Validate.notEmpty(string);
        Elements elements = Collector.collect(new Evaluator.Id(string), this);
        if (elements.size() > 0) {
            return (Element)elements.get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String string) {
        Validate.notEmpty(string);
        return Collector.collect(new Evaluator.Class(string), this);
    }

    public Elements getElementsByAttribute(String string) {
        Validate.notEmpty(string);
        string = string.trim();
        return Collector.collect(new Evaluator.Attribute(string), this);
    }

    public Elements getElementsByAttributeStarting(String string) {
        Validate.notEmpty(string);
        string = string.trim();
        return Collector.collect(new Evaluator.AttributeStarting(string), this);
    }

    public Elements getElementsByAttributeValue(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValue(string, string2), this);
    }

    public Elements getElementsByAttributeValueNot(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(string, string2), this);
    }

    public Elements getElementsByAttributeValueStarting(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(string, string2), this);
    }

    public Elements getElementsByAttributeValueEnding(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(string, string2), this);
    }

    public Elements getElementsByAttributeValueContaining(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(string, string2), this);
    }

    public Elements getElementsByAttributeValueMatching(String string, Pattern pattern) {
        return Collector.collect(new Evaluator.AttributeWithValueMatching(string, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String string, String string2) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: " + string2, patternSyntaxException);
        }
        return this.getElementsByAttributeValueMatching(string, pattern);
    }

    public Elements getElementsByIndexLessThan(int n) {
        return Collector.collect(new Evaluator.IndexLessThan(n), this);
    }

    public Elements getElementsByIndexGreaterThan(int n) {
        return Collector.collect(new Evaluator.IndexGreaterThan(n), this);
    }

    public Elements getElementsByIndexEquals(int n) {
        return Collector.collect(new Evaluator.IndexEquals(n), this);
    }

    public Elements getElementsContainingText(String string) {
        return Collector.collect(new Evaluator.ContainsText(string), this);
    }

    public Elements getElementsContainingOwnText(String string) {
        return Collector.collect(new Evaluator.ContainsOwnText(string), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String string) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: " + string, patternSyntaxException);
        }
        return this.getElementsMatchingText(pattern);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String string) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: " + string, patternSyntaxException);
        }
        return this.getElementsMatchingOwnText(pattern);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        final StringBuilder stringBuilder = StringUtil.borrowBuilder();
        NodeTraversor.traverse(new NodeVisitor(){

            @Override
            public void head(Node node, int n) {
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    Element.appendNormalisedText(stringBuilder, textNode);
                } else if (node instanceof Element) {
                    Element element = (Element)node;
                    if (stringBuilder.length() > 0 && (element.isBlock() || element.tag.getName().equals("br")) && !TextNode.lastCharIsWhitespace(stringBuilder)) {
                        stringBuilder.append(' ');
                    }
                }
            }

            @Override
            public void tail(Node node, int n) {
                Element element;
                if (node instanceof Element && (element = (Element)node).isBlock() && node.nextSibling() instanceof TextNode && !TextNode.lastCharIsWhitespace(stringBuilder)) {
                    stringBuilder.append(' ');
                }
            }
        }, this);
        return StringUtil.releaseBuilder(stringBuilder).trim();
    }

    public String wholeText() {
        final StringBuilder stringBuilder = StringUtil.borrowBuilder();
        NodeTraversor.traverse(new NodeVisitor(){

            @Override
            public void head(Node node, int n) {
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    stringBuilder.append(textNode.getWholeText());
                }
            }

            @Override
            public void tail(Node node, int n) {
            }
        }, this);
        return StringUtil.releaseBuilder(stringBuilder);
    }

    public String ownText() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        this.ownText(stringBuilder);
        return StringUtil.releaseBuilder(stringBuilder).trim();
    }

    private void ownText(StringBuilder stringBuilder) {
        for (Node node : this.childNodes) {
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                Element.appendNormalisedText(stringBuilder, textNode);
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element.appendWhitespaceIfBr((Element)node, stringBuilder);
        }
    }

    private static void appendNormalisedText(StringBuilder stringBuilder, TextNode textNode) {
        String string = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode) || textNode instanceof CDataNode) {
            stringBuilder.append(string);
        } else {
            StringUtil.appendNormalisedWhitespace(stringBuilder, string, TextNode.lastCharIsWhitespace(stringBuilder));
        }
    }

    private static void appendWhitespaceIfBr(Element element, StringBuilder stringBuilder) {
        if (element.tag.getName().equals("br") && !TextNode.lastCharIsWhitespace(stringBuilder)) {
            stringBuilder.append(" ");
        }
    }

    static boolean preserveWhitespace(Node node) {
        if (node instanceof Element) {
            Element element = (Element)node;
            int n = 0;
            do {
                if (element.tag.preserveWhitespace()) {
                    return true;
                }
                element = element.parent();
            } while (++n < 6 && element != null);
        }
        return false;
    }

    public Element text(String string) {
        Validate.notNull(string);
        this.empty();
        TextNode textNode = new TextNode(string);
        this.appendChild(textNode);
        return this;
    }

    public boolean hasText() {
        for (Node node : this.childNodes) {
            Node node2;
            if (!(node instanceof TextNode ? !((TextNode)(node2 = (TextNode)node)).isBlank() : node instanceof Element && ((Element)(node2 = (Element)node)).hasText())) continue;
            return true;
        }
        return false;
    }

    public String data() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        for (Node node : this.childNodes) {
            Node node2;
            if (node instanceof DataNode) {
                node2 = (DataNode)node;
                stringBuilder.append(((DataNode)node2).getWholeData());
                continue;
            }
            if (node instanceof Comment) {
                node2 = (Comment)node;
                stringBuilder.append(((Comment)node2).getData());
                continue;
            }
            if (node instanceof Element) {
                node2 = (Element)node;
                String string = ((Element)node2).data();
                stringBuilder.append(string);
                continue;
            }
            if (!(node instanceof CDataNode)) continue;
            node2 = (CDataNode)node;
            stringBuilder.append(((TextNode)node2).getWholeText());
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    public String className() {
        return this.attr("class").trim();
    }

    public Set<String> classNames() {
        String[] stringArray = classSplit.split(this.className());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        linkedHashSet.remove("");
        return linkedHashSet;
    }

    public Element classNames(Set<String> set) {
        Validate.notNull(set);
        if (set.isEmpty()) {
            this.attributes().remove("class");
        } else {
            this.attributes().put("class", StringUtil.join(set, " "));
        }
        return this;
    }

    public boolean hasClass(String string) {
        if (!this.hasAttributes()) {
            return false;
        }
        String string2 = this.attributes.getIgnoreCase("class");
        int n = string2.length();
        int n2 = string.length();
        if (n == 0 || n < n2) {
            return false;
        }
        if (n == n2) {
            return string.equalsIgnoreCase(string2);
        }
        boolean bl = false;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string2.charAt(i))) {
                if (!bl) continue;
                if (i - n3 == n2 && string2.regionMatches(true, n3, string, 0, n2)) {
                    return true;
                }
                bl = false;
                continue;
            }
            if (bl) continue;
            bl = true;
            n3 = i;
        }
        if (bl && n - n3 == n2) {
            return string2.regionMatches(true, n3, string, 0, n2);
        }
        return false;
    }

    public Element addClass(String string) {
        Validate.notNull(string);
        Set<String> set = this.classNames();
        set.add(string);
        this.classNames(set);
        return this;
    }

    public Element removeClass(String string) {
        Validate.notNull(string);
        Set<String> set = this.classNames();
        set.remove(string);
        this.classNames(set);
        return this;
    }

    public Element toggleClass(String string) {
        Validate.notNull(string);
        Set<String> set = this.classNames();
        if (set.contains(string)) {
            set.remove(string);
        } else {
            set.add(string);
        }
        this.classNames(set);
        return this;
    }

    public String val() {
        if (this.normalName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String string) {
        if (this.normalName().equals("textarea")) {
            this.text(string);
        } else {
            this.attr("value", string);
        }
        return this;
    }

    @Override
    void outerHtmlHead(Appendable appendable, int n, Document.OutputSettings outputSettings) throws IOException {
        if (outputSettings.prettyPrint() && this.isFormatAsBlock(outputSettings) && !this.isInlineable(outputSettings)) {
            if (appendable instanceof StringBuilder) {
                if (((StringBuilder)appendable).length() > 0) {
                    this.indent(appendable, n, outputSettings);
                }
            } else {
                this.indent(appendable, n, outputSettings);
            }
        }
        appendable.append('<').append(this.tagName());
        if (this.attributes != null) {
            this.attributes.html(appendable, outputSettings);
        }
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            if (outputSettings.syntax() == Document.OutputSettings.Syntax.html && this.tag.isEmpty()) {
                appendable.append('>');
            } else {
                appendable.append(" />");
            }
        } else {
            appendable.append('>');
        }
    }

    @Override
    void outerHtmlTail(Appendable appendable, int n, Document.OutputSettings outputSettings) throws IOException {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            if (outputSettings.prettyPrint() && !this.childNodes.isEmpty() && (this.tag.formatAsBlock() || outputSettings.outline() && (this.childNodes.size() > 1 || this.childNodes.size() == 1 && !(this.childNodes.get(0) instanceof TextNode)))) {
                this.indent(appendable, n, outputSettings);
            }
            appendable.append("</").append(this.tagName()).append('>');
        }
    }

    public String html() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        this.html(stringBuilder);
        String string = StringUtil.releaseBuilder(stringBuilder);
        return NodeUtils.outputSettings(this).prettyPrint() ? string.trim() : string;
    }

    @Override
    public <T extends Appendable> T html(T t) {
        int n = this.childNodes.size();
        for (int i = 0; i < n; ++i) {
            this.childNodes.get(i).outerHtml(t);
        }
        return t;
    }

    public Element html(String string) {
        this.empty();
        this.append(string);
        return this;
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }

    @Override
    public Element shallowClone() {
        return new Element(this.tag, this.baseUri(), this.attributes == null ? null : this.attributes.clone());
    }

    @Override
    protected Element doClone(Node node) {
        Element element = (Element)super.doClone(node);
        element.attributes = this.attributes != null ? this.attributes.clone() : null;
        element.childNodes = new NodeList(element, this.childNodes.size());
        element.childNodes.addAll(this.childNodes);
        element.setBaseUri(this.baseUri());
        return element;
    }

    @Override
    public Element clearAttributes() {
        if (this.attributes != null) {
            super.clearAttributes();
            this.attributes = null;
        }
        return this;
    }

    @Override
    public Element removeAttr(String string) {
        return (Element)super.removeAttr(string);
    }

    @Override
    public Element root() {
        return (Element)super.root();
    }

    @Override
    public Element traverse(NodeVisitor nodeVisitor) {
        return (Element)super.traverse(nodeVisitor);
    }

    @Override
    public Element filter(NodeFilter nodeFilter) {
        return (Element)super.filter(nodeFilter);
    }

    private boolean isFormatAsBlock(Document.OutputSettings outputSettings) {
        return this.tag.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || outputSettings.outline();
    }

    private boolean isInlineable(Document.OutputSettings outputSettings) {
        return this.tag().isInline() && !this.tag().isEmpty() && this.parent().isBlock() && this.previousSibling() != null && !outputSettings.outline();
    }

    private static final class NodeList
    extends ChangeNotifyingArrayList<Node> {
        private final Element owner;

        NodeList(Element element, int n) {
            super(n);
            this.owner = element;
        }

        @Override
        public void onContentsChanged() {
            this.owner.nodelistChanged();
        }
    }
}

