/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.HashMap;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.EntitiesData;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.Parser;

public class Entities {
    private static final int empty = -1;
    private static final String emptyName = "";
    static final int codepointRadix = 36;
    private static final char[] codeDelims = new char[]{',', ';'};
    private static final HashMap<String, String> multipoints = new HashMap();
    private static final Document.OutputSettings DefaultOutput = new Document.OutputSettings();

    private Entities() {
    }

    public static boolean isNamedEntity(String string) {
        return EscapeMode.extended.codepointForName(string) != -1;
    }

    public static boolean isBaseNamedEntity(String string) {
        return EscapeMode.base.codepointForName(string) != -1;
    }

    public static String getByName(String string) {
        String string2 = multipoints.get(string);
        if (string2 != null) {
            return string2;
        }
        int n = EscapeMode.extended.codepointForName(string);
        if (n != -1) {
            return new String(new int[]{n}, 0, 1);
        }
        return emptyName;
    }

    public static int codepointsForName(String string, int[] nArray) {
        String string2 = multipoints.get(string);
        if (string2 != null) {
            nArray[0] = string2.codePointAt(0);
            nArray[1] = string2.codePointAt(1);
            return 2;
        }
        int n = EscapeMode.extended.codepointForName(string);
        if (n != -1) {
            nArray[0] = n;
            return 1;
        }
        return 0;
    }

    public static String escape(String string, Document.OutputSettings outputSettings) {
        if (string == null) {
            return emptyName;
        }
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        try {
            Entities.escape(stringBuilder, string, outputSettings, false, false, false);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    public static String escape(String string) {
        return Entities.escape(string, DefaultOutput);
    }

    static void escape(Appendable appendable, String string, Document.OutputSettings outputSettings, boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n;
        boolean bl4 = false;
        boolean bl5 = false;
        EscapeMode escapeMode = outputSettings.escapeMode();
        CharsetEncoder charsetEncoder = outputSettings.encoder();
        CoreCharset coreCharset = outputSettings.coreCharset;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (bl2) {
                if (StringUtil.isWhitespace(n)) {
                    if (bl3 && !bl5 || bl4) continue;
                    appendable.append(' ');
                    bl4 = true;
                    continue;
                }
                bl4 = false;
                bl5 = true;
            }
            if (n < 65536) {
                char c = (char)n;
                switch (c) {
                    case '&': {
                        appendable.append("&amp;");
                        break;
                    }
                    case '\u00a0': {
                        if (escapeMode != EscapeMode.xhtml) {
                            appendable.append("&nbsp;");
                            break;
                        }
                        appendable.append("&#xa0;");
                        break;
                    }
                    case '<': {
                        if (!bl || escapeMode == EscapeMode.xhtml) {
                            appendable.append("&lt;");
                            break;
                        }
                        appendable.append(c);
                        break;
                    }
                    case '>': {
                        if (!bl) {
                            appendable.append("&gt;");
                            break;
                        }
                        appendable.append(c);
                        break;
                    }
                    case '\"': {
                        if (bl) {
                            appendable.append("&quot;");
                            break;
                        }
                        appendable.append(c);
                        break;
                    }
                    default: {
                        if (Entities.canEncode(coreCharset, c, charsetEncoder)) {
                            appendable.append(c);
                            break;
                        }
                        Entities.appendEncoded(appendable, escapeMode, n);
                        break;
                    }
                }
                continue;
            }
            String string2 = new String(Character.toChars(n));
            if (charsetEncoder.canEncode(string2)) {
                appendable.append(string2);
                continue;
            }
            Entities.appendEncoded(appendable, escapeMode, n);
        }
    }

    private static void appendEncoded(Appendable appendable, EscapeMode escapeMode, int n) throws IOException {
        String string = escapeMode.nameForCodepoint(n);
        if (!emptyName.equals(string)) {
            appendable.append('&').append(string).append(';');
        } else {
            appendable.append("&#x").append(Integer.toHexString(n)).append(';');
        }
    }

    public static String unescape(String string) {
        return Entities.unescape(string, false);
    }

    static String unescape(String string, boolean bl) {
        return Parser.unescapeEntities(string, bl);
    }

    private static boolean canEncode(CoreCharset coreCharset, char c, CharsetEncoder charsetEncoder) {
        switch (coreCharset) {
            case ascii: {
                return c < '\u0080';
            }
            case utf: {
                return true;
            }
        }
        return charsetEncoder.canEncode(c);
    }

    private static void load(EscapeMode escapeMode, String string, int n) {
        EscapeMode.access$102(escapeMode, new String[n]);
        EscapeMode.access$202(escapeMode, new int[n]);
        EscapeMode.access$302(escapeMode, new int[n]);
        EscapeMode.access$402(escapeMode, new String[n]);
        int n2 = 0;
        CharacterReader characterReader = new CharacterReader(string);
        while (!characterReader.isEmpty()) {
            int n3;
            String string2 = characterReader.consumeTo('=');
            characterReader.advance();
            int n4 = Integer.parseInt(characterReader.consumeToAny(codeDelims), 36);
            char c = characterReader.current();
            characterReader.advance();
            if (c == ',') {
                n3 = Integer.parseInt(characterReader.consumeTo(';'), 36);
                characterReader.advance();
            } else {
                n3 = -1;
            }
            String string3 = characterReader.consumeTo('&');
            int n5 = Integer.parseInt(string3, 36);
            characterReader.advance();
            ((EscapeMode)escapeMode).nameKeys[n2] = string2;
            ((EscapeMode)escapeMode).codeVals[n2] = n4;
            ((EscapeMode)escapeMode).codeKeys[n5] = n4;
            ((EscapeMode)escapeMode).nameVals[n5] = string2;
            if (n3 != -1) {
                multipoints.put(string2, new String(new int[]{n4, n3}, 0, 2));
            }
            ++n2;
        }
        Validate.isTrue(n2 == n, "Unexpected count of entities loaded");
    }

    public static enum EscapeMode {
        xhtml(EntitiesData.xmlPoints, 4),
        base(EntitiesData.basePoints, 106),
        extended(EntitiesData.fullPoints, 2125);

        private String[] nameKeys;
        private int[] codeVals;
        private int[] codeKeys;
        private String[] nameVals;

        private EscapeMode(String string2, int n2) {
            Entities.load(this, string2, n2);
        }

        int codepointForName(String string) {
            int n = Arrays.binarySearch(this.nameKeys, string);
            return n >= 0 ? this.codeVals[n] : -1;
        }

        String nameForCodepoint(int n) {
            int n2 = Arrays.binarySearch(this.codeKeys, n);
            if (n2 >= 0) {
                return n2 < this.nameVals.length - 1 && this.codeKeys[n2 + 1] == n ? this.nameVals[n2 + 1] : this.nameVals[n2];
            }
            return Entities.emptyName;
        }

        private int size() {
            return this.nameKeys.length;
        }

        static /* synthetic */ String[] access$102(EscapeMode escapeMode, String[] stringArray) {
            escapeMode.nameKeys = stringArray;
            return stringArray;
        }

        static /* synthetic */ int[] access$202(EscapeMode escapeMode, int[] nArray) {
            escapeMode.codeVals = nArray;
            return nArray;
        }

        static /* synthetic */ int[] access$302(EscapeMode escapeMode, int[] nArray) {
            escapeMode.codeKeys = nArray;
            return nArray;
        }

        static /* synthetic */ String[] access$402(EscapeMode escapeMode, String[] stringArray) {
            escapeMode.nameVals = stringArray;
            return stringArray;
        }
    }

    static enum CoreCharset {
        ascii,
        utf,
        fallback;


        static CoreCharset byName(String string) {
            if (string.equals("US-ASCII")) {
                return ascii;
            }
            if (string.startsWith("UTF-")) {
                return utf;
            }
            return fallback;
        }
    }
}

