/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public abstract class Node
implements Cloneable {
    static final String EmptyString = "";
    Node parentNode;
    int siblingIndex;

    protected Node() {
    }

    public abstract String nodeName();

    protected abstract boolean hasAttributes();

    public boolean hasParent() {
        return this.parentNode != null;
    }

    public String attr(String string) {
        Validate.notNull(string);
        if (!this.hasAttributes()) {
            return EmptyString;
        }
        String string2 = this.attributes().getIgnoreCase(string);
        if (string2.length() > 0) {
            return string2;
        }
        if (string.startsWith("abs:")) {
            return this.absUrl(string.substring("abs:".length()));
        }
        return EmptyString;
    }

    public abstract Attributes attributes();

    public Node attr(String string, String string2) {
        string = NodeUtils.parser(this).settings().normalizeAttribute(string);
        this.attributes().putIgnoreCase(string, string2);
        return this;
    }

    public boolean hasAttr(String string) {
        Validate.notNull(string);
        if (string.startsWith("abs:")) {
            String string2 = string.substring("abs:".length());
            if (this.attributes().hasKeyIgnoreCase(string2) && !this.absUrl(string2).equals(EmptyString)) {
                return true;
            }
        }
        return this.attributes().hasKeyIgnoreCase(string);
    }

    public Node removeAttr(String string) {
        Validate.notNull(string);
        this.attributes().removeIgnoreCase(string);
        return this;
    }

    public Node clearAttributes() {
        Iterator<Attribute> iterator = this.attributes().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        return this;
    }

    public abstract String baseUri();

    protected abstract void doSetBaseUri(String var1);

    public void setBaseUri(String string) {
        Validate.notNull(string);
        this.doSetBaseUri(string);
    }

    public String absUrl(String string) {
        Validate.notEmpty(string);
        if (!this.hasAttr(string)) {
            return EmptyString;
        }
        return StringUtil.resolve(this.baseUri(), this.attr(string));
    }

    protected abstract List<Node> ensureChildNodes();

    public Node childNode(int n) {
        return this.ensureChildNodes().get(n);
    }

    public List<Node> childNodes() {
        return Collections.unmodifiableList(this.ensureChildNodes());
    }

    public List<Node> childNodesCopy() {
        List<Node> list = this.ensureChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
        for (Node node : list) {
            arrayList.add(node.clone());
        }
        return arrayList;
    }

    public abstract int childNodeSize();

    protected Node[] childNodesAsArray() {
        return this.ensureChildNodes().toArray(new Node[0]);
    }

    public abstract Node empty();

    public Node parent() {
        return this.parentNode;
    }

    public final Node parentNode() {
        return this.parentNode;
    }

    public Node root() {
        Node node = this;
        while (node.parentNode != null) {
            node = node.parentNode;
        }
        return node;
    }

    public Document ownerDocument() {
        Node node = this.root();
        return node instanceof Document ? (Document)node : null;
    }

    public void remove() {
        Validate.notNull(this.parentNode);
        this.parentNode.removeChild(this);
    }

    public Node before(String string) {
        this.addSiblingHtml(this.siblingIndex, string);
        return this;
    }

    public Node before(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex, node);
        return this;
    }

    public Node after(String string) {
        this.addSiblingHtml(this.siblingIndex + 1, string);
        return this;
    }

    public Node after(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex + 1, node);
        return this;
    }

    private void addSiblingHtml(int n, String string) {
        Validate.notNull(string);
        Validate.notNull(this.parentNode);
        Element element = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> list = NodeUtils.parser(this).parseFragmentInput(string, element, this.baseUri());
        this.parentNode.addChildren(n, list.toArray(new Node[0]));
    }

    public Node wrap(String string) {
        Validate.notEmpty(string);
        Element element = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> list = NodeUtils.parser(this).parseFragmentInput(string, element, this.baseUri());
        Node node = list.get(0);
        if (!(node instanceof Element)) {
            return null;
        }
        Element element2 = (Element)node;
        Element element3 = this.getDeepChild(element2);
        this.parentNode.replaceChild(this, element2);
        element3.addChildren(this);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Node node2 = list.get(i);
                node2.parentNode.removeChild(node2);
                element2.appendChild(node2);
            }
        }
        return this;
    }

    public Node unwrap() {
        Validate.notNull(this.parentNode);
        List<Node> list = this.ensureChildNodes();
        Node node = list.size() > 0 ? list.get(0) : null;
        this.parentNode.addChildren(this.siblingIndex, this.childNodesAsArray());
        this.remove();
        return node;
    }

    private Element getDeepChild(Element element) {
        Elements elements = element.children();
        if (elements.size() > 0) {
            return this.getDeepChild((Element)elements.get(0));
        }
        return element;
    }

    void nodelistChanged() {
    }

    public void replaceWith(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.replaceChild(this, node);
    }

    protected void setParentNode(Node node) {
        Validate.notNull(node);
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
        this.parentNode = node;
    }

    protected void replaceChild(Node node, Node node2) {
        Validate.isTrue(node.parentNode == this);
        Validate.notNull(node2);
        if (node2.parentNode != null) {
            node2.parentNode.removeChild(node2);
        }
        int n = node.siblingIndex;
        this.ensureChildNodes().set(n, node2);
        node2.parentNode = this;
        node2.setSiblingIndex(n);
        node.parentNode = null;
    }

    protected void removeChild(Node node) {
        Validate.isTrue(node.parentNode == this);
        int n = node.siblingIndex;
        this.ensureChildNodes().remove(n);
        this.reindexChildren(n);
        node.parentNode = null;
    }

    protected void addChildren(Node ... nodeArray) {
        List<Node> list = this.ensureChildNodes();
        for (Node node : nodeArray) {
            this.reparentChild(node);
            list.add(node);
            node.setSiblingIndex(list.size() - 1);
        }
    }

    protected void addChildren(int n, Node ... nodeArray) {
        Validate.notNull(nodeArray);
        if (nodeArray.length == 0) {
            return;
        }
        List<Node> list = this.ensureChildNodes();
        Node node = nodeArray[0].parent();
        if (node != null && node.childNodeSize() == nodeArray.length) {
            boolean bl = true;
            List<Node> list2 = node.childNodes();
            int n2 = nodeArray.length;
            while (n2-- > 0) {
                if (nodeArray[n2] == list2.get(n2)) continue;
                bl = false;
                break;
            }
            node.empty();
            list.addAll(n, Arrays.asList(nodeArray));
            n2 = nodeArray.length;
            while (n2-- > 0) {
                nodeArray[n2].parentNode = this;
            }
            this.reindexChildren(n);
            return;
        }
        Validate.noNullElements(nodeArray);
        for (Node node2 : nodeArray) {
            this.reparentChild(node2);
        }
        list.addAll(n, Arrays.asList(nodeArray));
        this.reindexChildren(n);
    }

    protected void reparentChild(Node node) {
        node.setParentNode(this);
    }

    private void reindexChildren(int n) {
        List<Node> list = this.ensureChildNodes();
        for (int i = n; i < list.size(); ++i) {
            list.get(i).setSiblingIndex(i);
        }
    }

    public List<Node> siblingNodes() {
        if (this.parentNode == null) {
            return Collections.emptyList();
        }
        List<Node> list = this.parentNode.ensureChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size() - 1);
        for (Node node : list) {
            if (node == this) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public Node nextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> list = this.parentNode.ensureChildNodes();
        int n = this.siblingIndex + 1;
        if (list.size() > n) {
            return list.get(n);
        }
        return null;
    }

    public Node previousSibling() {
        if (this.parentNode == null) {
            return null;
        }
        if (this.siblingIndex > 0) {
            return this.parentNode.ensureChildNodes().get(this.siblingIndex - 1);
        }
        return null;
    }

    public int siblingIndex() {
        return this.siblingIndex;
    }

    protected void setSiblingIndex(int n) {
        this.siblingIndex = n;
    }

    public Node traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor.traverse(nodeVisitor, this);
        return this;
    }

    public Node filter(NodeFilter nodeFilter) {
        Validate.notNull(nodeFilter);
        NodeTraversor.filter(nodeFilter, this);
        return this;
    }

    public String outerHtml() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        this.outerHtml(stringBuilder);
        return StringUtil.releaseBuilder(stringBuilder);
    }

    protected void outerHtml(Appendable appendable) {
        NodeTraversor.traverse((NodeVisitor)new OuterHtmlVisitor(appendable, NodeUtils.outputSettings(this)), this);
    }

    abstract void outerHtmlHead(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    abstract void outerHtmlTail(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    public <T extends Appendable> T html(T t) {
        this.outerHtml(t);
        return t;
    }

    public String toString() {
        return this.outerHtml();
    }

    protected void indent(Appendable appendable, int n, Document.OutputSettings outputSettings) throws IOException {
        appendable.append('\n').append(StringUtil.padding(n * outputSettings.indentAmount()));
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public boolean hasSameValue(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.outerHtml().equals(((Node)object).outerHtml());
    }

    public Node clone() {
        Node node = this.doClone(null);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(node);
        while (!linkedList.isEmpty()) {
            Node node2 = (Node)linkedList.remove();
            int n = node2.childNodeSize();
            for (int i = 0; i < n; ++i) {
                List<Node> list = node2.ensureChildNodes();
                Node node3 = list.get(i).doClone(node2);
                list.set(i, node3);
                linkedList.add(node3);
            }
        }
        return node;
    }

    public Node shallowClone() {
        return this.doClone(null);
    }

    protected Node doClone(Node node) {
        Node node2;
        try {
            node2 = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        node2.parentNode = node;
        node2.siblingIndex = node == null ? 0 : this.siblingIndex;
        return node2;
    }

    private static class OuterHtmlVisitor
    implements NodeVisitor {
        private Appendable accum;
        private Document.OutputSettings out;

        OuterHtmlVisitor(Appendable appendable, Document.OutputSettings outputSettings) {
            this.accum = appendable;
            this.out = outputSettings;
            outputSettings.prepareEncoder();
        }

        @Override
        public void head(Node node, int n) {
            try {
                node.outerHtmlHead(this.accum, n, this.out);
            }
            catch (IOException iOException) {
                throw new SerializationException(iOException);
            }
        }

        @Override
        public void tail(Node node, int n) {
            if (!node.nodeName().equals("#text")) {
                try {
                    node.outerHtmlTail(this.accum, n, this.out);
                }
                catch (IOException iOException) {
                    throw new SerializationException(iOException);
                }
            }
        }
    }
}

