/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.LeafNode;

public class XmlDeclaration
extends LeafNode {
    private final boolean isProcessingInstruction;

    public XmlDeclaration(String string, boolean bl) {
        Validate.notNull(string);
        this.value = string;
        this.isProcessingInstruction = bl;
    }

    @Override
    public String nodeName() {
        return "#declaration";
    }

    public String name() {
        return this.coreValue();
    }

    public String getWholeDeclaration() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        try {
            this.getWholeDeclaration(stringBuilder, new Document.OutputSettings());
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return StringUtil.releaseBuilder(stringBuilder).trim();
    }

    private void getWholeDeclaration(Appendable appendable, Document.OutputSettings outputSettings) throws IOException {
        for (Attribute attribute : this.attributes()) {
            if (attribute.getKey().equals(this.nodeName())) continue;
            appendable.append(' ');
            attribute.html(appendable, outputSettings);
        }
    }

    @Override
    void outerHtmlHead(Appendable appendable, int n, Document.OutputSettings outputSettings) throws IOException {
        appendable.append("<").append(this.isProcessingInstruction ? "!" : "?").append(this.coreValue());
        this.getWholeDeclaration(appendable, outputSettings);
        appendable.append(this.isProcessingInstruction ? "!" : "?").append(">");
    }

    @Override
    void outerHtmlTail(Appendable appendable, int n, Document.OutputSettings outputSettings) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public XmlDeclaration clone() {
        return (XmlDeclaration)super.clone();
    }
}

