/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Locale;
import org.jsoup.UncheckedIOException;
import org.jsoup.helper.Validate;

public final class CharacterReader {
    static final char EOF = '\uffff';
    private static final int maxStringCacheLen = 12;
    static final int maxBufferLen = 32768;
    static final int readAheadLimit = 24576;
    private static final int minReadAheadLen = 1024;
    private char[] charBuf;
    private Reader reader;
    private int bufLength;
    private int bufSplitPoint;
    private int bufPos;
    private int readerPos;
    private int bufMark = -1;
    private static final int stringCacheSize = 512;
    private String[] stringCache = new String[512];
    private boolean readFully;

    public CharacterReader(Reader reader, int n) {
        Validate.notNull(reader);
        Validate.isTrue(reader.markSupported());
        this.reader = reader;
        this.charBuf = new char[n > 32768 ? 32768 : n];
        this.bufferUp();
    }

    public CharacterReader(Reader reader) {
        this(reader, 32768);
    }

    public CharacterReader(String string) {
        this(new StringReader(string), string.length());
    }

    public void close() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.reader = null;
            this.charBuf = null;
            this.stringCache = null;
        }
    }

    private void bufferUp() {
        int n;
        int n2;
        if (this.readFully || this.bufPos < this.bufSplitPoint) {
            return;
        }
        if (this.bufMark != -1) {
            n2 = this.bufMark;
            n = this.bufPos - this.bufMark;
        } else {
            n2 = this.bufPos;
            n = 0;
        }
        try {
            int n3;
            int n4;
            long l = this.reader.skip(n2);
            this.reader.mark(32768);
            for (n3 = 0; n3 <= 1024; n3 += n4) {
                n4 = this.reader.read(this.charBuf, n3, this.charBuf.length - n3);
                if (n4 == -1) {
                    this.readFully = true;
                }
                if (n4 <= 0) break;
            }
            this.reader.reset();
            if (n3 > 0) {
                Validate.isTrue(l == (long)n2);
                this.bufLength = n3;
                this.readerPos += n2;
                this.bufPos = n;
                if (this.bufMark != -1) {
                    this.bufMark = 0;
                }
                this.bufSplitPoint = this.bufLength > 24576 ? 24576 : this.bufLength;
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public int pos() {
        return this.readerPos + this.bufPos;
    }

    public boolean isEmpty() {
        this.bufferUp();
        return this.bufPos >= this.bufLength;
    }

    private boolean isEmptyNoBufferUp() {
        return this.bufPos >= this.bufLength;
    }

    public char current() {
        this.bufferUp();
        return this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
    }

    char consume() {
        this.bufferUp();
        char c = this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
        ++this.bufPos;
        return c;
    }

    void unconsume() {
        if (this.bufPos < 1) {
            throw new UncheckedIOException(new IOException("No buffer left to unconsume"));
        }
        --this.bufPos;
    }

    public void advance() {
        ++this.bufPos;
    }

    void mark() {
        if (this.bufLength - this.bufPos < 1024) {
            this.bufSplitPoint = 0;
        }
        this.bufferUp();
        this.bufMark = this.bufPos;
    }

    void unmark() {
        this.bufMark = -1;
    }

    void rewindToMark() {
        if (this.bufMark == -1) {
            throw new UncheckedIOException(new IOException("Mark invalid"));
        }
        this.bufPos = this.bufMark;
        this.unmark();
    }

    int nextIndexOf(char c) {
        this.bufferUp();
        for (int i = this.bufPos; i < this.bufLength; ++i) {
            if (c != this.charBuf[i]) continue;
            return i - this.bufPos;
        }
        return -1;
    }

    int nextIndexOf(CharSequence charSequence) {
        this.bufferUp();
        char c = charSequence.charAt(0);
        for (int i = this.bufPos; i < this.bufLength; ++i) {
            if (c != this.charBuf[i]) {
                while (++i < this.bufLength && c != this.charBuf[i]) {
                }
            }
            int n = i + 1;
            int n2 = n + charSequence.length() - 1;
            if (i >= this.bufLength || n2 > this.bufLength) continue;
            int n3 = 1;
            while (n < n2 && charSequence.charAt(n3) == this.charBuf[n]) {
                ++n;
                ++n3;
            }
            if (n != n2) continue;
            return i - this.bufPos;
        }
        return -1;
    }

    public String consumeTo(char c) {
        int n = this.nextIndexOf(c);
        if (n != -1) {
            String string = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, n);
            this.bufPos += n;
            return string;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String string) {
        int n = this.nextIndexOf(string);
        if (n != -1) {
            String string2 = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, n);
            this.bufPos += n;
            return string2;
        }
        if (this.bufLength - this.bufPos < string.length()) {
            return this.consumeToEnd();
        }
        int n2 = this.bufLength - string.length() + 1;
        String string3 = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, n2 - this.bufPos);
        this.bufPos = n2;
        return string3;
    }

    public String consumeToAny(char ... cArray) {
        int n;
        this.bufferUp();
        int n2 = n = this.bufPos;
        int n3 = this.bufLength;
        char[] cArray2 = this.charBuf;
        int n4 = cArray.length;
        block0: while (n < n3) {
            for (int i = 0; i < n4; ++i) {
                if (cArray2[n] == cArray[i]) break block0;
            }
            ++n;
        }
        this.bufPos = n;
        return n > n2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, n2, n - n2) : "";
    }

    String consumeToAnySorted(char ... cArray) {
        int n;
        this.bufferUp();
        int n2 = n = this.bufPos;
        int n3 = this.bufLength;
        char[] cArray2 = this.charBuf;
        while (n < n3 && Arrays.binarySearch(cArray, cArray2[n]) < 0) {
            ++n;
        }
        this.bufPos = n;
        return this.bufPos > n2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, n2, n - n2) : "";
    }

    String consumeData() {
        int n;
        int n2 = n = this.bufPos;
        int n3 = this.bufLength;
        char[] cArray = this.charBuf;
        block3: while (n < n3) {
            switch (cArray[n]) {
                case '\u0000': 
                case '&': 
                case '<': {
                    break block3;
                }
                default: {
                    ++n;
                    continue block3;
                }
            }
        }
        this.bufPos = n;
        return n > n2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, n2, n - n2) : "";
    }

    String consumeRawData() {
        int n;
        int n2 = n = this.bufPos;
        int n3 = this.bufLength;
        char[] cArray = this.charBuf;
        block3: while (n < n3) {
            switch (cArray[n]) {
                case '\u0000': 
                case '<': {
                    break block3;
                }
                default: {
                    ++n;
                    continue block3;
                }
            }
        }
        this.bufPos = n;
        return n > n2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, n2, n - n2) : "";
    }

    String consumeTagName() {
        int n;
        this.bufferUp();
        int n2 = n = this.bufPos;
        int n3 = this.bufLength;
        char[] cArray = this.charBuf;
        block3: while (n < n3) {
            switch (cArray[n]) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '/': 
                case '<': 
                case '>': {
                    break block3;
                }
                default: {
                    ++n;
                    continue block3;
                }
            }
        }
        this.bufPos = n;
        return n > n2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, n2, n - n2) : "";
    }

    String consumeToEnd() {
        this.bufferUp();
        String string = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, this.bufLength - this.bufPos);
        this.bufPos = this.bufLength;
        return string;
    }

    String consumeLetterSequence() {
        char c;
        this.bufferUp();
        int n = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, n, this.bufPos - n);
    }

    String consumeLetterThenDigitSequence() {
        char c;
        this.bufferUp();
        int n = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.bufPos;
        }
        while (!this.isEmptyNoBufferUp() && (c = this.charBuf[this.bufPos]) >= '0' && c <= '9') {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, n, this.bufPos - n);
    }

    String consumeHexSequence() {
        char c;
        this.bufferUp();
        int n = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, n, this.bufPos - n);
    }

    String consumeDigitSequence() {
        char c;
        this.bufferUp();
        int n = this.bufPos;
        while (this.bufPos < this.bufLength && (c = this.charBuf[this.bufPos]) >= '0' && c <= '9') {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, n, this.bufPos - n);
    }

    boolean matches(char c) {
        return !this.isEmpty() && this.charBuf[this.bufPos] == c;
    }

    boolean matches(String string) {
        this.bufferUp();
        int n = string.length();
        if (n > this.bufLength - this.bufPos) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == this.charBuf[this.bufPos + i]) continue;
            return false;
        }
        return true;
    }

    boolean matchesIgnoreCase(String string) {
        this.bufferUp();
        int n = string.length();
        if (n > this.bufLength - this.bufPos) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = Character.toUpperCase(string.charAt(i));
            if (c2 == (c = Character.toUpperCase(this.charBuf[this.bufPos + i]))) continue;
            return false;
        }
        return true;
    }

    boolean matchesAny(char ... cArray) {
        if (this.isEmpty()) {
            return false;
        }
        this.bufferUp();
        char c = this.charBuf[this.bufPos];
        for (char c2 : cArray) {
            if (c2 != c) continue;
            return true;
        }
        return false;
    }

    boolean matchesAnySorted(char[] cArray) {
        this.bufferUp();
        return !this.isEmpty() && Arrays.binarySearch(cArray, this.charBuf[this.bufPos]) >= 0;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= '0' && c <= '9';
    }

    boolean matchConsume(String string) {
        this.bufferUp();
        if (this.matches(string)) {
            this.bufPos += string.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String string) {
        if (this.matchesIgnoreCase(string)) {
            this.bufPos += string.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = string.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf(string2) > -1 || this.nextIndexOf(string3) > -1;
    }

    public String toString() {
        if (this.bufLength - this.bufPos < 0) {
            return "";
        }
        return new String(this.charBuf, this.bufPos, this.bufLength - this.bufPos);
    }

    private static String cacheString(char[] cArray, String[] stringArray, int n, int n2) {
        int n3;
        if (n2 > 12) {
            return new String(cArray, n, n2);
        }
        if (n2 < 1) {
            return "";
        }
        int n4 = 31 * n2;
        int n5 = n;
        for (n3 = 0; n3 < n2; ++n3) {
            n4 = 31 * n4 + cArray[n5++];
        }
        n3 = n4 & 0x1FF;
        String string = stringArray[n3];
        if (string == null) {
            stringArray[n3] = string = new String(cArray, n, n2);
        } else {
            if (CharacterReader.rangeEquals(cArray, n, n2, string)) {
                return string;
            }
            stringArray[n3] = string = new String(cArray, n, n2);
        }
        return string;
    }

    static boolean rangeEquals(char[] cArray, int n, int n2, String string) {
        if (n2 == string.length()) {
            int n3 = n;
            int n4 = 0;
            while (n2-- != 0) {
                if (cArray[n3++] == string.charAt(n4++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean rangeEquals(int n, int n2, String string) {
        return CharacterReader.rangeEquals(this.charBuf, n, n2, string);
    }
}

