/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.HtmlTreeBuilderState;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;
import org.jsoup.parser.TreeBuilder;
import org.jsoup.select.Elements;

public class HtmlTreeBuilder
extends TreeBuilder {
    static final String[] TagsSearchInScope = new String[]{"applet", "caption", "html", "marquee", "object", "table", "td", "th"};
    static final String[] TagSearchList = new String[]{"ol", "ul"};
    static final String[] TagSearchButton = new String[]{"button"};
    static final String[] TagSearchTableScope = new String[]{"html", "table"};
    static final String[] TagSearchSelectScope = new String[]{"optgroup", "option"};
    static final String[] TagSearchEndTags = new String[]{"dd", "dt", "li", "optgroup", "option", "p", "rp", "rt"};
    static final String[] TagSearchSpecial = new String[]{"address", "applet", "area", "article", "aside", "base", "basefont", "bgsound", "blockquote", "body", "br", "button", "caption", "center", "col", "colgroup", "command", "dd", "details", "dir", "div", "dl", "dt", "embed", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "iframe", "img", "input", "isindex", "li", "link", "listing", "marquee", "menu", "meta", "nav", "noembed", "noframes", "noscript", "object", "ol", "p", "param", "plaintext", "pre", "script", "section", "select", "style", "summary", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "ul", "wbr", "xmp"};
    public static final int MaxScopeSearchDepth = 100;
    private HtmlTreeBuilderState state;
    private HtmlTreeBuilderState originalState;
    private boolean baseUriSetFromDoc;
    private Element headElement;
    private FormElement formElement;
    private Element contextElement;
    private ArrayList<Element> formattingElements;
    private List<String> pendingTableCharacters;
    private Token.EndTag emptyEnd;
    private boolean framesetOk;
    private boolean fosterInserts;
    private boolean fragmentParsing;
    private String[] specificScopeTarget = new String[]{null};

    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.htmlDefault;
    }

    @Override
    protected void initialiseParse(Reader reader, String string, Parser parser) {
        super.initialiseParse(reader, string, parser);
        this.state = HtmlTreeBuilderState.Initial;
        this.originalState = null;
        this.baseUriSetFromDoc = false;
        this.headElement = null;
        this.formElement = null;
        this.contextElement = null;
        this.formattingElements = new ArrayList();
        this.pendingTableCharacters = new ArrayList<String>();
        this.emptyEnd = new Token.EndTag();
        this.framesetOk = true;
        this.fosterInserts = false;
        this.fragmentParsing = false;
    }

    @Override
    List<Node> parseFragment(String string, Element element, String string2, Parser parser) {
        this.state = HtmlTreeBuilderState.Initial;
        this.initialiseParse(new StringReader(string), string2, parser);
        this.contextElement = element;
        this.fragmentParsing = true;
        Node node = null;
        if (element != null) {
            if (element.ownerDocument() != null) {
                this.doc.quirksMode(element.ownerDocument().quirksMode());
            }
            String string3 = element.normalName();
            if (StringUtil.in(string3, "title", "textarea")) {
                this.tokeniser.transition(TokeniserState.Rcdata);
            } else if (StringUtil.in(string3, "iframe", "noembed", "noframes", "style", "xmp")) {
                this.tokeniser.transition(TokeniserState.Rawtext);
            } else if (string3.equals("script")) {
                this.tokeniser.transition(TokeniserState.ScriptData);
            } else if (string3.equals("noscript")) {
                this.tokeniser.transition(TokeniserState.Data);
            } else if (string3.equals("plaintext")) {
                this.tokeniser.transition(TokeniserState.Data);
            } else {
                this.tokeniser.transition(TokeniserState.Data);
            }
            node = new Element(Tag.valueOf("html", this.settings), string2);
            this.doc.appendChild(node);
            this.stack.add(node);
            this.resetInsertionMode();
            Elements elements = element.parents();
            elements.add(0, element);
            for (Element element2 : elements) {
                if (!(element2 instanceof FormElement)) continue;
                this.formElement = (FormElement)element2;
                break;
            }
        }
        this.runParser();
        if (element != null) {
            return node.childNodes();
        }
        return this.doc.childNodes();
    }

    @Override
    protected boolean process(Token token) {
        this.currentToken = token;
        return this.state.process(token, this);
    }

    boolean process(Token token, HtmlTreeBuilderState htmlTreeBuilderState) {
        this.currentToken = token;
        return htmlTreeBuilderState.process(token, this);
    }

    void transition(HtmlTreeBuilderState htmlTreeBuilderState) {
        this.state = htmlTreeBuilderState;
    }

    HtmlTreeBuilderState state() {
        return this.state;
    }

    void markInsertionMode() {
        this.originalState = this.state;
    }

    HtmlTreeBuilderState originalState() {
        return this.originalState;
    }

    void framesetOk(boolean bl) {
        this.framesetOk = bl;
    }

    boolean framesetOk() {
        return this.framesetOk;
    }

    Document getDocument() {
        return this.doc;
    }

    String getBaseUri() {
        return this.baseUri;
    }

    void maybeSetBaseUri(Element element) {
        if (this.baseUriSetFromDoc) {
            return;
        }
        String string = element.absUrl("href");
        if (string.length() != 0) {
            this.baseUri = string;
            this.baseUriSetFromDoc = true;
            this.doc.setBaseUri(string);
        }
    }

    boolean isFragmentParsing() {
        return this.fragmentParsing;
    }

    void error(HtmlTreeBuilderState htmlTreeBuilderState) {
        if (this.parser.getErrors().canAddError()) {
            this.parser.getErrors().add(new ParseError(this.reader.pos(), "Unexpected token [%s] when in state [%s]", new Object[]{this.currentToken.tokenType(), htmlTreeBuilderState}));
        }
    }

    Element insert(Token.StartTag startTag) {
        int n;
        if (startTag.attributes != null && !startTag.attributes.isEmpty() && (n = startTag.attributes.deduplicate(this.settings)) > 0) {
            this.error("Duplicate attribute");
        }
        if (startTag.isSelfClosing()) {
            Element element = this.insertEmpty(startTag);
            this.stack.add(element);
            this.tokeniser.transition(TokeniserState.Data);
            this.tokeniser.emit(this.emptyEnd.reset().name(element.tagName()));
            return element;
        }
        Element element = new Element(Tag.valueOf(startTag.name(), this.settings), null, this.settings.normalizeAttributes(startTag.attributes));
        this.insert(element);
        return element;
    }

    Element insertStartTag(String string) {
        Element element = new Element(Tag.valueOf(string, this.settings), null);
        this.insert(element);
        return element;
    }

    void insert(Element element) {
        this.insertNode(element);
        this.stack.add(element);
    }

    Element insertEmpty(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name(), this.settings);
        Element element = new Element(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        this.insertNode(element);
        if (startTag.isSelfClosing()) {
            if (tag.isKnownTag()) {
                if (!tag.isEmpty()) {
                    this.tokeniser.error("Tag cannot be self closing; not a void tag");
                }
            } else {
                tag.setSelfClosing();
            }
        }
        return element;
    }

    FormElement insertForm(Token.StartTag startTag, boolean bl) {
        Tag tag = Tag.valueOf(startTag.name(), this.settings);
        FormElement formElement = new FormElement(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        this.setFormElement(formElement);
        this.insertNode(formElement);
        if (bl) {
            this.stack.add(formElement);
        }
        return formElement;
    }

    void insert(Token.Comment comment) {
        Comment comment2 = new Comment(comment.getData());
        this.insertNode(comment2);
    }

    void insert(Token.Character character) {
        Element element = this.currentElement();
        if (element == null) {
            element = this.doc;
        }
        String string = element.normalName();
        String string2 = character.getData();
        LeafNode leafNode = character.isCData() ? new CDataNode(string2) : (string.equals("script") || string.equals("style") ? new DataNode(string2) : new TextNode(string2));
        element.appendChild(leafNode);
    }

    private void insertNode(Node node) {
        if (this.stack.isEmpty()) {
            this.doc.appendChild(node);
        } else if (this.isFosterInserts()) {
            this.insertInFosterParent(node);
        } else {
            this.currentElement().appendChild(node);
        }
        if (node instanceof Element && ((Element)node).tag().isFormListed() && this.formElement != null) {
            this.formElement.addElement((Element)node);
        }
    }

    Element pop() {
        int n = this.stack.size();
        return (Element)this.stack.remove(n - 1);
    }

    void push(Element element) {
        this.stack.add(element);
    }

    ArrayList<Element> getStack() {
        return this.stack;
    }

    boolean onStack(Element element) {
        return this.isElementInQueue(this.stack, element);
    }

    private boolean isElementInQueue(ArrayList<Element> arrayList, Element element) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Element element2 = arrayList.get(i);
            if (element2 != element) continue;
            return true;
        }
        return false;
    }

    Element getFromStack(String string) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            if (!element.normalName().equals(string)) continue;
            return element;
        }
        return null;
    }

    boolean removeFromStack(Element element) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element2 = (Element)this.stack.get(i);
            if (element2 != element) continue;
            this.stack.remove(i);
            return true;
        }
        return false;
    }

    Element popStackToClose(String string) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            this.stack.remove(i);
            if (!element.normalName().equals(string)) continue;
            return element;
        }
        return null;
    }

    void popStackToClose(String ... stringArray) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            this.stack.remove(i);
            if (StringUtil.inSorted(element.normalName(), stringArray)) break;
        }
    }

    void popStackToBefore(String string) {
        Element element;
        for (int i = this.stack.size() - 1; i >= 0 && !(element = (Element)this.stack.get(i)).normalName().equals(string); --i) {
            this.stack.remove(i);
        }
    }

    void clearStackToTableContext() {
        this.clearStackToContext("table");
    }

    void clearStackToTableBodyContext() {
        this.clearStackToContext("tbody", "tfoot", "thead", "template");
    }

    void clearStackToTableRowContext() {
        this.clearStackToContext("tr", "template");
    }

    private void clearStackToContext(String ... stringArray) {
        Element element;
        for (int i = this.stack.size() - 1; i >= 0 && !StringUtil.in((element = (Element)this.stack.get(i)).normalName(), stringArray) && !element.normalName().equals("html"); --i) {
            this.stack.remove(i);
        }
    }

    Element aboveOnStack(Element element) {
        assert (this.onStack(element));
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element2 = (Element)this.stack.get(i);
            if (element2 != element) continue;
            return (Element)this.stack.get(i - 1);
        }
        return null;
    }

    void insertOnStackAfter(Element element, Element element2) {
        int n = this.stack.lastIndexOf(element);
        Validate.isTrue(n != -1);
        this.stack.add(n + 1, element2);
    }

    void replaceOnStack(Element element, Element element2) {
        this.replaceInQueue(this.stack, element, element2);
    }

    private void replaceInQueue(ArrayList<Element> arrayList, Element element, Element element2) {
        int n = arrayList.lastIndexOf(element);
        Validate.isTrue(n != -1);
        arrayList.set(n, element2);
    }

    void resetInsertionMode() {
        boolean bl = false;
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            String string;
            Element element = (Element)this.stack.get(i);
            if (i == 0) {
                bl = true;
                element = this.contextElement;
            }
            if ("select".equals(string = element.normalName())) {
                this.transition(HtmlTreeBuilderState.InSelect);
                break;
            }
            if ("td".equals(string) || "th".equals(string) && !bl) {
                this.transition(HtmlTreeBuilderState.InCell);
                break;
            }
            if ("tr".equals(string)) {
                this.transition(HtmlTreeBuilderState.InRow);
                break;
            }
            if ("tbody".equals(string) || "thead".equals(string) || "tfoot".equals(string)) {
                this.transition(HtmlTreeBuilderState.InTableBody);
                break;
            }
            if ("caption".equals(string)) {
                this.transition(HtmlTreeBuilderState.InCaption);
                break;
            }
            if ("colgroup".equals(string)) {
                this.transition(HtmlTreeBuilderState.InColumnGroup);
                break;
            }
            if ("table".equals(string)) {
                this.transition(HtmlTreeBuilderState.InTable);
                break;
            }
            if ("head".equals(string)) {
                this.transition(HtmlTreeBuilderState.InBody);
                break;
            }
            if ("body".equals(string)) {
                this.transition(HtmlTreeBuilderState.InBody);
                break;
            }
            if ("frameset".equals(string)) {
                this.transition(HtmlTreeBuilderState.InFrameset);
                break;
            }
            if ("html".equals(string)) {
                this.transition(HtmlTreeBuilderState.BeforeHead);
                break;
            }
            if (!bl) continue;
            this.transition(HtmlTreeBuilderState.InBody);
            break;
        }
    }

    private boolean inSpecificScope(String string, String[] stringArray, String[] stringArray2) {
        this.specificScopeTarget[0] = string;
        return this.inSpecificScope(this.specificScopeTarget, stringArray, stringArray2);
    }

    private boolean inSpecificScope(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n = this.stack.size() - 1;
        int n2 = n > 100 ? n - 100 : 0;
        for (int i = n; i >= n2; --i) {
            String string = ((Element)this.stack.get(i)).normalName();
            if (StringUtil.inSorted(string, stringArray)) {
                return true;
            }
            if (StringUtil.inSorted(string, stringArray2)) {
                return false;
            }
            if (stringArray3 == null || !StringUtil.inSorted(string, stringArray3)) continue;
            return false;
        }
        return false;
    }

    boolean inScope(String[] stringArray) {
        return this.inSpecificScope(stringArray, TagsSearchInScope, null);
    }

    boolean inScope(String string) {
        return this.inScope(string, null);
    }

    boolean inScope(String string, String[] stringArray) {
        return this.inSpecificScope(string, TagsSearchInScope, stringArray);
    }

    boolean inListItemScope(String string) {
        return this.inScope(string, TagSearchList);
    }

    boolean inButtonScope(String string) {
        return this.inScope(string, TagSearchButton);
    }

    boolean inTableScope(String string) {
        return this.inSpecificScope(string, TagSearchTableScope, null);
    }

    boolean inSelectScope(String string) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            String string2 = element.normalName();
            if (string2.equals(string)) {
                return true;
            }
            if (StringUtil.inSorted(string2, TagSearchSelectScope)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    void setHeadElement(Element element) {
        this.headElement = element;
    }

    Element getHeadElement() {
        return this.headElement;
    }

    boolean isFosterInserts() {
        return this.fosterInserts;
    }

    void setFosterInserts(boolean bl) {
        this.fosterInserts = bl;
    }

    FormElement getFormElement() {
        return this.formElement;
    }

    void setFormElement(FormElement formElement) {
        this.formElement = formElement;
    }

    void newPendingTableCharacters() {
        this.pendingTableCharacters = new ArrayList<String>();
    }

    List<String> getPendingTableCharacters() {
        return this.pendingTableCharacters;
    }

    void generateImpliedEndTags(String string) {
        while (string != null && !this.currentElement().normalName().equals(string) && StringUtil.inSorted(this.currentElement().normalName(), TagSearchEndTags)) {
            this.pop();
        }
    }

    void generateImpliedEndTags() {
        this.generateImpliedEndTags(null);
    }

    boolean isSpecial(Element element) {
        String string = element.normalName();
        return StringUtil.inSorted(string, TagSearchSpecial);
    }

    Element lastFormattingElement() {
        return this.formattingElements.size() > 0 ? this.formattingElements.get(this.formattingElements.size() - 1) : null;
    }

    Element removeLastFormattingElement() {
        int n = this.formattingElements.size();
        if (n > 0) {
            return this.formattingElements.remove(n - 1);
        }
        return null;
    }

    void pushActiveFormattingElements(Element element) {
        Element element2;
        int n = 0;
        for (int i = this.formattingElements.size() - 1; i >= 0 && (element2 = this.formattingElements.get(i)) != null; --i) {
            if (this.isSameFormattingElement(element, element2)) {
                ++n;
            }
            if (n != 3) continue;
            this.formattingElements.remove(i);
            break;
        }
        this.formattingElements.add(element);
    }

    private boolean isSameFormattingElement(Element element, Element element2) {
        return element.normalName().equals(element2.normalName()) && element.attributes().equals(element2.attributes());
    }

    void reconstructFormattingElements() {
        Element element = this.lastFormattingElement();
        if (element == null || this.onStack(element)) {
            return;
        }
        Element element2 = element;
        int n = this.formattingElements.size();
        int n2 = n - 1;
        boolean bl = false;
        do {
            if (n2 != 0) continue;
            bl = true;
            break;
        } while ((element2 = this.formattingElements.get(--n2)) != null && !this.onStack(element2));
        do {
            if (!bl) {
                element2 = this.formattingElements.get(++n2);
            }
            Validate.notNull(element2);
            bl = false;
            Element element3 = this.insertStartTag(element2.normalName());
            element3.attributes().addAll(element2.attributes());
            this.formattingElements.set(n2, element3);
        } while (n2 != n - 1);
    }

    void clearFormattingElementsToLastMarker() {
        Element element;
        while (!this.formattingElements.isEmpty() && (element = this.removeLastFormattingElement()) != null) {
        }
    }

    void removeFromActiveFormattingElements(Element element) {
        for (int i = this.formattingElements.size() - 1; i >= 0; --i) {
            Element element2 = this.formattingElements.get(i);
            if (element2 != element) continue;
            this.formattingElements.remove(i);
            break;
        }
    }

    boolean isInActiveFormattingElements(Element element) {
        return this.isElementInQueue(this.formattingElements, element);
    }

    Element getActiveFormattingElement(String string) {
        Element element;
        for (int i = this.formattingElements.size() - 1; i >= 0 && (element = this.formattingElements.get(i)) != null; --i) {
            if (!element.normalName().equals(string)) continue;
            return element;
        }
        return null;
    }

    void replaceActiveFormattingElement(Element element, Element element2) {
        this.replaceInQueue(this.formattingElements, element, element2);
    }

    void insertMarkerToFormattingElements() {
        this.formattingElements.add(null);
    }

    void insertInFosterParent(Node node) {
        Element element;
        Element element2 = this.getFromStack("table");
        boolean bl = false;
        if (element2 != null) {
            if (element2.parent() != null) {
                element = element2.parent();
                bl = true;
            } else {
                element = this.aboveOnStack(element2);
            }
        } else {
            element = (Element)this.stack.get(0);
        }
        if (bl) {
            Validate.notNull(element2);
            element2.before(node);
        } else {
            element.appendChild(node);
        }
    }

    public String toString() {
        return "TreeBuilder{currentToken=" + this.currentToken + ", state=" + (Object)((Object)this.state) + ", currentElement=" + this.currentElement() + '}';
    }
}

