/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.ArrayList;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.nodes.Node;
import org.jsoup.parser.HtmlTreeBuilder;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;
import org.jsoup.parser.TreeBuilder;

enum HtmlTreeBuilderState {
    Initial{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else if (token.isDoctype()) {
                Token.Doctype doctype = token.asDoctype();
                DocumentType documentType = new DocumentType(htmlTreeBuilder.settings.normalizeTag(doctype.getName()), doctype.getPublicIdentifier(), doctype.getSystemIdentifier());
                documentType.setPubSysKey(doctype.getPubSysKey());
                htmlTreeBuilder.getDocument().appendChild(documentType);
                if (doctype.isForceQuirks()) {
                    htmlTreeBuilder.getDocument().quirksMode(Document.QuirksMode.quirks);
                }
                htmlTreeBuilder.transition(BeforeHtml);
            } else {
                htmlTreeBuilder.transition(BeforeHtml);
                return htmlTreeBuilder.process(token);
            }
            return true;
        }
    }
    ,
    BeforeHtml{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else if (token.isStartTag() && token.asStartTag().normalName().equals("html")) {
                htmlTreeBuilder.insert(token.asStartTag());
                htmlTreeBuilder.transition(BeforeHead);
            } else {
                if (token.isEndTag() && StringUtil.inSorted(token.asEndTag().normalName(), Constants.BeforeHtmlToHead)) {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                if (token.isEndTag()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                return this.anythingElse(token, htmlTreeBuilder);
            }
            return true;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.insertStartTag("html");
            htmlTreeBuilder.transition(BeforeHead);
            return htmlTreeBuilder.process(token);
        }
    }
    ,
    BeforeHead{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag() && token.asStartTag().normalName().equals("html")) {
                    return InBody.process(token, htmlTreeBuilder);
                }
                if (token.isStartTag() && token.asStartTag().normalName().equals("head")) {
                    Element element = htmlTreeBuilder.insert(token.asStartTag());
                    htmlTreeBuilder.setHeadElement(element);
                    htmlTreeBuilder.transition(InHead);
                } else {
                    if (token.isEndTag() && StringUtil.inSorted(token.asEndTag().normalName(), Constants.BeforeHtmlToHead)) {
                        htmlTreeBuilder.processStartTag("head");
                        return htmlTreeBuilder.process(token);
                    }
                    if (token.isEndTag()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.processStartTag("head");
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    InHead{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            switch (token.type) {
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.normalName();
                    if (string.equals("html")) {
                        return InBody.process(token, htmlTreeBuilder);
                    }
                    if (StringUtil.inSorted(string, Constants.InHeadEmpty)) {
                        Element element = htmlTreeBuilder.insertEmpty(startTag);
                        if (!string.equals("base") || !element.hasAttr("href")) break;
                        htmlTreeBuilder.maybeSetBaseUri(element);
                        break;
                    }
                    if (string.equals("meta")) {
                        Element element = htmlTreeBuilder.insertEmpty(startTag);
                        break;
                    }
                    if (string.equals("title")) {
                        HtmlTreeBuilderState.handleRcData(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InHeadRaw)) {
                        HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (string.equals("noscript")) {
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InHeadNoscript);
                        break;
                    }
                    if (string.equals("script")) {
                        htmlTreeBuilder.tokeniser.transition(TokeniserState.ScriptData);
                        htmlTreeBuilder.markInsertionMode();
                        htmlTreeBuilder.transition(Text);
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("head")) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.normalName();
                    if (string.equals("head")) {
                        htmlTreeBuilder.pop();
                        htmlTreeBuilder.transition(AfterHead);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InHeadEnd)) {
                        return this.anythingElse(token, htmlTreeBuilder);
                    }
                    htmlTreeBuilder.error(this);
                    return false;
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, TreeBuilder treeBuilder) {
            treeBuilder.processEndTag("head");
            return treeBuilder.process(token);
        }
    }
    ,
    InHeadNoscript{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
            } else {
                if (token.isStartTag() && token.asStartTag().normalName().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (token.isEndTag() && token.asEndTag().normalName().equals("noscript")) {
                    htmlTreeBuilder.pop();
                    htmlTreeBuilder.transition(InHead);
                } else {
                    if (HtmlTreeBuilderState.isWhitespace(token) || token.isComment() || token.isStartTag() && StringUtil.inSorted(token.asStartTag().normalName(), Constants.InHeadNoScriptHead)) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    if (token.isEndTag() && token.asEndTag().normalName().equals("br")) {
                        return this.anythingElse(token, htmlTreeBuilder);
                    }
                    if (token.isStartTag() && StringUtil.inSorted(token.asStartTag().normalName(), Constants.InHeadNoscriptIgnore) || token.isEndTag()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.error(this);
            htmlTreeBuilder.insert(new Token.Character().data(token.toString()));
            return true;
        }
    }
    ,
    AfterHead{

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
                return true;
            }
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return true;
            }
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.normalName();
                if (string.equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (string.equals("body")) {
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.framesetOk(false);
                    htmlTreeBuilder.transition(InBody);
                    return true;
                }
                if (string.equals("frameset")) {
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InFrameset);
                    return true;
                }
                if (StringUtil.inSorted(string, Constants.InBodyStartToHead)) {
                    htmlTreeBuilder.error(this);
                    Element element = htmlTreeBuilder.getHeadElement();
                    htmlTreeBuilder.push(element);
                    htmlTreeBuilder.process(token, InHead);
                    htmlTreeBuilder.removeFromStack(element);
                    return true;
                }
                if (string.equals("head")) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                this.anythingElse(token, htmlTreeBuilder);
                return true;
            }
            if (!token.isEndTag()) {
                this.anythingElse(token, htmlTreeBuilder);
                return true;
            }
            if (StringUtil.inSorted(token.asEndTag().normalName(), Constants.AfterHeadBody)) {
                this.anythingElse(token, htmlTreeBuilder);
                return true;
            }
            htmlTreeBuilder.error(this);
            return false;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.processStartTag("body");
            htmlTreeBuilder.framesetOk(true);
            return htmlTreeBuilder.process(token);
        }
    }
    ,
    InBody{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case Character: {
                    Token.Character character = token.asCharacter();
                    if (character.getData().equals(nullString)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    if (htmlTreeBuilder.framesetOk() && HtmlTreeBuilderState.isWhitespace(character)) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(character);
                        break;
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(character);
                    htmlTreeBuilder.framesetOk(false);
                    break;
                }
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                case StartTag: {
                    return this.inBodyStartTag(token, htmlTreeBuilder);
                }
                case EndTag: {
                    return this.inBodyEndTag(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean inBodyStartTag(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            String string;
            Token.StartTag startTag = token.asStartTag();
            switch (string = startTag.normalName()) {
                case "a": {
                    if (htmlTreeBuilder.getActiveFormattingElement("a") != null) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.processEndTag("a");
                        Element element = htmlTreeBuilder.getFromStack("a");
                        if (element != null) {
                            htmlTreeBuilder.removeFromActiveFormattingElements(element);
                            htmlTreeBuilder.removeFromStack(element);
                        }
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    Element element = htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.pushActiveFormattingElements(element);
                    break;
                }
                case "span": {
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case "li": {
                    htmlTreeBuilder.framesetOk(false);
                    ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
                    for (int i = arrayList.size() - 1; i > 0; --i) {
                        Element element = arrayList.get(i);
                        if (element.normalName().equals("li")) {
                            htmlTreeBuilder.processEndTag("li");
                            break;
                        }
                        if (htmlTreeBuilder.isSpecial(element) && !StringUtil.inSorted(element.normalName(), Constants.InBodyStartLiBreakers)) break;
                    }
                    if (htmlTreeBuilder.inButtonScope("p")) {
                        htmlTreeBuilder.processEndTag("p");
                    }
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case "html": {
                    htmlTreeBuilder.error(this);
                    Element element = htmlTreeBuilder.getStack().get(0);
                    for (Attribute attribute : startTag.getAttributes()) {
                        if (element.hasAttr(attribute.getKey())) continue;
                        element.attributes().put(attribute);
                    }
                    break;
                }
                case "body": {
                    htmlTreeBuilder.error(this);
                    ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
                    if (arrayList.size() == 1 || arrayList.size() > 2 && !arrayList.get(1).normalName().equals("body")) {
                        return false;
                    }
                    htmlTreeBuilder.framesetOk(false);
                    Element element = arrayList.get(1);
                    for (Attribute attribute : startTag.getAttributes()) {
                        if (element.hasAttr(attribute.getKey())) continue;
                        element.attributes().put(attribute);
                    }
                    break;
                }
                case "frameset": {
                    htmlTreeBuilder.error(this);
                    ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
                    if (arrayList.size() == 1 || arrayList.size() > 2 && !arrayList.get(1).normalName().equals("body")) {
                        return false;
                    }
                    if (!htmlTreeBuilder.framesetOk()) {
                        return false;
                    }
                    Element element = arrayList.get(1);
                    if (element.parent() != null) {
                        element.remove();
                    }
                    while (arrayList.size() > 1) {
                        arrayList.remove(arrayList.size() - 1);
                    }
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InFrameset);
                    break;
                }
                case "form": {
                    if (htmlTreeBuilder.getFormElement() != null) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    if (htmlTreeBuilder.inButtonScope("p")) {
                        htmlTreeBuilder.processEndTag("p");
                    }
                    htmlTreeBuilder.insertForm(startTag, true);
                    break;
                }
                case "plaintext": {
                    if (htmlTreeBuilder.inButtonScope("p")) {
                        htmlTreeBuilder.processEndTag("p");
                    }
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.tokeniser.transition(TokeniserState.PLAINTEXT);
                    break;
                }
                case "button": {
                    if (htmlTreeBuilder.inButtonScope("button")) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.processEndTag("button");
                        htmlTreeBuilder.process(startTag);
                        break;
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.framesetOk(false);
                    break;
                }
                case "nobr": {
                    htmlTreeBuilder.reconstructFormattingElements();
                    if (htmlTreeBuilder.inScope("nobr")) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.processEndTag("nobr");
                        htmlTreeBuilder.reconstructFormattingElements();
                    }
                    Element element = htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.pushActiveFormattingElements(element);
                    break;
                }
                case "table": {
                    if (htmlTreeBuilder.getDocument().quirksMode() != Document.QuirksMode.quirks && htmlTreeBuilder.inButtonScope("p")) {
                        htmlTreeBuilder.processEndTag("p");
                    }
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.framesetOk(false);
                    htmlTreeBuilder.transition(InTable);
                    break;
                }
                case "input": {
                    htmlTreeBuilder.reconstructFormattingElements();
                    Element element = htmlTreeBuilder.insertEmpty(startTag);
                    if (element.attr("type").equalsIgnoreCase("hidden")) break;
                    htmlTreeBuilder.framesetOk(false);
                    break;
                }
                case "hr": {
                    if (htmlTreeBuilder.inButtonScope("p")) {
                        htmlTreeBuilder.processEndTag("p");
                    }
                    htmlTreeBuilder.insertEmpty(startTag);
                    htmlTreeBuilder.framesetOk(false);
                    break;
                }
                case "image": {
                    if (htmlTreeBuilder.getFromStack("svg") == null) {
                        return htmlTreeBuilder.process(startTag.name("img"));
                    }
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case "isindex": {
                    Object object;
                    htmlTreeBuilder.error(this);
                    if (htmlTreeBuilder.getFormElement() != null) {
                        return false;
                    }
                    htmlTreeBuilder.processStartTag("form");
                    if (startTag.attributes.hasKey("action")) {
                        object = htmlTreeBuilder.getFormElement();
                        ((Element)object).attr("action", startTag.attributes.get("action"));
                    }
                    htmlTreeBuilder.processStartTag("hr");
                    htmlTreeBuilder.processStartTag("label");
                    object = startTag.attributes.hasKey("prompt") ? startTag.attributes.get("prompt") : "This is a searchable index. Enter search keywords: ";
                    htmlTreeBuilder.process(new Token.Character().data((String)object));
                    Attributes attributes = new Attributes();
                    for (Attribute attribute : startTag.attributes) {
                        if (StringUtil.inSorted(attribute.getKey(), Constants.InBodyStartInputAttribs)) continue;
                        attributes.put(attribute);
                    }
                    attributes.put("name", "isindex");
                    htmlTreeBuilder.processStartTag("input", attributes);
                    htmlTreeBuilder.processEndTag("label");
                    htmlTreeBuilder.processStartTag("hr");
                    htmlTreeBuilder.processEndTag("form");
                    break;
                }
                case "textarea": {
                    htmlTreeBuilder.insert(startTag);
                    if (startTag.isSelfClosing()) break;
                    htmlTreeBuilder.tokeniser.transition(TokeniserState.Rcdata);
                    htmlTreeBuilder.markInsertionMode();
                    htmlTreeBuilder.framesetOk(false);
                    htmlTreeBuilder.transition(Text);
                    break;
                }
                case "xmp": {
                    if (htmlTreeBuilder.inButtonScope("p")) {
                        htmlTreeBuilder.processEndTag("p");
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.framesetOk(false);
                    HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                    break;
                }
                case "iframe": {
                    htmlTreeBuilder.framesetOk(false);
                    HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                    break;
                }
                case "noembed": {
                    HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                    break;
                }
                case "select": {
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.framesetOk(false);
                    HtmlTreeBuilderState htmlTreeBuilderState = htmlTreeBuilder.state();
                    if (htmlTreeBuilderState.equals((Object)InTable) || htmlTreeBuilderState.equals((Object)InCaption) || htmlTreeBuilderState.equals((Object)InTableBody) || htmlTreeBuilderState.equals((Object)InRow) || htmlTreeBuilderState.equals((Object)InCell)) {
                        htmlTreeBuilder.transition(InSelectInTable);
                        break;
                    }
                    htmlTreeBuilder.transition(InSelect);
                    break;
                }
                case "math": {
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case "svg": {
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    if (htmlTreeBuilder.inButtonScope("p")) {
                        htmlTreeBuilder.processEndTag("p");
                    }
                    if (StringUtil.inSorted(htmlTreeBuilder.currentElement().normalName(), Constants.Headings)) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.pop();
                    }
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case "pre": 
                case "listing": {
                    if (htmlTreeBuilder.inButtonScope("p")) {
                        htmlTreeBuilder.processEndTag("p");
                    }
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.reader.matchConsume("\n");
                    htmlTreeBuilder.framesetOk(false);
                    break;
                }
                case "dd": 
                case "dt": {
                    htmlTreeBuilder.framesetOk(false);
                    ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
                    for (int i = arrayList.size() - 1; i > 0; --i) {
                        Element element = arrayList.get(i);
                        if (StringUtil.inSorted(element.normalName(), Constants.DdDt)) {
                            htmlTreeBuilder.processEndTag(element.normalName());
                            break;
                        }
                        if (htmlTreeBuilder.isSpecial(element) && !StringUtil.inSorted(element.normalName(), Constants.InBodyStartLiBreakers)) break;
                    }
                    if (htmlTreeBuilder.inButtonScope("p")) {
                        htmlTreeBuilder.processEndTag("p");
                    }
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case "optgroup": 
                case "option": {
                    if (htmlTreeBuilder.currentElement().normalName().equals("option")) {
                        htmlTreeBuilder.processEndTag("option");
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case "rp": 
                case "rt": {
                    if (!htmlTreeBuilder.inScope("ruby")) break;
                    htmlTreeBuilder.generateImpliedEndTags();
                    if (!htmlTreeBuilder.currentElement().normalName().equals("ruby")) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.popStackToBefore("ruby");
                    }
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                default: {
                    if (StringUtil.inSorted(string, Constants.InBodyStartEmptyFormatters)) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insertEmpty(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartPClosers)) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartToHead)) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    if (StringUtil.inSorted(string, Constants.Formatters)) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        Element element = htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.pushActiveFormattingElements(element);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartApplets)) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.insertMarkerToFormattingElements();
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartMedia)) {
                        htmlTreeBuilder.insertEmpty(startTag);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartDrop)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                }
            }
            return true;
        }

        private boolean inBodyEndTag(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            String string;
            Token.EndTag endTag = token.asEndTag();
            switch (string = endTag.normalName()) {
                case "sarcasm": 
                case "span": {
                    return this.anyOtherEndTag(token, htmlTreeBuilder);
                }
                case "li": {
                    if (!htmlTreeBuilder.inListItemScope(string)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.generateImpliedEndTags(string);
                    if (!htmlTreeBuilder.currentElement().normalName().equals(string)) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(string);
                    break;
                }
                case "body": {
                    if (!htmlTreeBuilder.inScope("body")) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.transition(AfterBody);
                    break;
                }
                case "html": {
                    boolean bl = htmlTreeBuilder.processEndTag("body");
                    if (!bl) break;
                    return htmlTreeBuilder.process(endTag);
                }
                case "form": {
                    FormElement formElement = htmlTreeBuilder.getFormElement();
                    htmlTreeBuilder.setFormElement(null);
                    if (formElement == null || !htmlTreeBuilder.inScope(string)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.generateImpliedEndTags();
                    if (!htmlTreeBuilder.currentElement().normalName().equals(string)) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.removeFromStack(formElement);
                    break;
                }
                case "p": {
                    if (!htmlTreeBuilder.inButtonScope(string)) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.processStartTag(string);
                        return htmlTreeBuilder.process(endTag);
                    }
                    htmlTreeBuilder.generateImpliedEndTags(string);
                    if (!htmlTreeBuilder.currentElement().normalName().equals(string)) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(string);
                    break;
                }
                case "dd": 
                case "dt": {
                    if (!htmlTreeBuilder.inScope(string)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.generateImpliedEndTags(string);
                    if (!htmlTreeBuilder.currentElement().normalName().equals(string)) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(string);
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    if (!htmlTreeBuilder.inScope(Constants.Headings)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.generateImpliedEndTags(string);
                    if (!htmlTreeBuilder.currentElement().normalName().equals(string)) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(Constants.Headings);
                    break;
                }
                case "br": {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.processStartTag("br");
                    return false;
                }
                default: {
                    if (StringUtil.inSorted(string, Constants.InBodyEndAdoptionFormatters)) {
                        return this.inBodyEndTagAdoption(token, htmlTreeBuilder);
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyEndClosers)) {
                        if (!htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().normalName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartApplets)) {
                        if (htmlTreeBuilder.inScope("name")) break;
                        if (!htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().normalName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        htmlTreeBuilder.clearFormattingElementsToLastMarker();
                        break;
                    }
                    return this.anyOtherEndTag(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        boolean anyOtherEndTag(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            String string = token.asEndTag().normalName;
            ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Element element = arrayList.get(i);
                if (element.normalName().equals(string)) {
                    htmlTreeBuilder.generateImpliedEndTags(string);
                    if (!string.equals(htmlTreeBuilder.currentElement().normalName())) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(string);
                    break;
                }
                if (!htmlTreeBuilder.isSpecial(element)) continue;
                htmlTreeBuilder.error(this);
                return false;
            }
            return true;
        }

        private boolean inBodyEndTagAdoption(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            Token.EndTag endTag = token.asEndTag();
            String string = endTag.normalName();
            ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
            for (int i = 0; i < 8; ++i) {
                Node[] nodeArray;
                Element element = htmlTreeBuilder.getActiveFormattingElement(string);
                if (element == null) {
                    return this.anyOtherEndTag(token, htmlTreeBuilder);
                }
                if (!htmlTreeBuilder.onStack(element)) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.removeFromActiveFormattingElements(element);
                    return true;
                }
                if (!htmlTreeBuilder.inScope(element.normalName())) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (htmlTreeBuilder.currentElement() != element) {
                    htmlTreeBuilder.error(this);
                }
                Element element2 = null;
                Element element3 = null;
                boolean bl = false;
                int n = arrayList.size();
                for (int j = 0; j < n && j < 64; ++j) {
                    Element element4 = arrayList.get(j);
                    if (element4 == element) {
                        element3 = arrayList.get(j - 1);
                        bl = true;
                        continue;
                    }
                    if (!bl || !htmlTreeBuilder.isSpecial(element4)) continue;
                    element2 = element4;
                    break;
                }
                if (element2 == null) {
                    htmlTreeBuilder.popStackToClose(element.normalName());
                    htmlTreeBuilder.removeFromActiveFormattingElements(element);
                    return true;
                }
                Element element5 = element2;
                Element element6 = element2;
                for (int j = 0; j < 3; ++j) {
                    if (htmlTreeBuilder.onStack(element5)) {
                        element5 = htmlTreeBuilder.aboveOnStack(element5);
                    }
                    if (!htmlTreeBuilder.isInActiveFormattingElements(element5)) {
                        htmlTreeBuilder.removeFromStack(element5);
                        continue;
                    }
                    if (element5 == element) break;
                    nodeArray = new Element(Tag.valueOf(element5.nodeName(), ParseSettings.preserveCase), htmlTreeBuilder.getBaseUri());
                    htmlTreeBuilder.replaceActiveFormattingElement(element5, (Element)nodeArray);
                    htmlTreeBuilder.replaceOnStack(element5, (Element)nodeArray);
                    element5 = nodeArray;
                    if (element6 == element2) {
                        // empty if block
                    }
                    if (element6.parent() != null) {
                        element6.remove();
                    }
                    element5.appendChild(element6);
                    element6 = element5;
                }
                if (StringUtil.inSorted(element3.normalName(), Constants.InBodyEndTableFosters)) {
                    if (element6.parent() != null) {
                        element6.remove();
                    }
                    htmlTreeBuilder.insertInFosterParent(element6);
                } else {
                    if (element6.parent() != null) {
                        element6.remove();
                    }
                    element3.appendChild(element6);
                }
                Element element7 = new Element(element.tag(), htmlTreeBuilder.getBaseUri());
                element7.attributes().addAll(element.attributes());
                for (Node node : nodeArray = element2.childNodes().toArray(new Node[0])) {
                    element7.appendChild(node);
                }
                element2.appendChild(element7);
                htmlTreeBuilder.removeFromActiveFormattingElements(element);
                htmlTreeBuilder.removeFromStack(element);
                htmlTreeBuilder.insertOnStackAfter(element2, element7);
            }
            return true;
        }
    }
    ,
    Text{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isCharacter()) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else {
                if (token.isEOF()) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.pop();
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                    return htmlTreeBuilder.process(token);
                }
                if (token.isEndTag()) {
                    htmlTreeBuilder.pop();
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                }
            }
            return true;
        }
    }
    ,
    InTable{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isCharacter()) {
                htmlTreeBuilder.newPendingTableCharacters();
                htmlTreeBuilder.markInsertionMode();
                htmlTreeBuilder.transition(InTableText);
                return htmlTreeBuilder.process(token);
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
                return true;
            }
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.normalName();
                if (string.equals("caption")) {
                    htmlTreeBuilder.clearStackToTableContext();
                    htmlTreeBuilder.insertMarkerToFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InCaption);
                } else if (string.equals("colgroup")) {
                    htmlTreeBuilder.clearStackToTableContext();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InColumnGroup);
                } else {
                    if (string.equals("col")) {
                        htmlTreeBuilder.processStartTag("colgroup");
                        return htmlTreeBuilder.process(token);
                    }
                    if (StringUtil.inSorted(string, Constants.InTableToBody)) {
                        htmlTreeBuilder.clearStackToTableContext();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InTableBody);
                    } else {
                        if (StringUtil.inSorted(string, Constants.InTableAddBody)) {
                            htmlTreeBuilder.processStartTag("tbody");
                            return htmlTreeBuilder.process(token);
                        }
                        if (string.equals("table")) {
                            htmlTreeBuilder.error(this);
                            boolean bl = htmlTreeBuilder.processEndTag("table");
                            if (bl) {
                                return htmlTreeBuilder.process(token);
                            }
                        } else {
                            if (StringUtil.inSorted(string, Constants.InTableToHead)) {
                                return htmlTreeBuilder.process(token, InHead);
                            }
                            if (string.equals("input")) {
                                if (!startTag.attributes.get("type").equalsIgnoreCase("hidden")) {
                                    return this.anythingElse(token, htmlTreeBuilder);
                                }
                                htmlTreeBuilder.insertEmpty(startTag);
                            } else if (string.equals("form")) {
                                htmlTreeBuilder.error(this);
                                if (htmlTreeBuilder.getFormElement() != null) {
                                    return false;
                                }
                                htmlTreeBuilder.insertForm(startTag, false);
                            } else {
                                return this.anythingElse(token, htmlTreeBuilder);
                            }
                        }
                    }
                }
                return true;
            }
            if (token.isEndTag()) {
                Token.EndTag endTag = token.asEndTag();
                String string = endTag.normalName();
                if (string.equals("table")) {
                    if (!htmlTreeBuilder.inTableScope(string)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                } else {
                    if (StringUtil.inSorted(string, Constants.InTableEndErr)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                htmlTreeBuilder.popStackToClose("table");
                htmlTreeBuilder.resetInsertionMode();
                return true;
            }
            if (token.isEOF()) {
                if (htmlTreeBuilder.currentElement().normalName().equals("html")) {
                    htmlTreeBuilder.error(this);
                }
                return true;
            }
            return this.anythingElse(token, htmlTreeBuilder);
        }

        boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            boolean bl;
            htmlTreeBuilder.error(this);
            if (StringUtil.inSorted(htmlTreeBuilder.currentElement().normalName(), Constants.InTableFoster)) {
                htmlTreeBuilder.setFosterInserts(true);
                bl = htmlTreeBuilder.process(token, InBody);
                htmlTreeBuilder.setFosterInserts(false);
            } else {
                bl = htmlTreeBuilder.process(token, InBody);
            }
            return bl;
        }
    }
    ,
    InTableText{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            Token.Character character;
            if (token.type == Token.TokenType.Character) {
                character = token.asCharacter();
                if (character.getData().equals(nullString)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
            } else {
                if (htmlTreeBuilder.getPendingTableCharacters().size() > 0) {
                    for (String string : htmlTreeBuilder.getPendingTableCharacters()) {
                        if (!HtmlTreeBuilderState.isWhitespace(string)) {
                            htmlTreeBuilder.error(this);
                            if (StringUtil.inSorted(htmlTreeBuilder.currentElement().normalName(), Constants.InTableFoster)) {
                                htmlTreeBuilder.setFosterInserts(true);
                                htmlTreeBuilder.process(new Token.Character().data(string), InBody);
                                htmlTreeBuilder.setFosterInserts(false);
                                continue;
                            }
                            htmlTreeBuilder.process(new Token.Character().data(string), InBody);
                            continue;
                        }
                        htmlTreeBuilder.insert(new Token.Character().data(string));
                    }
                    htmlTreeBuilder.newPendingTableCharacters();
                }
                htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                return htmlTreeBuilder.process(token);
            }
            htmlTreeBuilder.getPendingTableCharacters().add(character.getData());
            return true;
        }
    }
    ,
    InCaption{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isEndTag() && token.asEndTag().normalName().equals("caption")) {
                Token.EndTag endTag = token.asEndTag();
                String string = endTag.normalName();
                if (!htmlTreeBuilder.inTableScope(string)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                htmlTreeBuilder.generateImpliedEndTags();
                if (!htmlTreeBuilder.currentElement().normalName().equals("caption")) {
                    htmlTreeBuilder.error(this);
                }
                htmlTreeBuilder.popStackToClose("caption");
                htmlTreeBuilder.clearFormattingElementsToLastMarker();
                htmlTreeBuilder.transition(InTable);
            } else if (token.isStartTag() && StringUtil.inSorted(token.asStartTag().normalName(), Constants.InCellCol) || token.isEndTag() && token.asEndTag().normalName().equals("table")) {
                htmlTreeBuilder.error(this);
                boolean bl = htmlTreeBuilder.processEndTag("caption");
                if (bl) {
                    return htmlTreeBuilder.process(token);
                }
            } else {
                if (token.isEndTag() && StringUtil.inSorted(token.asEndTag().normalName(), Constants.InCaptionIgnore)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                return htmlTreeBuilder.process(token, InBody);
            }
            return true;
        }
    }
    ,
    InColumnGroup{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            block0 : switch (token.type) {
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    break;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    switch (startTag.normalName()) {
                        case "html": {
                            return htmlTreeBuilder.process(token, InBody);
                        }
                        case "col": {
                            htmlTreeBuilder.insertEmpty(startTag);
                            break block0;
                        }
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    if (endTag.normalName.equals("colgroup")) {
                        if (htmlTreeBuilder.currentElement().normalName().equals("html")) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.pop();
                        htmlTreeBuilder.transition(InTable);
                        break;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EOF: {
                    if (htmlTreeBuilder.currentElement().normalName().equals("html")) {
                        return true;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, TreeBuilder treeBuilder) {
            boolean bl = treeBuilder.processEndTag("colgroup");
            if (bl) {
                return treeBuilder.process(token);
            }
            return true;
        }
    }
    ,
    InTableBody{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.normalName();
                    if (string.equals("template")) {
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("tr")) {
                        htmlTreeBuilder.clearStackToTableBodyContext();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InRow);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InCellNames)) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.processStartTag("tr");
                        return htmlTreeBuilder.process(startTag);
                    }
                    if (StringUtil.inSorted(string, Constants.InTableBodyExit)) {
                        return this.exitTableBody(token, htmlTreeBuilder);
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.normalName();
                    if (StringUtil.inSorted(string, Constants.InTableEndIgnore)) {
                        if (!htmlTreeBuilder.inTableScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.clearStackToTableBodyContext();
                        htmlTreeBuilder.pop();
                        htmlTreeBuilder.transition(InTable);
                        break;
                    }
                    if (string.equals("table")) {
                        return this.exitTableBody(token, htmlTreeBuilder);
                    }
                    if (StringUtil.inSorted(string, Constants.InTableBodyEndIgnore)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean exitTableBody(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (!(htmlTreeBuilder.inTableScope("tbody") || htmlTreeBuilder.inTableScope("thead") || htmlTreeBuilder.inScope("tfoot"))) {
                htmlTreeBuilder.error(this);
                return false;
            }
            htmlTreeBuilder.clearStackToTableBodyContext();
            htmlTreeBuilder.processEndTag(htmlTreeBuilder.currentElement().normalName());
            return htmlTreeBuilder.process(token);
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return htmlTreeBuilder.process(token, InTable);
        }
    }
    ,
    InRow{

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.normalName();
                if (string.equals("template")) {
                    htmlTreeBuilder.insert(startTag);
                    return true;
                }
                if (StringUtil.inSorted(string, Constants.InCellNames)) {
                    htmlTreeBuilder.clearStackToTableRowContext();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InCell);
                    htmlTreeBuilder.insertMarkerToFormattingElements();
                    return true;
                }
                if (!StringUtil.inSorted(string, Constants.InRowMissing)) return this.anythingElse(token, htmlTreeBuilder);
                return this.handleMissingTr(token, htmlTreeBuilder);
            }
            if (!token.isEndTag()) return this.anythingElse(token, htmlTreeBuilder);
            Token.EndTag endTag = token.asEndTag();
            String string = endTag.normalName();
            if (string.equals("tr")) {
                if (!htmlTreeBuilder.inTableScope(string)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                htmlTreeBuilder.clearStackToTableRowContext();
                htmlTreeBuilder.pop();
                htmlTreeBuilder.transition(InTableBody);
                return true;
            }
            if (string.equals("table")) {
                return this.handleMissingTr(token, htmlTreeBuilder);
            }
            if (!StringUtil.inSorted(string, Constants.InTableToBody)) {
                if (!StringUtil.inSorted(string, Constants.InRowIgnore)) return this.anythingElse(token, htmlTreeBuilder);
                htmlTreeBuilder.error(this);
                return false;
            }
            if (!htmlTreeBuilder.inTableScope(string)) {
                htmlTreeBuilder.error(this);
                return false;
            }
            htmlTreeBuilder.processEndTag("tr");
            return htmlTreeBuilder.process(token);
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return htmlTreeBuilder.process(token, InTable);
        }

        private boolean handleMissingTr(Token token, TreeBuilder treeBuilder) {
            boolean bl = treeBuilder.processEndTag("tr");
            if (bl) {
                return treeBuilder.process(token);
            }
            return false;
        }
    }
    ,
    InCell{

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isEndTag()) {
                Token.EndTag endTag = token.asEndTag();
                String string = endTag.normalName();
                if (StringUtil.inSorted(string, Constants.InCellNames)) {
                    if (!htmlTreeBuilder.inTableScope(string)) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.transition(InRow);
                        return false;
                    }
                    htmlTreeBuilder.generateImpliedEndTags();
                    if (!htmlTreeBuilder.currentElement().normalName().equals(string)) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(string);
                    htmlTreeBuilder.clearFormattingElementsToLastMarker();
                    htmlTreeBuilder.transition(InRow);
                    return true;
                }
                if (StringUtil.inSorted(string, Constants.InCellBody)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (!StringUtil.inSorted(string, Constants.InCellTable)) return this.anythingElse(token, htmlTreeBuilder);
                if (!htmlTreeBuilder.inTableScope(string)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                this.closeCell(htmlTreeBuilder);
                return htmlTreeBuilder.process(token);
            }
            if (!token.isStartTag()) return this.anythingElse(token, htmlTreeBuilder);
            if (!StringUtil.inSorted(token.asStartTag().normalName(), Constants.InCellCol)) return this.anythingElse(token, htmlTreeBuilder);
            if (!htmlTreeBuilder.inTableScope("td") && !htmlTreeBuilder.inTableScope("th")) {
                htmlTreeBuilder.error(this);
                return false;
            }
            this.closeCell(htmlTreeBuilder);
            return htmlTreeBuilder.process(token);
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return htmlTreeBuilder.process(token, InBody);
        }

        private void closeCell(HtmlTreeBuilder htmlTreeBuilder) {
            if (htmlTreeBuilder.inTableScope("td")) {
                htmlTreeBuilder.processEndTag("td");
            } else {
                htmlTreeBuilder.processEndTag("th");
            }
        }
    }
    ,
    InSelect{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            block0 : switch (token.type) {
                case Character: {
                    Token.Character character = token.asCharacter();
                    if (character.getData().equals(nullString)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.insert(character);
                    break;
                }
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.normalName();
                    if (string.equals("html")) {
                        return htmlTreeBuilder.process(startTag, InBody);
                    }
                    if (string.equals("option")) {
                        if (htmlTreeBuilder.currentElement().normalName().equals("option")) {
                            htmlTreeBuilder.processEndTag("option");
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("optgroup")) {
                        if (htmlTreeBuilder.currentElement().normalName().equals("option")) {
                            htmlTreeBuilder.processEndTag("option");
                        }
                        if (htmlTreeBuilder.currentElement().normalName().equals("optgroup")) {
                            htmlTreeBuilder.processEndTag("optgroup");
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("select")) {
                        htmlTreeBuilder.error(this);
                        return htmlTreeBuilder.processEndTag("select");
                    }
                    if (StringUtil.inSorted(string, Constants.InSelectEnd)) {
                        htmlTreeBuilder.error(this);
                        if (!htmlTreeBuilder.inSelectScope("select")) {
                            return false;
                        }
                        htmlTreeBuilder.processEndTag("select");
                        return htmlTreeBuilder.process(startTag);
                    }
                    if (string.equals("script")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    String string;
                    Token.EndTag endTag = token.asEndTag();
                    switch (string = endTag.normalName()) {
                        case "optgroup": {
                            if (htmlTreeBuilder.currentElement().normalName().equals("option") && htmlTreeBuilder.aboveOnStack(htmlTreeBuilder.currentElement()) != null && htmlTreeBuilder.aboveOnStack(htmlTreeBuilder.currentElement()).normalName().equals("optgroup")) {
                                htmlTreeBuilder.processEndTag("option");
                            }
                            if (htmlTreeBuilder.currentElement().normalName().equals("optgroup")) {
                                htmlTreeBuilder.pop();
                                break block0;
                            }
                            htmlTreeBuilder.error(this);
                            break block0;
                        }
                        case "option": {
                            if (htmlTreeBuilder.currentElement().normalName().equals("option")) {
                                htmlTreeBuilder.pop();
                                break block0;
                            }
                            htmlTreeBuilder.error(this);
                            break block0;
                        }
                        case "select": {
                            if (!htmlTreeBuilder.inSelectScope(string)) {
                                htmlTreeBuilder.error(this);
                                return false;
                            }
                            htmlTreeBuilder.popStackToClose(string);
                            htmlTreeBuilder.resetInsertionMode();
                            break block0;
                        }
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EOF: {
                    if (htmlTreeBuilder.currentElement().normalName().equals("html")) break;
                    htmlTreeBuilder.error(this);
                    break;
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.error(this);
            return false;
        }
    }
    ,
    InSelectInTable{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isStartTag() && StringUtil.inSorted(token.asStartTag().normalName(), Constants.InSelecTableEnd)) {
                htmlTreeBuilder.error(this);
                htmlTreeBuilder.processEndTag("select");
                return htmlTreeBuilder.process(token);
            }
            if (token.isEndTag() && StringUtil.inSorted(token.asEndTag().normalName(), Constants.InSelecTableEnd)) {
                htmlTreeBuilder.error(this);
                if (htmlTreeBuilder.inTableScope(token.asEndTag().normalName())) {
                    htmlTreeBuilder.processEndTag("select");
                    return htmlTreeBuilder.process(token);
                }
                return false;
            }
            return htmlTreeBuilder.process(token, InSelect);
        }
    }
    ,
    AfterBody{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag() && token.asStartTag().normalName().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (token.isEndTag() && token.asEndTag().normalName().equals("html")) {
                    if (htmlTreeBuilder.isFragmentParsing()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.transition(AfterAfterBody);
                } else if (!token.isEOF()) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.transition(InBody);
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    InFrameset{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag()) {
                    Token.StartTag startTag = token.asStartTag();
                    switch (startTag.normalName()) {
                        case "html": {
                            return htmlTreeBuilder.process(startTag, InBody);
                        }
                        case "frameset": {
                            htmlTreeBuilder.insert(startTag);
                            break;
                        }
                        case "frame": {
                            htmlTreeBuilder.insertEmpty(startTag);
                            break;
                        }
                        case "noframes": {
                            return htmlTreeBuilder.process(startTag, InHead);
                        }
                        default: {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                    }
                } else if (token.isEndTag() && token.asEndTag().normalName().equals("frameset")) {
                    if (htmlTreeBuilder.currentElement().normalName().equals("html")) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.pop();
                    if (!htmlTreeBuilder.isFragmentParsing() && !htmlTreeBuilder.currentElement().normalName().equals("frameset")) {
                        htmlTreeBuilder.transition(AfterFrameset);
                    }
                } else if (token.isEOF()) {
                    if (!htmlTreeBuilder.currentElement().normalName().equals("html")) {
                        htmlTreeBuilder.error(this);
                        return true;
                    }
                } else {
                    htmlTreeBuilder.error(this);
                    return false;
                }
            }
            return true;
        }
    }
    ,
    AfterFrameset{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag() && token.asStartTag().normalName().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (token.isEndTag() && token.asEndTag().normalName().equals("html")) {
                    htmlTreeBuilder.transition(AfterAfterFrameset);
                } else {
                    if (token.isStartTag() && token.asStartTag().normalName().equals("noframes")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    if (!token.isEOF()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                }
            }
            return true;
        }
    }
    ,
    AfterAfterBody{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype() || token.isStartTag() && token.asStartTag().normalName().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (HtmlTreeBuilderState.isWhitespace(token)) {
                    Element element = htmlTreeBuilder.popStackToClose("html");
                    htmlTreeBuilder.insert(token.asCharacter());
                    htmlTreeBuilder.stack.add(element);
                    htmlTreeBuilder.stack.add(element.selectFirst("body"));
                } else if (!token.isEOF()) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.transition(InBody);
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    AfterAfterFrameset{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype() || HtmlTreeBuilderState.isWhitespace(token) || token.isStartTag() && token.asStartTag().normalName().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (!token.isEOF()) {
                    if (token.isStartTag() && token.asStartTag().normalName().equals("noframes")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    htmlTreeBuilder.error(this);
                    return false;
                }
            }
            return true;
        }
    }
    ,
    ForeignContent{

        @Override
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return true;
        }
    };

    private static final String nullString;

    abstract boolean process(Token var1, HtmlTreeBuilder var2);

    private static boolean isWhitespace(Token token) {
        if (token.isCharacter()) {
            String string = token.asCharacter().getData();
            return StringUtil.isBlank(string);
        }
        return false;
    }

    private static boolean isWhitespace(String string) {
        return StringUtil.isBlank(string);
    }

    private static void handleRcData(Token.StartTag startTag, HtmlTreeBuilder htmlTreeBuilder) {
        htmlTreeBuilder.tokeniser.transition(TokeniserState.Rcdata);
        htmlTreeBuilder.markInsertionMode();
        htmlTreeBuilder.transition(Text);
        htmlTreeBuilder.insert(startTag);
    }

    private static void handleRawtext(Token.StartTag startTag, HtmlTreeBuilder htmlTreeBuilder) {
        htmlTreeBuilder.tokeniser.transition(TokeniserState.Rawtext);
        htmlTreeBuilder.markInsertionMode();
        htmlTreeBuilder.transition(Text);
        htmlTreeBuilder.insert(startTag);
    }

    static {
        nullString = String.valueOf('\u0000');
    }

    static final class Constants {
        static final String[] InHeadEmpty = new String[]{"base", "basefont", "bgsound", "command", "link"};
        static final String[] InHeadRaw = new String[]{"noframes", "style"};
        static final String[] InHeadEnd = new String[]{"body", "br", "html"};
        static final String[] AfterHeadBody = new String[]{"body", "html"};
        static final String[] BeforeHtmlToHead = new String[]{"body", "br", "head", "html"};
        static final String[] InHeadNoScriptHead = new String[]{"basefont", "bgsound", "link", "meta", "noframes", "style"};
        static final String[] InBodyStartToHead = new String[]{"base", "basefont", "bgsound", "command", "link", "meta", "noframes", "script", "style", "title"};
        static final String[] InBodyStartPClosers = new String[]{"address", "article", "aside", "blockquote", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "menu", "nav", "ol", "p", "section", "summary", "ul"};
        static final String[] Headings = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
        static final String[] InBodyStartLiBreakers = new String[]{"address", "div", "p"};
        static final String[] DdDt = new String[]{"dd", "dt"};
        static final String[] Formatters = new String[]{"b", "big", "code", "em", "font", "i", "s", "small", "strike", "strong", "tt", "u"};
        static final String[] InBodyStartApplets = new String[]{"applet", "marquee", "object"};
        static final String[] InBodyStartEmptyFormatters = new String[]{"area", "br", "embed", "img", "keygen", "wbr"};
        static final String[] InBodyStartMedia = new String[]{"param", "source", "track"};
        static final String[] InBodyStartInputAttribs = new String[]{"action", "name", "prompt"};
        static final String[] InBodyStartDrop = new String[]{"caption", "col", "colgroup", "frame", "head", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InBodyEndClosers = new String[]{"address", "article", "aside", "blockquote", "button", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "listing", "menu", "nav", "ol", "pre", "section", "summary", "ul"};
        static final String[] InBodyEndAdoptionFormatters = new String[]{"a", "b", "big", "code", "em", "font", "i", "nobr", "s", "small", "strike", "strong", "tt", "u"};
        static final String[] InBodyEndTableFosters = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
        static final String[] InTableToBody = new String[]{"tbody", "tfoot", "thead"};
        static final String[] InTableAddBody = new String[]{"td", "th", "tr"};
        static final String[] InTableToHead = new String[]{"script", "style"};
        static final String[] InCellNames = new String[]{"td", "th"};
        static final String[] InCellBody = new String[]{"body", "caption", "col", "colgroup", "html"};
        static final String[] InCellTable = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
        static final String[] InCellCol = new String[]{"caption", "col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTableEndErr = new String[]{"body", "caption", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTableFoster = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
        static final String[] InTableBodyExit = new String[]{"caption", "col", "colgroup", "tbody", "tfoot", "thead"};
        static final String[] InTableBodyEndIgnore = new String[]{"body", "caption", "col", "colgroup", "html", "td", "th", "tr"};
        static final String[] InRowMissing = new String[]{"caption", "col", "colgroup", "tbody", "tfoot", "thead", "tr"};
        static final String[] InRowIgnore = new String[]{"body", "caption", "col", "colgroup", "html", "td", "th"};
        static final String[] InSelectEnd = new String[]{"input", "keygen", "textarea"};
        static final String[] InSelecTableEnd = new String[]{"caption", "table", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTableEndIgnore = new String[]{"tbody", "tfoot", "thead"};
        static final String[] InHeadNoscriptIgnore = new String[]{"head", "noscript"};
        static final String[] InCaptionIgnore = new String[]{"body", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr"};

        Constants() {
        }
    }
}

