/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.internal.Normalizer;
import org.jsoup.nodes.Attributes;

public class ParseSettings {
    public static final ParseSettings htmlDefault = new ParseSettings(false, false);
    public static final ParseSettings preserveCase = new ParseSettings(true, true);
    private final boolean preserveTagCase;
    private final boolean preserveAttributeCase;

    public boolean preserveTagCase() {
        return this.preserveTagCase;
    }

    public boolean preserveAttributeCase() {
        return this.preserveAttributeCase;
    }

    public ParseSettings(boolean bl, boolean bl2) {
        this.preserveTagCase = bl;
        this.preserveAttributeCase = bl2;
    }

    public String normalizeTag(String string) {
        string = string.trim();
        if (!this.preserveTagCase) {
            string = Normalizer.lowerCase(string);
        }
        return string;
    }

    public String normalizeAttribute(String string) {
        string = string.trim();
        if (!this.preserveAttributeCase) {
            string = Normalizer.lowerCase(string);
        }
        return string;
    }

    Attributes normalizeAttributes(Attributes attributes) {
        if (attributes != null && !this.preserveAttributeCase) {
            attributes.normalize();
        }
        return attributes;
    }
}

