/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.HtmlTreeBuilder;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Tokeniser;
import org.jsoup.parser.TreeBuilder;
import org.jsoup.parser.XmlTreeBuilder;

public class Parser {
    private TreeBuilder treeBuilder;
    private ParseErrorList errors;
    private ParseSettings settings;

    public Parser(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        this.settings = treeBuilder.defaultSettings();
        this.errors = ParseErrorList.noTracking();
    }

    public Document parseInput(String string, String string2) {
        return this.treeBuilder.parse(new StringReader(string), string2, this);
    }

    public Document parseInput(Reader reader, String string) {
        return this.treeBuilder.parse(reader, string, this);
    }

    public List<Node> parseFragmentInput(String string, Element element, String string2) {
        return this.treeBuilder.parseFragment(string, element, string2, this);
    }

    public TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public Parser setTreeBuilder(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        treeBuilder.parser = this;
        return this;
    }

    public boolean isTrackErrors() {
        return this.errors.getMaxSize() > 0;
    }

    public Parser setTrackErrors(int n) {
        this.errors = n > 0 ? ParseErrorList.tracking(n) : ParseErrorList.noTracking();
        return this;
    }

    public ParseErrorList getErrors() {
        return this.errors;
    }

    public Parser settings(ParseSettings parseSettings) {
        this.settings = parseSettings;
        return this;
    }

    public ParseSettings settings() {
        return this.settings;
    }

    public static Document parse(String string, String string2) {
        HtmlTreeBuilder htmlTreeBuilder = new HtmlTreeBuilder();
        return htmlTreeBuilder.parse(new StringReader(string), string2, new Parser(htmlTreeBuilder));
    }

    public static List<Node> parseFragment(String string, Element element, String string2) {
        HtmlTreeBuilder htmlTreeBuilder = new HtmlTreeBuilder();
        return htmlTreeBuilder.parseFragment(string, element, string2, new Parser(htmlTreeBuilder));
    }

    public static List<Node> parseFragment(String string, Element element, String string2, ParseErrorList parseErrorList) {
        HtmlTreeBuilder htmlTreeBuilder = new HtmlTreeBuilder();
        Parser parser = new Parser(htmlTreeBuilder);
        parser.errors = parseErrorList;
        return htmlTreeBuilder.parseFragment(string, element, string2, parser);
    }

    public static List<Node> parseXmlFragment(String string, String string2) {
        XmlTreeBuilder xmlTreeBuilder = new XmlTreeBuilder();
        return xmlTreeBuilder.parseFragment(string, string2, new Parser(xmlTreeBuilder));
    }

    public static Document parseBodyFragment(String string, String string2) {
        Document document = Document.createShell(string2);
        Element element = document.body();
        List<Node> list = Parser.parseFragment(string, element, string2);
        Node[] nodeArray = list.toArray(new Node[0]);
        for (int i = nodeArray.length - 1; i > 0; --i) {
            nodeArray[i].remove();
        }
        for (Node node : nodeArray) {
            element.appendChild(node);
        }
        return document;
    }

    public static String unescapeEntities(String string, boolean bl) {
        Tokeniser tokeniser = new Tokeniser(new CharacterReader(string), ParseErrorList.noTracking());
        return tokeniser.unescapeEntities(bl);
    }

    public static Parser htmlParser() {
        return new Parser(new HtmlTreeBuilder());
    }

    public static Parser xmlParser() {
        return new Parser(new XmlTreeBuilder());
    }
}

