/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.Arrays;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;

final class Tokeniser {
    static final char replacementChar = '\ufffd';
    private static final char[] notCharRefCharsSorted = new char[]{'\t', '\n', '\r', '\f', ' ', '<', '&'};
    static final int win1252ExtensionsStart = 128;
    static final int[] win1252Extensions = new int[]{8364, 129, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 141, 381, 143, 144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 157, 382, 376};
    private final CharacterReader reader;
    private final ParseErrorList errors;
    private TokeniserState state = TokeniserState.Data;
    private Token emitPending;
    private boolean isEmitPending = false;
    private String charsString = null;
    private StringBuilder charsBuilder = new StringBuilder(1024);
    StringBuilder dataBuffer = new StringBuilder(1024);
    Token.Tag tagPending;
    Token.StartTag startPending = new Token.StartTag();
    Token.EndTag endPending = new Token.EndTag();
    Token.Character charPending = new Token.Character();
    Token.Doctype doctypePending = new Token.Doctype();
    Token.Comment commentPending = new Token.Comment();
    private String lastStartTag;
    private final int[] codepointHolder = new int[1];
    private final int[] multipointHolder = new int[2];

    Tokeniser(CharacterReader characterReader, ParseErrorList parseErrorList) {
        this.reader = characterReader;
        this.errors = parseErrorList;
    }

    Token read() {
        while (!this.isEmitPending) {
            this.state.read(this, this.reader);
        }
        StringBuilder stringBuilder = this.charsBuilder;
        if (stringBuilder.length() != 0) {
            String string = stringBuilder.toString();
            stringBuilder.delete(0, stringBuilder.length());
            this.charsString = null;
            return this.charPending.data(string);
        }
        if (this.charsString != null) {
            Token.Character character = this.charPending.data(this.charsString);
            this.charsString = null;
            return character;
        }
        this.isEmitPending = false;
        return this.emitPending;
    }

    void emit(Token token) {
        Validate.isFalse(this.isEmitPending);
        this.emitPending = token;
        this.isEmitPending = true;
        if (token.type == Token.TokenType.StartTag) {
            Token.StartTag startTag = (Token.StartTag)token;
            this.lastStartTag = startTag.tagName;
        } else if (token.type == Token.TokenType.EndTag) {
            Token.EndTag endTag = (Token.EndTag)token;
            if (endTag.attributes != null) {
                this.error("Attributes incorrectly present on end tag");
            }
        }
    }

    void emit(String string) {
        if (this.charsString == null) {
            this.charsString = string;
        } else {
            if (this.charsBuilder.length() == 0) {
                this.charsBuilder.append(this.charsString);
            }
            this.charsBuilder.append(string);
        }
    }

    void emit(char[] cArray) {
        this.emit(String.valueOf(cArray));
    }

    void emit(int[] nArray) {
        this.emit(new String(nArray, 0, nArray.length));
    }

    void emit(char c) {
        this.emit(String.valueOf(c));
    }

    TokeniserState getState() {
        return this.state;
    }

    void transition(TokeniserState tokeniserState) {
        this.state = tokeniserState;
    }

    void advanceTransition(TokeniserState tokeniserState) {
        this.reader.advance();
        this.state = tokeniserState;
    }

    int[] consumeCharacterReference(Character c, boolean bl) {
        int n;
        boolean bl2;
        if (this.reader.isEmpty()) {
            return null;
        }
        if (c != null && c.charValue() == this.reader.current()) {
            return null;
        }
        if (this.reader.matchesAnySorted(notCharRefCharsSorted)) {
            return null;
        }
        int[] nArray = this.codepointHolder;
        this.reader.mark();
        if (this.reader.matchConsume("#")) {
            String string;
            boolean bl3 = this.reader.matchConsumeIgnoreCase("X");
            String string2 = string = bl3 ? this.reader.consumeHexSequence() : this.reader.consumeDigitSequence();
            if (string.length() == 0) {
                this.characterReferenceError("numeric reference with no numerals");
                this.reader.rewindToMark();
                return null;
            }
            this.reader.unmark();
            if (!this.reader.matchConsume(";")) {
                this.characterReferenceError("missing semicolon");
            }
            int n2 = -1;
            try {
                int n3 = bl3 ? 16 : 10;
                n2 = Integer.valueOf(string, n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 == -1 || n2 >= 55296 && n2 <= 57343 || n2 > 0x10FFFF) {
                this.characterReferenceError("character outside of valid range");
                nArray[0] = 65533;
                return nArray;
            }
            if (n2 >= 128 && n2 < 128 + win1252Extensions.length) {
                this.characterReferenceError("character is not a valid unicode code point");
                n2 = win1252Extensions[n2 - 128];
            }
            nArray[0] = n2;
            return nArray;
        }
        String string = this.reader.consumeLetterThenDigitSequence();
        boolean bl4 = this.reader.matches(';');
        boolean bl5 = bl2 = Entities.isBaseNamedEntity(string) || Entities.isNamedEntity(string) && bl4;
        if (!bl2) {
            this.reader.rewindToMark();
            if (bl4) {
                this.characterReferenceError("invalid named reference");
            }
            return null;
        }
        if (bl && (this.reader.matchesLetter() || this.reader.matchesDigit() || this.reader.matchesAny('=', '-', '_'))) {
            this.reader.rewindToMark();
            return null;
        }
        this.reader.unmark();
        if (!this.reader.matchConsume(";")) {
            this.characterReferenceError("missing semicolon");
        }
        if ((n = Entities.codepointsForName(string, this.multipointHolder)) == 1) {
            nArray[0] = this.multipointHolder[0];
            return nArray;
        }
        if (n == 2) {
            return this.multipointHolder;
        }
        Validate.fail("Unexpected characters returned for " + string);
        return this.multipointHolder;
    }

    Token.Tag createTagPending(boolean bl) {
        this.tagPending = bl ? this.startPending.reset() : this.endPending.reset();
        return this.tagPending;
    }

    void emitTagPending() {
        this.tagPending.finaliseTag();
        this.emit(this.tagPending);
    }

    void createCommentPending() {
        this.commentPending.reset();
    }

    void emitCommentPending() {
        this.emit(this.commentPending);
    }

    void createBogusCommentPending() {
        this.commentPending.reset();
        this.commentPending.bogus = true;
    }

    void createDoctypePending() {
        this.doctypePending.reset();
    }

    void emitDoctypePending() {
        this.emit(this.doctypePending);
    }

    void createTempBuffer() {
        Token.reset(this.dataBuffer);
    }

    boolean isAppropriateEndTagToken() {
        return this.lastStartTag != null && this.tagPending.name().equalsIgnoreCase(this.lastStartTag);
    }

    String appropriateEndTagName() {
        return this.lastStartTag;
    }

    void error(TokeniserState tokeniserState) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpected character '%s' in input state [%s]", new Object[]{Character.valueOf(this.reader.current()), tokeniserState}));
        }
    }

    void eofError(TokeniserState tokeniserState) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpectedly reached end of file (EOF) in input state [%s]", new Object[]{tokeniserState}));
        }
    }

    private void characterReferenceError(String string) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Invalid character reference: %s", string));
        }
    }

    void error(String string) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), string));
        }
    }

    boolean currentNodeInHtmlNS() {
        return true;
    }

    String unescapeEntities(boolean bl) {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        while (!this.reader.isEmpty()) {
            stringBuilder.append(this.reader.consumeTo('&'));
            if (!this.reader.matches('&')) continue;
            this.reader.consume();
            int[] nArray = this.consumeCharacterReference(null, bl);
            if (nArray == null || nArray.length == 0) {
                stringBuilder.append('&');
                continue;
            }
            stringBuilder.appendCodePoint(nArray[0]);
            if (nArray.length != 2) continue;
            stringBuilder.appendCodePoint(nArray[1]);
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    static {
        Arrays.sort(notCharRefCharsSorted);
    }
}

