/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.Token;
import org.jsoup.parser.Tokeniser;

enum TokeniserState {
    Data{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '&': {
                    tokeniser.advanceTransition(CharacterReferenceInData);
                    break;
                }
                case '<': {
                    tokeniser.advanceTransition(TagOpen);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit(characterReader.consume());
                    break;
                }
                case '\uffff': {
                    tokeniser.emit(new Token.EOF());
                    break;
                }
                default: {
                    String string = characterReader.consumeData();
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    CharacterReferenceInData{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.readCharRef(tokeniser, 2.Data);
        }
    }
    ,
    Rcdata{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '&': {
                    tokeniser.advanceTransition(CharacterReferenceInRcdata);
                    break;
                }
                case '<': {
                    tokeniser.advanceTransition(RcdataLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.emit(new Token.EOF());
                    break;
                }
                default: {
                    String string = characterReader.consumeData();
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    CharacterReferenceInRcdata{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.readCharRef(tokeniser, 4.Rcdata);
        }
    }
    ,
    Rawtext{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.readRawData(tokeniser, characterReader, (TokeniserState)this, 5.RawtextLessthanSign);
        }
    }
    ,
    ScriptData{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.readRawData(tokeniser, characterReader, (TokeniserState)this, 6.ScriptDataLessthanSign);
        }
    }
    ,
    PLAINTEXT{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.emit(new Token.EOF());
                    break;
                }
                default: {
                    String string = characterReader.consumeTo('\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    TagOpen{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '!': {
                    tokeniser.advanceTransition(MarkupDeclarationOpen);
                    break;
                }
                case '/': {
                    tokeniser.advanceTransition(EndTagOpen);
                    break;
                }
                case '?': {
                    tokeniser.createBogusCommentPending();
                    tokeniser.advanceTransition(BogusComment);
                    break;
                }
                default: {
                    if (characterReader.matchesLetter()) {
                        tokeniser.createTagPending(true);
                        tokeniser.transition(TagName);
                        break;
                    }
                    tokeniser.error(this);
                    tokeniser.emit('<');
                    tokeniser.transition(Data);
                }
            }
        }
    }
    ,
    EndTagOpen{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.emit("</");
                tokeniser.transition(Data);
            } else if (characterReader.matchesLetter()) {
                tokeniser.createTagPending(false);
                tokeniser.transition(TagName);
            } else if (characterReader.matches('>')) {
                tokeniser.error(this);
                tokeniser.advanceTransition(Data);
            } else {
                tokeniser.error(this);
                tokeniser.createBogusCommentPending();
                tokeniser.advanceTransition(BogusComment);
            }
        }
    }
    ,
    TagName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeTagName();
            tokeniser.tagPending.appendTagName(string);
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '<': {
                    characterReader.unconsume();
                    tokeniser.error(this);
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.tagPending.appendTagName(replacementStr);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.tagPending.appendTagName(c);
                }
            }
        }
    }
    ,
    RcdataLessthanSign{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('/')) {
                tokeniser.createTempBuffer();
                tokeniser.advanceTransition(RCDATAEndTagOpen);
            } else if (characterReader.matchesLetter() && tokeniser.appropriateEndTagName() != null && !characterReader.containsIgnoreCase("</" + tokeniser.appropriateEndTagName())) {
                tokeniser.tagPending = tokeniser.createTagPending(false).name(tokeniser.appropriateEndTagName());
                tokeniser.emitTagPending();
                characterReader.unconsume();
                tokeniser.transition(Data);
            } else {
                tokeniser.emit("<");
                tokeniser.transition(Rcdata);
            }
        }
    }
    ,
    RCDATAEndTagOpen{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createTagPending(false);
                tokeniser.tagPending.appendTagName(characterReader.current());
                tokeniser.dataBuffer.append(characterReader.current());
                tokeniser.advanceTransition(RCDATAEndTagName);
            } else {
                tokeniser.emit("</");
                tokeniser.transition(Rcdata);
            }
        }
    }
    ,
    RCDATAEndTagName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                String string = characterReader.consumeLetterSequence();
                tokeniser.tagPending.appendTagName(string);
                tokeniser.dataBuffer.append(string);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (tokeniser.isAppropriateEndTagToken()) {
                        tokeniser.transition(BeforeAttributeName);
                        break;
                    }
                    this.anythingElse(tokeniser, characterReader);
                    break;
                }
                case '/': {
                    if (tokeniser.isAppropriateEndTagToken()) {
                        tokeniser.transition(SelfClosingStartTag);
                        break;
                    }
                    this.anythingElse(tokeniser, characterReader);
                    break;
                }
                case '>': {
                    if (tokeniser.isAppropriateEndTagToken()) {
                        tokeniser.emitTagPending();
                        tokeniser.transition(Data);
                        break;
                    }
                    this.anythingElse(tokeniser, characterReader);
                    break;
                }
                default: {
                    this.anythingElse(tokeniser, characterReader);
                }
            }
        }

        private void anythingElse(Tokeniser tokeniser, CharacterReader characterReader) {
            tokeniser.emit("</" + tokeniser.dataBuffer.toString());
            characterReader.unconsume();
            tokeniser.transition(Rcdata);
        }
    }
    ,
    RawtextLessthanSign{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('/')) {
                tokeniser.createTempBuffer();
                tokeniser.advanceTransition(RawtextEndTagOpen);
            } else {
                tokeniser.emit('<');
                tokeniser.transition(Rawtext);
            }
        }
    }
    ,
    RawtextEndTagOpen{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.readEndTag(tokeniser, characterReader, 15.RawtextEndTagName, 15.Rawtext);
        }
    }
    ,
    RawtextEndTagName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.handleDataEndTag(tokeniser, characterReader, 16.Rawtext);
        }
    }
    ,
    ScriptDataLessthanSign{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.consume()) {
                case '/': {
                    tokeniser.createTempBuffer();
                    tokeniser.transition(ScriptDataEndTagOpen);
                    break;
                }
                case '!': {
                    tokeniser.emit("<!");
                    tokeniser.transition(ScriptDataEscapeStart);
                    break;
                }
                case '\uffff': {
                    tokeniser.emit("<");
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.emit("<");
                    characterReader.unconsume();
                    tokeniser.transition(ScriptData);
                }
            }
        }
    }
    ,
    ScriptDataEndTagOpen{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.readEndTag(tokeniser, characterReader, 18.ScriptDataEndTagName, 18.ScriptData);
        }
    }
    ,
    ScriptDataEndTagName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.handleDataEndTag(tokeniser, characterReader, 19.ScriptData);
        }
    }
    ,
    ScriptDataEscapeStart{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('-')) {
                tokeniser.emit('-');
                tokeniser.advanceTransition(ScriptDataEscapeStartDash);
            } else {
                tokeniser.transition(ScriptData);
            }
        }
    }
    ,
    ScriptDataEscapeStartDash{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('-')) {
                tokeniser.emit('-');
                tokeniser.advanceTransition(ScriptDataEscapedDashDash);
            } else {
                tokeniser.transition(ScriptData);
            }
        }
    }
    ,
    ScriptDataEscaped{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.transition(Data);
                return;
            }
            switch (characterReader.current()) {
                case '-': {
                    tokeniser.emit('-');
                    tokeniser.advanceTransition(ScriptDataEscapedDash);
                    break;
                }
                case '<': {
                    tokeniser.advanceTransition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                default: {
                    String string = characterReader.consumeToAny('-', '<', '\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    ScriptDataEscapedDash{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.transition(Data);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataEscapedDashDash);
                    break;
                }
                case '<': {
                    tokeniser.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit('\ufffd');
                    tokeniser.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataEscaped);
                }
            }
        }
    }
    ,
    ScriptDataEscapedDashDash{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.transition(Data);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    break;
                }
                case '<': {
                    tokeniser.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '>': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit('\ufffd');
                    tokeniser.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataEscaped);
                }
            }
        }
    }
    ,
    ScriptDataEscapedLessthanSign{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createTempBuffer();
                tokeniser.dataBuffer.append(characterReader.current());
                tokeniser.emit("<" + characterReader.current());
                tokeniser.advanceTransition(ScriptDataDoubleEscapeStart);
            } else if (characterReader.matches('/')) {
                tokeniser.createTempBuffer();
                tokeniser.advanceTransition(ScriptDataEscapedEndTagOpen);
            } else {
                tokeniser.emit('<');
                tokeniser.transition(ScriptDataEscaped);
            }
        }
    }
    ,
    ScriptDataEscapedEndTagOpen{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createTagPending(false);
                tokeniser.tagPending.appendTagName(characterReader.current());
                tokeniser.dataBuffer.append(characterReader.current());
                tokeniser.advanceTransition(ScriptDataEscapedEndTagName);
            } else {
                tokeniser.emit("</");
                tokeniser.transition(ScriptDataEscaped);
            }
        }
    }
    ,
    ScriptDataEscapedEndTagName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.handleDataEndTag(tokeniser, characterReader, 27.ScriptDataEscaped);
        }
    }
    ,
    ScriptDataDoubleEscapeStart{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.handleDataDoubleEscapeTag(tokeniser, characterReader, 28.ScriptDataDoubleEscaped, 28.ScriptDataEscaped);
        }
    }
    ,
    ScriptDataDoubleEscaped{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.current();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    tokeniser.advanceTransition(ScriptDataDoubleEscapedDash);
                    break;
                }
                case '<': {
                    tokeniser.emit(c);
                    tokeniser.advanceTransition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    String string = characterReader.consumeToAny('-', '<', '\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscapedDash{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscapedDashDash);
                    break;
                }
                case '<': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit('\ufffd');
                    tokeniser.transition(ScriptDataDoubleEscaped);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscapedDashDash{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    break;
                }
                case '<': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '>': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit('\ufffd');
                    tokeniser.transition(ScriptDataDoubleEscaped);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscapedLessthanSign{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('/')) {
                tokeniser.emit('/');
                tokeniser.createTempBuffer();
                tokeniser.advanceTransition(ScriptDataDoubleEscapeEnd);
            } else {
                tokeniser.transition(ScriptDataDoubleEscaped);
            }
        }
    }
    ,
    ScriptDataDoubleEscapeEnd{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            TokeniserState.handleDataDoubleEscapeTag(tokeniser, characterReader, 33.ScriptDataEscaped, 33.ScriptDataDoubleEscaped);
        }
    }
    ,
    BeforeAttributeName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '<': {
                    characterReader.unconsume();
                    tokeniser.error(this);
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    characterReader.unconsume();
                    tokeniser.error(this);
                    tokeniser.tagPending.newAttribute();
                    tokeniser.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '=': {
                    tokeniser.error(this);
                    tokeniser.tagPending.newAttribute();
                    tokeniser.tagPending.appendAttributeName(c);
                    tokeniser.transition(AttributeName);
                    break;
                }
                default: {
                    tokeniser.tagPending.newAttribute();
                    characterReader.unconsume();
                    tokeniser.transition(AttributeName);
                }
            }
        }
    }
    ,
    AttributeName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeToAnySorted(attributeNameCharsSorted);
            tokeniser.tagPending.appendAttributeName(string);
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(AfterAttributeName);
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    tokeniser.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeName('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeName(c);
                    break;
                }
                default: {
                    tokeniser.tagPending.appendAttributeName(c);
                }
            }
        }
    }
    ,
    AfterAttributeName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    tokeniser.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeName('\ufffd');
                    tokeniser.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    tokeniser.error(this);
                    tokeniser.tagPending.newAttribute();
                    tokeniser.tagPending.appendAttributeName(c);
                    tokeniser.transition(AttributeName);
                    break;
                }
                default: {
                    tokeniser.tagPending.newAttribute();
                    characterReader.unconsume();
                    tokeniser.transition(AttributeName);
                }
            }
        }
    }
    ,
    BeforeAttributeValue{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    tokeniser.transition(AttributeValue_doubleQuoted);
                    break;
                }
                case '&': {
                    characterReader.unconsume();
                    tokeniser.transition(AttributeValue_unquoted);
                    break;
                }
                case '\'': {
                    tokeniser.transition(AttributeValue_singleQuoted);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue('\ufffd');
                    tokeniser.transition(AttributeValue_unquoted);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '<': 
                case '=': 
                case '`': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue(c);
                    tokeniser.transition(AttributeValue_unquoted);
                    break;
                }
                default: {
                    characterReader.unconsume();
                    tokeniser.transition(AttributeValue_unquoted);
                }
            }
        }
    }
    ,
    AttributeValue_doubleQuoted{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeToAnySorted(attributeDoubleValueCharsSorted);
            if (string.length() > 0) {
                tokeniser.tagPending.appendAttributeValue(string);
            } else {
                tokeniser.tagPending.setEmptyAttributeValue();
            }
            char c = characterReader.consume();
            switch (c) {
                case '\"': {
                    tokeniser.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '&': {
                    int[] nArray = tokeniser.consumeCharacterReference(Character.valueOf('\"'), true);
                    if (nArray != null) {
                        tokeniser.tagPending.appendAttributeValue(nArray);
                        break;
                    }
                    tokeniser.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.tagPending.appendAttributeValue(c);
                }
            }
        }
    }
    ,
    AttributeValue_singleQuoted{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeToAnySorted(attributeSingleValueCharsSorted);
            if (string.length() > 0) {
                tokeniser.tagPending.appendAttributeValue(string);
            } else {
                tokeniser.tagPending.setEmptyAttributeValue();
            }
            char c = characterReader.consume();
            switch (c) {
                case '\'': {
                    tokeniser.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '&': {
                    int[] nArray = tokeniser.consumeCharacterReference(Character.valueOf('\''), true);
                    if (nArray != null) {
                        tokeniser.tagPending.appendAttributeValue(nArray);
                        break;
                    }
                    tokeniser.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.tagPending.appendAttributeValue(c);
                }
            }
        }
    }
    ,
    AttributeValue_unquoted{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeToAnySorted(attributeValueUnquoted);
            if (string.length() > 0) {
                tokeniser.tagPending.appendAttributeValue(string);
            }
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeAttributeName);
                    break;
                }
                case '&': {
                    int[] nArray = tokeniser.consumeCharacterReference(Character.valueOf('>'), true);
                    if (nArray != null) {
                        tokeniser.tagPending.appendAttributeValue(nArray);
                        break;
                    }
                    tokeniser.tagPending.appendAttributeValue('&');
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': 
                case '=': 
                case '`': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue(c);
                    break;
                }
                default: {
                    tokeniser.tagPending.appendAttributeValue(c);
                }
            }
        }
    }
    ,
    AfterAttributeValue_quoted{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    characterReader.unconsume();
                    tokeniser.error(this);
                    tokeniser.transition(BeforeAttributeName);
                }
            }
        }
    }
    ,
    SelfClosingStartTag{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '>': {
                    tokeniser.tagPending.selfClosing = true;
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    characterReader.unconsume();
                    tokeniser.error(this);
                    tokeniser.transition(BeforeAttributeName);
                }
            }
        }
    }
    ,
    BogusComment{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            characterReader.unconsume();
            tokeniser.commentPending.append(characterReader.consumeTo('>'));
            char c = characterReader.consume();
            if (c == '>' || c == '\uffff') {
                tokeniser.emitCommentPending();
                tokeniser.transition(Data);
            }
        }
    }
    ,
    MarkupDeclarationOpen{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchConsume("--")) {
                tokeniser.createCommentPending();
                tokeniser.transition(CommentStart);
            } else if (characterReader.matchConsumeIgnoreCase("DOCTYPE")) {
                tokeniser.transition(Doctype);
            } else if (characterReader.matchConsume("[CDATA[")) {
                tokeniser.createTempBuffer();
                tokeniser.transition(CdataSection);
            } else {
                tokeniser.error(this);
                tokeniser.createBogusCommentPending();
                tokeniser.advanceTransition(BogusComment);
            }
        }
    }
    ,
    CommentStart{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.transition(CommentStartDash);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    characterReader.unconsume();
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    CommentStartDash{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.transition(CommentStartDash);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.commentPending.append(c);
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    Comment{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.current();
            switch (c) {
                case '-': {
                    tokeniser.advanceTransition(CommentEndDash);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.commentPending.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.commentPending.append(characterReader.consumeToAny('-', '\u0000'));
                }
            }
        }
    }
    ,
    CommentEndDash{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.transition(CommentEnd);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.append('-').append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.commentPending.append('-').append(c);
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    CommentEnd{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '>': {
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.append("--").append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '!': {
                    tokeniser.error(this);
                    tokeniser.transition(CommentEndBang);
                    break;
                }
                case '-': {
                    tokeniser.error(this);
                    tokeniser.commentPending.append('-');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.commentPending.append("--").append(c);
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    CommentEndBang{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.commentPending.append("--!");
                    tokeniser.transition(CommentEndDash);
                    break;
                }
                case '>': {
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.append("--!").append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.commentPending.append("--!").append(c);
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    Doctype{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeDoctypeName);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.createDoctypePending();
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.transition(BeforeDoctypeName);
                }
            }
        }
    }
    ,
    BeforeDoctypeName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createDoctypePending();
                tokeniser.transition(DoctypeName);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.createDoctypePending();
                    tokeniser.doctypePending.name.append('\ufffd');
                    tokeniser.transition(DoctypeName);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.createDoctypePending();
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.createDoctypePending();
                    tokeniser.doctypePending.name.append(c);
                    tokeniser.transition(DoctypeName);
                }
            }
        }
    }
    ,
    DoctypeName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                String string = characterReader.consumeLetterSequence();
                tokeniser.doctypePending.name.append(string);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(AfterDoctypeName);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.name.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.name.append(c);
                }
            }
        }
    }
    ,
    AfterDoctypeName{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.doctypePending.forceQuirks = true;
                tokeniser.emitDoctypePending();
                tokeniser.transition(Data);
                return;
            }
            if (characterReader.matchesAny('\t', '\n', '\r', '\f', ' ')) {
                characterReader.advance();
            } else if (characterReader.matches('>')) {
                tokeniser.emitDoctypePending();
                tokeniser.advanceTransition(Data);
            } else if (characterReader.matchConsumeIgnoreCase("PUBLIC")) {
                tokeniser.doctypePending.pubSysKey = "PUBLIC";
                tokeniser.transition(AfterDoctypePublicKeyword);
            } else if (characterReader.matchConsumeIgnoreCase("SYSTEM")) {
                tokeniser.doctypePending.pubSysKey = "SYSTEM";
                tokeniser.transition(AfterDoctypeSystemKeyword);
            } else {
                tokeniser.error(this);
                tokeniser.doctypePending.forceQuirks = true;
                tokeniser.advanceTransition(BogusDoctype);
            }
        }
    }
    ,
    AfterDoctypePublicKeyword{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeDoctypePublicIdentifier);
                    break;
                }
                case '\"': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    BeforeDoctypePublicIdentifier{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    tokeniser.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    DoctypePublicIdentifier_doubleQuoted{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\"': {
                    tokeniser.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    }
    ,
    DoctypePublicIdentifier_singleQuoted{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\'': {
                    tokeniser.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    }
    ,
    AfterDoctypePublicIdentifier{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BetweenDoctypePublicAndSystemIdentifiers);
                    break;
                }
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    BetweenDoctypePublicAndSystemIdentifiers{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    AfterDoctypeSystemKeyword{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeDoctypeSystemIdentifier);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                }
            }
        }
    }
    ,
    BeforeDoctypeSystemIdentifier{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    tokeniser.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    DoctypeSystemIdentifier_doubleQuoted{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\"': {
                    tokeniser.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    }
    ,
    DoctypeSystemIdentifier_singleQuoted{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\'': {
                    tokeniser.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    }
    ,
    AfterDoctypeSystemIdentifier{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    BogusDoctype{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
            }
        }
    }
    ,
    CdataSection{

        @Override
        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeTo("]]>");
            tokeniser.dataBuffer.append(string);
            if (characterReader.matchConsume("]]>") || characterReader.isEmpty()) {
                tokeniser.emit(new Token.CData(tokeniser.dataBuffer.toString()));
                tokeniser.transition(Data);
            }
        }
    };

    static final char nullChar = '\u0000';
    static final char[] attributeSingleValueCharsSorted;
    static final char[] attributeDoubleValueCharsSorted;
    static final char[] attributeNameCharsSorted;
    static final char[] attributeValueUnquoted;
    private static final char replacementChar = '\ufffd';
    private static final String replacementStr;
    private static final char eof = '\uffff';

    abstract void read(Tokeniser var1, CharacterReader var2);

    private static void handleDataEndTag(Tokeniser tokeniser, CharacterReader characterReader, TokeniserState tokeniserState) {
        if (characterReader.matchesLetter()) {
            String string = characterReader.consumeLetterSequence();
            tokeniser.tagPending.appendTagName(string);
            tokeniser.dataBuffer.append(string);
            return;
        }
        boolean bl = false;
        if (tokeniser.isAppropriateEndTagToken() && !characterReader.isEmpty()) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.dataBuffer.append(c);
                    bl = true;
                    break;
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            tokeniser.emit("</" + tokeniser.dataBuffer.toString());
            tokeniser.transition(tokeniserState);
        }
    }

    private static void readRawData(Tokeniser tokeniser, CharacterReader characterReader, TokeniserState tokeniserState, TokeniserState tokeniserState2) {
        switch (characterReader.current()) {
            case '<': {
                tokeniser.advanceTransition(tokeniserState2);
                break;
            }
            case '\u0000': {
                tokeniser.error(tokeniserState);
                characterReader.advance();
                tokeniser.emit('\ufffd');
                break;
            }
            case '\uffff': {
                tokeniser.emit(new Token.EOF());
                break;
            }
            default: {
                String string = characterReader.consumeRawData();
                tokeniser.emit(string);
            }
        }
    }

    private static void readCharRef(Tokeniser tokeniser, TokeniserState tokeniserState) {
        int[] nArray = tokeniser.consumeCharacterReference(null, false);
        if (nArray == null) {
            tokeniser.emit('&');
        } else {
            tokeniser.emit(nArray);
        }
        tokeniser.transition(tokeniserState);
    }

    private static void readEndTag(Tokeniser tokeniser, CharacterReader characterReader, TokeniserState tokeniserState, TokeniserState tokeniserState2) {
        if (characterReader.matchesLetter()) {
            tokeniser.createTagPending(false);
            tokeniser.transition(tokeniserState);
        } else {
            tokeniser.emit("</");
            tokeniser.transition(tokeniserState2);
        }
    }

    private static void handleDataDoubleEscapeTag(Tokeniser tokeniser, CharacterReader characterReader, TokeniserState tokeniserState, TokeniserState tokeniserState2) {
        if (characterReader.matchesLetter()) {
            String string = characterReader.consumeLetterSequence();
            tokeniser.dataBuffer.append(string);
            tokeniser.emit(string);
            return;
        }
        char c = characterReader.consume();
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '/': 
            case '>': {
                if (tokeniser.dataBuffer.toString().equals("script")) {
                    tokeniser.transition(tokeniserState);
                } else {
                    tokeniser.transition(tokeniserState2);
                }
                tokeniser.emit(c);
                break;
            }
            default: {
                characterReader.unconsume();
                tokeniser.transition(tokeniserState2);
            }
        }
    }

    static {
        attributeSingleValueCharsSorted = new char[]{'\u0000', '&', '\''};
        attributeDoubleValueCharsSorted = new char[]{'\u0000', '\"', '&'};
        attributeNameCharsSorted = new char[]{'\u0000', '\t', '\n', '\f', '\r', ' ', '\"', '\'', '/', '<', '=', '>'};
        attributeValueUnquoted = new char[]{'\u0000', '\t', '\n', '\f', '\r', ' ', '\"', '&', '\'', '<', '=', '>', '`'};
        replacementStr = String.valueOf('\ufffd');
    }
}

