/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Token;
import org.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    protected Parser parser;
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected ArrayList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseSettings settings;
    private Token.StartTag start = new Token.StartTag();
    private Token.EndTag end = new Token.EndTag();

    TreeBuilder() {
    }

    abstract ParseSettings defaultSettings();

    protected void initialiseParse(Reader reader, String string, Parser parser) {
        Validate.notNull(reader, "String input must not be null");
        Validate.notNull(string, "BaseURI must not be null");
        this.doc = new Document(string);
        this.doc.parser(parser);
        this.parser = parser;
        this.settings = parser.settings();
        this.reader = new CharacterReader(reader);
        this.currentToken = null;
        this.tokeniser = new Tokeniser(this.reader, parser.getErrors());
        this.stack = new ArrayList(32);
        this.baseUri = string;
    }

    Document parse(Reader reader, String string, Parser parser) {
        this.initialiseParse(reader, string, parser);
        this.runParser();
        this.reader.close();
        this.reader = null;
        this.tokeniser = null;
        this.stack = null;
        return this.doc;
    }

    abstract List<Node> parseFragment(String var1, Element var2, String var3, Parser var4);

    protected void runParser() {
        Token token;
        Tokeniser tokeniser = this.tokeniser;
        Token.TokenType tokenType = Token.TokenType.EOF;
        do {
            token = tokeniser.read();
            this.process(token);
            token.reset();
        } while (token.type != tokenType);
    }

    protected abstract boolean process(Token var1);

    protected boolean processStartTag(String string) {
        Token.StartTag startTag = this.start;
        if (this.currentToken == startTag) {
            return this.process(new Token.StartTag().name(string));
        }
        return this.process(startTag.reset().name(string));
    }

    public boolean processStartTag(String string, Attributes attributes) {
        Token.StartTag startTag = this.start;
        if (this.currentToken == startTag) {
            return this.process(new Token.StartTag().nameAttr(string, attributes));
        }
        startTag.reset();
        startTag.nameAttr(string, attributes);
        return this.process(startTag);
    }

    protected boolean processEndTag(String string) {
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag().name(string));
        }
        return this.process(this.end.reset().name(string));
    }

    protected Element currentElement() {
        int n = this.stack.size();
        return n > 0 ? this.stack.get(n - 1) : null;
    }

    protected void error(String string) {
        ParseErrorList parseErrorList = this.parser.getErrors();
        if (parseErrorList.canAddError()) {
            parseErrorList.add(new ParseError(this.reader.pos(), string));
        }
    }
}

