/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TreeBuilder;

public class XmlTreeBuilder
extends TreeBuilder {
    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.preserveCase;
    }

    @Override
    protected void initialiseParse(Reader reader, String string, Parser parser) {
        super.initialiseParse(reader, string, parser);
        this.stack.add(this.doc);
        this.doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
    }

    Document parse(Reader reader, String string) {
        return this.parse(reader, string, new Parser(this));
    }

    Document parse(String string, String string2) {
        return this.parse(new StringReader(string), string2, new Parser(this));
    }

    @Override
    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    private void insertNode(Node node) {
        this.currentElement().appendChild(node);
    }

    Element insert(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name(), this.settings);
        if (startTag.attributes != null) {
            startTag.attributes.deduplicate(this.settings);
        }
        Element element = new Element(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        this.insertNode(element);
        if (startTag.isSelfClosing()) {
            if (!tag.isKnownTag()) {
                tag.setSelfClosing();
            }
        } else {
            this.stack.add(element);
        }
        return element;
    }

    void insert(Token.Comment comment) {
        XmlDeclaration xmlDeclaration;
        Comment comment2;
        LeafNode leafNode = comment2 = new Comment(comment.getData());
        if (comment.bogus && comment2.isXmlDeclaration() && (xmlDeclaration = comment2.asXmlDeclaration()) != null) {
            leafNode = xmlDeclaration;
        }
        this.insertNode(leafNode);
    }

    void insert(Token.Character character) {
        String string = character.getData();
        this.insertNode(character.isCData() ? new CDataNode(string) : new TextNode(string));
    }

    void insert(Token.Doctype doctype) {
        DocumentType documentType = new DocumentType(this.settings.normalizeTag(doctype.getName()), doctype.getPublicIdentifier(), doctype.getSystemIdentifier());
        documentType.setPubSysKey(doctype.getPubSysKey());
        this.insertNode(documentType);
    }

    private void popStackToClose(Token.EndTag endTag) {
        Element element;
        int n;
        String string = this.settings.normalizeTag(endTag.tagName);
        Element element2 = null;
        for (n = this.stack.size() - 1; n >= 0; --n) {
            element = (Element)this.stack.get(n);
            if (!element.nodeName().equals(string)) continue;
            element2 = element;
            break;
        }
        if (element2 == null) {
            return;
        }
        for (n = this.stack.size() - 1; n >= 0; --n) {
            element = (Element)this.stack.get(n);
            this.stack.remove(n);
            if (element == element2) break;
        }
    }

    List<Node> parseFragment(String string, String string2, Parser parser) {
        this.initialiseParse(new StringReader(string), string2, parser);
        this.runParser();
        return this.doc.childNodes();
    }

    @Override
    List<Node> parseFragment(String string, Element element, String string2, Parser parser) {
        return this.parseFragment(string, string2, parser);
    }
}

