/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.safety;

import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class Cleaner {
    private Whitelist whitelist;

    public Cleaner(Whitelist whitelist) {
        Validate.notNull(whitelist);
        this.whitelist = whitelist;
    }

    public Document clean(Document document) {
        Validate.notNull(document);
        Document document2 = Document.createShell(document.baseUri());
        if (document.body() != null) {
            this.copySafeNodes(document.body(), document2.body());
        }
        return document2;
    }

    public boolean isValid(Document document) {
        Validate.notNull(document);
        Document document2 = Document.createShell(document.baseUri());
        int n = this.copySafeNodes(document.body(), document2.body());
        return n == 0 && document.head().childNodes().isEmpty();
    }

    public boolean isValidBodyHtml(String string) {
        Document document = Document.createShell("");
        Document document2 = Document.createShell("");
        ParseErrorList parseErrorList = ParseErrorList.tracking(1);
        List<Node> list = Parser.parseFragment(string, document2.body(), "", parseErrorList);
        document2.body().insertChildren(0, list);
        int n = this.copySafeNodes(document2.body(), document.body());
        return n == 0 && parseErrorList.isEmpty();
    }

    private int copySafeNodes(Element element, Element element2) {
        CleaningVisitor cleaningVisitor = new CleaningVisitor(element, element2);
        NodeTraversor.traverse((NodeVisitor)cleaningVisitor, element);
        return cleaningVisitor.numDiscarded;
    }

    private ElementMeta createSafeElement(Element element) {
        String string = element.tagName();
        Attributes attributes = new Attributes();
        Element element2 = new Element(Tag.valueOf(string), element.baseUri(), attributes);
        int n = 0;
        Attributes attributes2 = element.attributes();
        for (Attribute attribute : attributes2) {
            if (this.whitelist.isSafeAttribute(string, element, attribute)) {
                attributes.put(attribute);
                continue;
            }
            ++n;
        }
        Attributes attributes3 = this.whitelist.getEnforcedAttributes(string);
        attributes.addAll(attributes3);
        return new ElementMeta(element2, n);
    }

    private static class ElementMeta {
        Element el;
        int numAttribsDiscarded;

        ElementMeta(Element element, int n) {
            this.el = element;
            this.numAttribsDiscarded = n;
        }
    }

    private final class CleaningVisitor
    implements NodeVisitor {
        private int numDiscarded = 0;
        private final Element root;
        private Element destination;

        private CleaningVisitor(Element element, Element element2) {
            this.root = element;
            this.destination = element2;
        }

        @Override
        public void head(Node node, int n) {
            if (node instanceof Element) {
                Element element = (Element)node;
                if (Cleaner.this.whitelist.isSafeTag(element.normalName())) {
                    ElementMeta elementMeta = Cleaner.this.createSafeElement(element);
                    Element element2 = elementMeta.el;
                    this.destination.appendChild(element2);
                    this.numDiscarded += elementMeta.numAttribsDiscarded;
                    this.destination = element2;
                } else if (node != this.root) {
                    ++this.numDiscarded;
                }
            } else if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                TextNode textNode2 = new TextNode(textNode.getWholeText());
                this.destination.appendChild(textNode2);
            } else if (node instanceof DataNode && Cleaner.this.whitelist.isSafeTag(node.parent().nodeName())) {
                DataNode dataNode = (DataNode)node;
                DataNode dataNode2 = new DataNode(dataNode.getWholeData());
                this.destination.appendChild(dataNode2);
            } else {
                ++this.numDiscarded;
            }
        }

        @Override
        public void tail(Node node, int n) {
            if (node instanceof Element && Cleaner.this.whitelist.isSafeTag(node.nodeName())) {
                this.destination = this.destination.parent();
            }
        }
    }
}

