/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.QueryParser;
import org.jsoup.select.Selector;

public class Elements
extends ArrayList<Element> {
    public Elements() {
    }

    public Elements(int n) {
        super(n);
    }

    public Elements(Collection<Element> collection) {
        super(collection);
    }

    public Elements(List<Element> list) {
        super(list);
    }

    public Elements(Element ... elementArray) {
        super(Arrays.asList(elementArray));
    }

    @Override
    public Elements clone() {
        Elements elements = new Elements(this.size());
        for (Element element : this) {
            elements.add(element.clone());
        }
        return elements;
    }

    public String attr(String string) {
        for (Element element : this) {
            if (!element.hasAttr(string)) continue;
            return element.attr(string);
        }
        return "";
    }

    public boolean hasAttr(String string) {
        for (Element element : this) {
            if (!element.hasAttr(string)) continue;
            return true;
        }
        return false;
    }

    public List<String> eachAttr(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (Element element : this) {
            if (!element.hasAttr(string)) continue;
            arrayList.add(element.attr(string));
        }
        return arrayList;
    }

    public Elements attr(String string, String string2) {
        for (Element element : this) {
            element.attr(string, string2);
        }
        return this;
    }

    public Elements removeAttr(String string) {
        for (Element element : this) {
            element.removeAttr(string);
        }
        return this;
    }

    public Elements addClass(String string) {
        for (Element element : this) {
            element.addClass(string);
        }
        return this;
    }

    public Elements removeClass(String string) {
        for (Element element : this) {
            element.removeClass(string);
        }
        return this;
    }

    public Elements toggleClass(String string) {
        for (Element element : this) {
            element.toggleClass(string);
        }
        return this;
    }

    public boolean hasClass(String string) {
        for (Element element : this) {
            if (!element.hasClass(string)) continue;
            return true;
        }
        return false;
    }

    public String val() {
        if (this.size() > 0) {
            return this.first().val();
        }
        return "";
    }

    public Elements val(String string) {
        for (Element element : this) {
            element.val(string);
        }
        return this;
    }

    public String text() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        for (Element element : this) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(element.text());
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    public boolean hasText() {
        for (Element element : this) {
            if (!element.hasText()) continue;
            return true;
        }
        return false;
    }

    public List<String> eachText() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (Element element : this) {
            if (!element.hasText()) continue;
            arrayList.add(element.text());
        }
        return arrayList;
    }

    public String html() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        for (Element element : this) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(element.html());
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    public String outerHtml() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        for (Element element : this) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(element.outerHtml());
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    public Elements tagName(String string) {
        for (Element element : this) {
            element.tagName(string);
        }
        return this;
    }

    public Elements html(String string) {
        for (Element element : this) {
            element.html(string);
        }
        return this;
    }

    public Elements prepend(String string) {
        for (Element element : this) {
            element.prepend(string);
        }
        return this;
    }

    public Elements append(String string) {
        for (Element element : this) {
            element.append(string);
        }
        return this;
    }

    public Elements before(String string) {
        for (Element element : this) {
            element.before(string);
        }
        return this;
    }

    public Elements after(String string) {
        for (Element element : this) {
            element.after(string);
        }
        return this;
    }

    public Elements wrap(String string) {
        Validate.notEmpty(string);
        for (Element element : this) {
            element.wrap(string);
        }
        return this;
    }

    public Elements unwrap() {
        for (Element element : this) {
            element.unwrap();
        }
        return this;
    }

    public Elements empty() {
        for (Element element : this) {
            element.empty();
        }
        return this;
    }

    public Elements remove() {
        for (Element element : this) {
            element.remove();
        }
        return this;
    }

    public Elements select(String string) {
        return Selector.select(string, this);
    }

    public Elements not(String string) {
        Elements elements = Selector.select(string, this);
        return Selector.filterOut(this, elements);
    }

    public Elements eq(int n) {
        return this.size() > n ? new Elements((Element)this.get(n)) : new Elements();
    }

    public boolean is(String string) {
        Evaluator evaluator = QueryParser.parse(string);
        for (Element element : this) {
            if (!element.is(evaluator)) continue;
            return true;
        }
        return false;
    }

    public Elements next() {
        return this.siblings(null, true, false);
    }

    public Elements next(String string) {
        return this.siblings(string, true, false);
    }

    public Elements nextAll() {
        return this.siblings(null, true, true);
    }

    public Elements nextAll(String string) {
        return this.siblings(string, true, true);
    }

    public Elements prev() {
        return this.siblings(null, false, false);
    }

    public Elements prev(String string) {
        return this.siblings(string, false, false);
    }

    public Elements prevAll() {
        return this.siblings(null, false, true);
    }

    public Elements prevAll(String string) {
        return this.siblings(string, false, true);
    }

    private Elements siblings(String string, boolean bl, boolean bl2) {
        Elements elements = new Elements();
        Evaluator evaluator = string != null ? QueryParser.parse(string) : null;
        block0: for (Element element : this) {
            Element element2;
            while ((element2 = bl ? element.nextElementSibling() : element.previousElementSibling()) != null) {
                if (evaluator == null) {
                    elements.add(element2);
                } else if (element2.is(evaluator)) {
                    elements.add(element2);
                }
                element = element2;
                if (bl2) continue;
                continue block0;
            }
        }
        return elements;
    }

    public Elements parents() {
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        for (Element element : this) {
            linkedHashSet.addAll(element.parents());
        }
        return new Elements((Collection<Element>)linkedHashSet);
    }

    public Element first() {
        return this.isEmpty() ? null : (Element)this.get(0);
    }

    public Element last() {
        return this.isEmpty() ? null : (Element)this.get(this.size() - 1);
    }

    public Elements traverse(NodeVisitor nodeVisitor) {
        NodeTraversor.traverse(nodeVisitor, this);
        return this;
    }

    public Elements filter(NodeFilter nodeFilter) {
        NodeTraversor.filter(nodeFilter, this);
        return this;
    }

    public List<FormElement> forms() {
        return this.nodesOfType(FormElement.class);
    }

    public List<Comment> comments() {
        return this.nodesOfType(Comment.class);
    }

    public List<TextNode> textNodes() {
        return this.nodesOfType(TextNode.class);
    }

    public List<DataNode> dataNodes() {
        return this.nodesOfType(DataNode.class);
    }

    private <T extends Node> List<T> nodesOfType(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Element element : this) {
            if (element.getClass().isInstance(clazz)) {
                arrayList.add(clazz.cast(element));
                continue;
            }
            if (!Node.class.isAssignableFrom(clazz)) continue;
            for (int i = 0; i < element.childNodeSize(); ++i) {
                Node node = element.childNode(i);
                if (!clazz.isInstance(node)) continue;
                arrayList.add(clazz.cast(node));
            }
        }
        return arrayList;
    }
}

