/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.Iterator;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeVisitor;

public class NodeTraversor {
    public static void traverse(NodeVisitor nodeVisitor, Node node) {
        Node node2 = node;
        int n = 0;
        while (node2 != null) {
            nodeVisitor.head(node2, n);
            if (node2.childNodeSize() > 0) {
                node2 = node2.childNode(0);
                ++n;
                continue;
            }
            while (node2.nextSibling() == null && n > 0) {
                nodeVisitor.tail(node2, n);
                node2 = node2.parentNode();
                --n;
            }
            nodeVisitor.tail(node2, n);
            if (node2 == node) break;
            node2 = node2.nextSibling();
        }
    }

    public static void traverse(NodeVisitor nodeVisitor, Elements elements) {
        Validate.notNull(nodeVisitor);
        Validate.notNull(elements);
        for (Element element : elements) {
            NodeTraversor.traverse(nodeVisitor, element);
        }
    }

    public static NodeFilter.FilterResult filter(NodeFilter nodeFilter, Node node) {
        Node node2 = node;
        int n = 0;
        while (node2 != null) {
            Node node3;
            NodeFilter.FilterResult filterResult = nodeFilter.head(node2, n);
            if (filterResult == NodeFilter.FilterResult.STOP) {
                return filterResult;
            }
            if (filterResult == NodeFilter.FilterResult.CONTINUE && node2.childNodeSize() > 0) {
                node2 = node2.childNode(0);
                ++n;
                continue;
            }
            while (node2.nextSibling() == null && n > 0) {
                if ((filterResult == NodeFilter.FilterResult.CONTINUE || filterResult == NodeFilter.FilterResult.SKIP_CHILDREN) && (filterResult = nodeFilter.tail(node2, n)) == NodeFilter.FilterResult.STOP) {
                    return filterResult;
                }
                node3 = node2;
                node2 = node2.parentNode();
                --n;
                if (filterResult == NodeFilter.FilterResult.REMOVE) {
                    node3.remove();
                }
                filterResult = NodeFilter.FilterResult.CONTINUE;
            }
            if ((filterResult == NodeFilter.FilterResult.CONTINUE || filterResult == NodeFilter.FilterResult.SKIP_CHILDREN) && (filterResult = nodeFilter.tail(node2, n)) == NodeFilter.FilterResult.STOP) {
                return filterResult;
            }
            if (node2 == node) {
                return filterResult;
            }
            node3 = node2;
            node2 = node2.nextSibling();
            if (filterResult != NodeFilter.FilterResult.REMOVE) continue;
            node3.remove();
        }
        return NodeFilter.FilterResult.CONTINUE;
    }

    public static void filter(NodeFilter nodeFilter, Elements elements) {
        Element element;
        Validate.notNull(nodeFilter);
        Validate.notNull(elements);
        Iterator iterator = elements.iterator();
        while (iterator.hasNext() && NodeTraversor.filter(nodeFilter, element = (Element)iterator.next()) != NodeFilter.FilterResult.STOP) {
        }
    }
}

