/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.QueryParser;

public class Selector {
    private Selector() {
    }

    public static Elements select(String string, Element element) {
        Validate.notEmpty(string);
        return Selector.select(QueryParser.parse(string), element);
    }

    public static Elements select(Evaluator evaluator, Element element) {
        Validate.notNull(evaluator);
        Validate.notNull(element);
        return Collector.collect(evaluator, element);
    }

    public static Elements select(String string, Iterable<Element> iterable) {
        Validate.notEmpty(string);
        Validate.notNull(iterable);
        Evaluator evaluator = QueryParser.parse(string);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        IdentityHashMap<Element, Boolean> identityHashMap = new IdentityHashMap<Element, Boolean>();
        for (Element element : iterable) {
            Elements elements = Selector.select(evaluator, element);
            for (Element element2 : elements) {
                if (identityHashMap.containsKey(element2)) continue;
                arrayList.add(element2);
                identityHashMap.put(element2, Boolean.TRUE);
            }
        }
        return new Elements((List<Element>)arrayList);
    }

    static Elements filterOut(Collection<Element> collection, Collection<Element> collection2) {
        Elements elements = new Elements();
        for (Element element : collection) {
            boolean bl = false;
            for (Element element2 : collection2) {
                if (!element.equals(element2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            elements.add(element);
        }
        return elements;
    }

    public static Element selectFirst(String string, Element element) {
        Validate.notEmpty(string);
        return Collector.findFirst(QueryParser.parse(string), element);
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String string, Object ... objectArray) {
            super(String.format(string, objectArray));
        }
    }
}

