/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.proto.tracker.internal;

import com.github.tobato.fastdfs.domain.fdfs.StorageState;
import com.github.tobato.fastdfs.domain.proto.FdfsResponse;
import com.github.tobato.fastdfs.domain.proto.mapper.FdfsParamMapper;
import com.github.tobato.fastdfs.domain.proto.mapper.ObjectMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class TrackerListStoragesResponse
extends FdfsResponse<List<StorageState>> {
    @Override
    public List<StorageState> decodeContent(InputStream in, Charset charset) throws IOException {
        byte[] bytes = new byte[(int)this.getContentLength()];
        int contentSize = in.read(bytes);
        if ((long)contentSize != this.getContentLength()) {
            throw new IOException("\u8bfb\u53d6\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e0e\u534f\u8bae\u957f\u5ea6\u4e0d\u7b26");
        }
        return this.decode(bytes, charset);
    }

    private List<StorageState> decode(byte[] bs, Charset charset) throws IOException {
        ObjectMetaData objectMetaData = FdfsParamMapper.getObjectMap(StorageState.class);
        int fixFieldsTotalSize = objectMetaData.getFieldsFixTotalSize();
        if (bs.length % fixFieldsTotalSize != 0) {
            throw new IOException("fixFieldsTotalSize=" + fixFieldsTotalSize + "but byte array length: " + bs.length + " is invalid!");
        }
        int count = bs.length / fixFieldsTotalSize;
        int offset = 0;
        ArrayList<StorageState> results = new ArrayList<StorageState>(count);
        for (int i = 0; i < count; ++i) {
            byte[] one = new byte[fixFieldsTotalSize];
            System.arraycopy(bs, offset, one, 0, fixFieldsTotalSize);
            results.add(FdfsParamMapper.map(one, StorageState.class, charset));
            offset += fixFieldsTotalSize;
        }
        return results;
    }
}

