/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.boot.interceptor;

import cn.hutool.core.util.StrUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import top.tangyh.basic.boot.utils.WebUtils;
import top.tangyh.basic.context.ContextUtil;

public class HeaderThreadLocalInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HeaderThreadLocalInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (!ContextUtil.getBoot().booleanValue()) {
            ContextUtil.setUserId((String)WebUtils.getHeader(request, "userid"));
            ContextUtil.setAccount((String)WebUtils.getHeader(request, "account"));
            ContextUtil.setName((String)WebUtils.getHeader(request, "name"));
            ContextUtil.setTenant((String)WebUtils.getHeader(request, "tenant"));
            ContextUtil.setSubTenant((String)WebUtils.getHeader(request, "sub_tenant"));
            String traceId = request.getHeader("x-trace-header");
            MDC.put((String)"trace", (String)(StrUtil.isEmpty((CharSequence)traceId) ? "" : traceId));
            MDC.put((String)"tenant", (String)WebUtils.getHeader(request, "tenant"));
            MDC.put((String)"sub_tenant", (String)WebUtils.getHeader(request, "sub_tenant"));
            MDC.put((String)"userid", (String)WebUtils.getHeader(request, "userid"));
        }
        ContextUtil.setGrayVersion((String)WebUtils.getHeader(request, "gray_version"));
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ContextUtil.remove();
    }
}

