/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.transaction.annotation.Transactional;
import top.tangyh.basic.base.entity.SuperEntity;
import top.tangyh.basic.base.mapper.SuperMapper;
import top.tangyh.basic.base.service.SuperCacheService;
import top.tangyh.basic.base.service.SuperServiceImpl;
import top.tangyh.basic.cache.model.CacheKey;
import top.tangyh.basic.cache.model.CacheKeyBuilder;
import top.tangyh.basic.cache.repository.CacheOps;

public abstract class SuperCacheServiceImpl<M extends SuperMapper<T>, T>
extends SuperServiceImpl<M, T>
implements SuperCacheService<T> {
    @Autowired
    protected CacheOps cacheOps;
    protected static final int MAX_BATCH_KEY_SIZE = 20;

    protected abstract CacheKeyBuilder cacheKeyBuilder();

    @Override
    @Transactional(readOnly=true)
    public T getByIdCache(Serializable id) {
        CacheKey cacheKey = this.cacheKeyBuilder().key(new Object[]{id});
        return (T)this.cacheOps.get(cacheKey, k -> super.getById(id), new boolean[0]);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByIds(@NonNull Collection<? extends Serializable> ids, Function<Collection<? extends Serializable>, Collection<T>> loader) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List keys = ids.stream().map(arg_0 -> SuperCacheServiceImpl.lambda$findByIds$1(this.cacheKeyBuilder(), arg_0)).collect(Collectors.toList());
        List partitionKeys = Lists.partition(keys, (int)20);
        List valueList = partitionKeys.stream().map(ks -> this.cacheOps.find((Collection)ks)).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList keysList = Lists.newArrayList(ids);
        LinkedHashSet missedKeys = Sets.newLinkedHashSet();
        ArrayList<Object> allList = new ArrayList<Object>();
        for (int i = 0; i < valueList.size(); ++i) {
            Object v = valueList.get(i);
            Serializable k = (Serializable)keysList.get(i);
            if (v == null) {
                missedKeys.add(k);
                continue;
            }
            allList.add(v);
        }
        if (CollUtil.isNotEmpty((Collection)missedKeys)) {
            if (loader == null) {
                loader = arg_0 -> ((SuperCacheServiceImpl)this).listByIds(arg_0);
            }
            Collection<Object> missList = loader.apply(missedKeys);
            missList.forEach(this::setCache);
            allList.addAll(missList);
        }
        return allList;
    }

    @Override
    @Transactional(readOnly=true)
    public T getByKey(CacheKey key, Function<CacheKey, Object> loader) {
        Object id = this.cacheOps.get(key, loader, new boolean[0]);
        return id == null ? null : (T)this.getByIdCache(Convert.toLong((Object)id));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeById(Serializable id) {
        boolean bool = super.removeById(id);
        this.delCache(id);
        return bool;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollUtil.isEmpty(idList)) {
            return true;
        }
        boolean flag = super.removeByIds(idList);
        this.delCache((T)idList);
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean save(T model) {
        boolean save = super.save(model);
        this.setCache(model);
        return save;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateAllById(T model) {
        boolean updateBool = super.updateAllById(model);
        this.delCache(model);
        return updateBool;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(T model) {
        boolean updateBool = super.updateById(model);
        this.delCache(model);
        return updateBool;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.INSERT_ONE);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            sqlSession.insert(sqlStatement, entity);
            this.setCache(entity);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        BiPredicate<SqlSession, Object> predicate = (sqlSession, entity) -> {
            Object idVal = ReflectionKit.getFieldValue((Object)entity, (String)keyProperty);
            return StringUtils.checkValNull((Object)idVal) || CollectionUtils.isEmpty((Collection)sqlSession.selectList(this.getSqlStatement(SqlMethod.SELECT_BY_ID), entity));
        };
        BiConsumer<SqlSession, Object> consumer = (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(this.getSqlStatement(SqlMethod.UPDATE_BY_ID), (Object)param);
            this.delCache(entity);
        };
        String sqlStatement = SqlHelper.getSqlStatement((Class)this.mapperClass, (SqlMethod)SqlMethod.INSERT_ONE);
        return SqlHelper.executeBatch(this.getEntityClass(), (Log)this.log, entityList, (int)batchSize, (sqlSession, entity) -> {
            if (predicate.test((SqlSession)sqlSession, entity)) {
                sqlSession.insert(sqlStatement, entity);
                this.setCache(entity);
            } else {
                consumer.accept((SqlSession)sqlSession, entity);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.UPDATE_BY_ID);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
            this.delCache(entity);
        });
    }

    @Override
    public void refreshCache() {
        this.list().forEach(this::setCache);
    }

    @Override
    public void clearCache() {
        this.list().forEach(this::delCache);
    }

    protected void delCache(Serializable ... ids) {
        this.delCache((T)Arrays.asList(ids));
    }

    protected void delCache(Collection<? extends Serializable> idList) {
        CacheKey[] keys = (CacheKey[])idList.stream().map(id -> this.cacheKeyBuilder().key(new Object[]{id})).toArray(CacheKey[]::new);
        this.cacheOps.del(keys);
    }

    protected void delCache(T model) {
        Object id = this.getId(model);
        if (id != null) {
            CacheKey key = this.cacheKeyBuilder().key(new Object[]{id});
            this.cacheOps.del(new CacheKey[]{key});
        }
    }

    protected void setCache(T model) {
        Object id = this.getId(model);
        if (id != null) {
            CacheKey key = this.cacheKeyBuilder().key(new Object[]{id});
            this.cacheOps.set(key, model, new boolean[0]);
        }
    }

    protected Object getId(T model) {
        if (model instanceof SuperEntity) {
            return ((SuperEntity)model).getId();
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        if (tableInfo == null) {
            return null;
        }
        Class keyType = tableInfo.getKeyType();
        if (keyType == null) {
            return null;
        }
        String keyProperty = tableInfo.getKeyProperty();
        Field idField = ReflectUtil.getField(this.getEntityClass(), (String)keyProperty);
        return ReflectUtil.getFieldValue(model, (Field)idField);
    }

    private static /* synthetic */ CacheKey lambda$findByIds$1(CacheKeyBuilder rec$, Object xva$0) {
        return rec$.key(new Object[]{xva$0});
    }
}

