/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.boot.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.undertow.Undertow;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import top.tangyh.basic.boot.config.GlobalMvcConfigurer;
import top.tangyh.basic.boot.undertow.UndertowServerFactoryCustomizer;
import top.tangyh.basic.converter.RemoteDataDeserializer;
import top.tangyh.basic.converter.String2DateConverter;
import top.tangyh.basic.converter.String2LocalDateConverter;
import top.tangyh.basic.converter.String2LocalDateTimeConverter;
import top.tangyh.basic.converter.String2LocalTimeConverter;
import top.tangyh.basic.jackson.LampJacksonModule;
import top.tangyh.basic.model.RemoteData;
import top.tangyh.basic.utils.SpringUtils;

@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
public abstract class BaseConfig {
    @Bean
    @Primary
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnMissingBean
    public ObjectMapper jacksonObjectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        objectMapper.setLocale(Locale.CHINA).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault())).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA)).configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true).configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.registerModule((Module)new LampJacksonModule()).registerModule((Module)new SimpleModule().addDeserializer(RemoteData.class, (JsonDeserializer)RemoteDataDeserializer.INSTANCE)).findAndRegisterModules();
        return objectMapper;
    }

    @Bean
    public Converter<String, Date> dateConvert() {
        return new String2DateConverter();
    }

    @Bean
    public Converter<String, LocalDate> localDateConverter() {
        return new String2LocalDateConverter();
    }

    @Bean
    public Converter<String, LocalTime> localTimeConverter() {
        return new String2LocalTimeConverter();
    }

    @Bean
    public Converter<String, LocalDateTime> localDateTimeConverter() {
        return new String2LocalDateTimeConverter();
    }

    @Bean
    public SpringUtils getSpringUtils(ApplicationContext applicationContext) {
        SpringUtils instance = SpringUtils.getInstance();
        SpringUtils.setApplicationContext((ApplicationContext)applicationContext);
        return instance;
    }

    @ConditionalOnProperty(prefix="lamp.webmvc", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static final class WebMvcConfig {
        @Bean
        @ConditionalOnClass(value={Undertow.class})
        public UndertowServerFactoryCustomizer getUndertowServerFactoryCustomizer() {
            return new UndertowServerFactoryCustomizer();
        }

        @Bean
        @ConditionalOnClass
        public GlobalMvcConfigurer getGlobalMvcConfigurer() {
            return new GlobalMvcConfigurer();
        }
    }
}

