/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.boot.config;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import top.tangyh.basic.boot.config.properties.AsyncProperties;

@Configuration
@EnableAsync(proxyTargetClass=true)
@EnableConfigurationProperties(value={AsyncProperties.class})
@ConditionalOnProperty(prefix="lamp.async", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class DefaultAsyncTaskConfig
extends AsyncConfigurerSupport {
    private final AsyncProperties asyncProperties;

    @Bean
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.asyncProperties.getCorePoolSize());
        executor.setMaxPoolSize(this.asyncProperties.getMaxPoolSize());
        executor.setQueueCapacity(this.asyncProperties.getQueueCapacity());
        executor.setKeepAliveSeconds(this.asyncProperties.getKeepAliveSeconds());
        executor.setThreadNamePrefix(this.asyncProperties.getThreadNamePrefix());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new SimpleAsyncUncaughtExceptionHandler();
    }

    public AsyncProperties getAsyncProperties() {
        return this.asyncProperties;
    }

    public DefaultAsyncTaskConfig(AsyncProperties asyncProperties) {
        this.asyncProperties = asyncProperties;
    }
}

