/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache.lock;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import top.tangyh.basic.lock.DistributedLock;

public class RedisDistributedLock
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    private static final String UNLOCK_LUA = "if redis.call(\"get\",KEYS[1]) == ARGV[1] then     return redis.call(\"del\",KEYS[1]) else     return 0 end ";
    private final RedisTemplate<String, Object> redisTemplate;
    private final ThreadLocal<String> lockFlag = new ThreadLocal();

    public RedisDistributedLock(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean lock(String key, long expire, int retryTimes, long sleepMillis) {
        boolean result = this.setRedis(key, expire);
        while (!result && retryTimes-- > 0) {
            try {
                log.debug("get redisDistributeLock failed, retrying..." + retryTimes);
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            result = this.setRedis(key, expire);
        }
        return result;
    }

    private boolean setRedis(String key, long expire) {
        try {
            return (Boolean)this.redisTemplate.execute(connection -> {
                String uuid = UUID.randomUUID().toString();
                this.lockFlag.set(uuid);
                byte[] keyByte = this.redisTemplate.getStringSerializer().serialize((Object)key);
                byte[] uuidByte = this.redisTemplate.getStringSerializer().serialize((Object)uuid);
                return (boolean)connection.set(keyByte, uuidByte, Expiration.from((long)expire, (TimeUnit)TimeUnit.MILLISECONDS), RedisStringCommands.SetOption.ifAbsent());
            });
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6eredis\u9501\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean releaseLock(String key) {
        try {
            boolean bl = (Boolean)this.redisTemplate.execute(connection -> {
                byte[] scriptByte = this.redisTemplate.getStringSerializer().serialize((Object)UNLOCK_LUA);
                return (Boolean)connection.eval(scriptByte, ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{this.redisTemplate.getStringSerializer().serialize((Object)key), this.redisTemplate.getStringSerializer().serialize((Object)this.lockFlag.get())});
            });
            return bl;
        }
        catch (Exception e) {
            log.error("\u91ca\u653eredis\u9501\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.lockFlag.remove();
        }
        return false;
    }
}

