/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache.properties;

import java.time.Duration;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import top.tangyh.basic.cache.properties.CacheType;
import top.tangyh.basic.cache.properties.SerializerType;

@ConfigurationProperties(prefix="lamp.cache")
public class CustomCacheProperties {
    public static final String PREFIX = "lamp.cache";
    private CacheType type = CacheType.REDIS;
    private SerializerType serializerType = SerializerType.ProtoStuff;
    private Boolean cacheNullVal = true;
    private Cache def = new Cache();
    private Map<String, Cache> configs;

    public CacheType getType() {
        return this.type;
    }

    public SerializerType getSerializerType() {
        return this.serializerType;
    }

    public Boolean getCacheNullVal() {
        return this.cacheNullVal;
    }

    public Cache getDef() {
        return this.def;
    }

    public Map<String, Cache> getConfigs() {
        return this.configs;
    }

    public void setType(CacheType type) {
        this.type = type;
    }

    public void setSerializerType(SerializerType serializerType) {
        this.serializerType = serializerType;
    }

    public void setCacheNullVal(Boolean cacheNullVal) {
        this.cacheNullVal = cacheNullVal;
    }

    public void setDef(Cache def) {
        this.def = def;
    }

    public void setConfigs(Map<String, Cache> configs) {
        this.configs = configs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomCacheProperties)) {
            return false;
        }
        CustomCacheProperties other = (CustomCacheProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$cacheNullVal = this.getCacheNullVal();
        Boolean other$cacheNullVal = other.getCacheNullVal();
        if (this$cacheNullVal == null ? other$cacheNullVal != null : !((Object)this$cacheNullVal).equals(other$cacheNullVal)) {
            return false;
        }
        CacheType this$type = this.getType();
        CacheType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        SerializerType this$serializerType = this.getSerializerType();
        SerializerType other$serializerType = other.getSerializerType();
        if (this$serializerType == null ? other$serializerType != null : !((Object)((Object)this$serializerType)).equals((Object)other$serializerType)) {
            return false;
        }
        Cache this$def = this.getDef();
        Cache other$def = other.getDef();
        if (this$def == null ? other$def != null : !((Object)this$def).equals(other$def)) {
            return false;
        }
        Map<String, Cache> this$configs = this.getConfigs();
        Map<String, Cache> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomCacheProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $cacheNullVal = this.getCacheNullVal();
        result = result * 59 + ($cacheNullVal == null ? 43 : ((Object)$cacheNullVal).hashCode());
        CacheType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        SerializerType $serializerType = this.getSerializerType();
        result = result * 59 + ($serializerType == null ? 43 : ((Object)((Object)$serializerType)).hashCode());
        Cache $def = this.getDef();
        result = result * 59 + ($def == null ? 43 : ((Object)$def).hashCode());
        Map<String, Cache> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public String toString() {
        return "CustomCacheProperties(type=" + this.getType() + ", serializerType=" + this.getSerializerType() + ", cacheNullVal=" + this.getCacheNullVal() + ", def=" + this.getDef() + ", configs=" + this.getConfigs() + ")";
    }

    public static class Cache {
        private Duration timeToLive = Duration.ofDays(1L);
        private boolean cacheNullValues = true;
        private String keyPrefix;
        private boolean useKeyPrefix = true;
        private int maxSize = 1000;

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public boolean isCacheNullValues() {
            return this.cacheNullValues;
        }

        public String getKeyPrefix() {
            return this.keyPrefix;
        }

        public boolean isUseKeyPrefix() {
            return this.useKeyPrefix;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }

        public void setCacheNullValues(boolean cacheNullValues) {
            this.cacheNullValues = cacheNullValues;
        }

        public void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public void setUseKeyPrefix(boolean useKeyPrefix) {
            this.useKeyPrefix = useKeyPrefix;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cache)) {
                return false;
            }
            Cache other = (Cache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCacheNullValues() != other.isCacheNullValues()) {
                return false;
            }
            if (this.isUseKeyPrefix() != other.isUseKeyPrefix()) {
                return false;
            }
            if (this.getMaxSize() != other.getMaxSize()) {
                return false;
            }
            Duration this$timeToLive = this.getTimeToLive();
            Duration other$timeToLive = other.getTimeToLive();
            if (this$timeToLive == null ? other$timeToLive != null : !((Object)this$timeToLive).equals(other$timeToLive)) {
                return false;
            }
            String this$keyPrefix = this.getKeyPrefix();
            String other$keyPrefix = other.getKeyPrefix();
            return !(this$keyPrefix == null ? other$keyPrefix != null : !this$keyPrefix.equals(other$keyPrefix));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCacheNullValues() ? 79 : 97);
            result = result * 59 + (this.isUseKeyPrefix() ? 79 : 97);
            result = result * 59 + this.getMaxSize();
            Duration $timeToLive = this.getTimeToLive();
            result = result * 59 + ($timeToLive == null ? 43 : ((Object)$timeToLive).hashCode());
            String $keyPrefix = this.getKeyPrefix();
            result = result * 59 + ($keyPrefix == null ? 43 : $keyPrefix.hashCode());
            return result;
        }

        public String toString() {
            return "CustomCacheProperties.Cache(timeToLive=" + this.getTimeToLive() + ", cacheNullValues=" + this.isCacheNullValues() + ", keyPrefix=" + this.getKeyPrefix() + ", useKeyPrefix=" + this.isUseKeyPrefix() + ", maxSize=" + this.getMaxSize() + ")";
        }
    }
}

