/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache.repository.impl;

import cn.hutool.core.util.StrUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import top.tangyh.basic.cache.repository.CacheOps;
import top.tangyh.basic.cache.repository.CachePlusOps;
import top.tangyh.basic.model.cache.CacheHashKey;
import top.tangyh.basic.model.cache.CacheKey;

public class CaffeineOpsImpl
implements CacheOps,
CachePlusOps {
    private static final long DEF_MAX_SIZE = 1000L;
    private final Cache<String, Cache<String, Object>> cacheMap = Caffeine.newBuilder().maximumSize(1000L).build();

    @Override
    public Long del(CacheKey ... keys) {
        for (CacheKey key : keys) {
            this.cacheMap.invalidate((Object)key.getKey());
        }
        return keys.length;
    }

    @Override
    public Long del(String ... keys) {
        for (String key : keys) {
            this.cacheMap.invalidate((Object)key);
        }
        return keys.length;
    }

    @Override
    public void set(@NonNull CacheKey key, Object value, boolean ... cacheNullValues) {
        if (value == null) {
            return;
        }
        Caffeine builder = Caffeine.newBuilder().maximumSize(1000L);
        if (key.getExpire() != null) {
            builder.expireAfterWrite(key.getExpire());
        }
        Cache cache = builder.build();
        cache.put((Object)key.getKey(), value);
        this.cacheMap.put((Object)key.getKey(), (Object)cache);
    }

    @Override
    public <T> T get(@NonNull CacheKey key, boolean ... cacheNullValues) {
        Cache ifPresent = (Cache)this.cacheMap.getIfPresent((Object)key.getKey());
        if (ifPresent == null) {
            return null;
        }
        return (T)ifPresent.getIfPresent((Object)key.getKey());
    }

    @Override
    public <T> T get(String key, boolean ... cacheNullValues) {
        Cache ifPresent = (Cache)this.cacheMap.getIfPresent((Object)key);
        if (ifPresent == null) {
            return null;
        }
        return (T)ifPresent.getIfPresent((Object)key);
    }

    @Override
    public <T> List<T> find(@NonNull Collection<CacheKey> keys) {
        return keys.stream().map(k -> this.get((CacheKey)k, false)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public <T> T get(@NonNull CacheKey key, Function<CacheKey, ? extends T> loader, boolean ... cacheNullValues) {
        Cache cache = (Cache)this.cacheMap.get((Object)key.getKey(), k -> {
            Caffeine builder = Caffeine.newBuilder().maximumSize(1000L);
            if (key.getExpire() != null) {
                builder.expireAfterWrite(key.getExpire());
            }
            Cache newCache = builder.build();
            newCache.get(k, tk -> loader.apply(new CacheKey(tk)));
            return newCache;
        });
        return (T)cache.getIfPresent((Object)key.getKey());
    }

    @Override
    public void flushDb() {
        this.cacheMap.invalidateAll();
    }

    @Override
    public Boolean exists(@NonNull CacheKey key) {
        Cache cache = (Cache)this.cacheMap.getIfPresent((Object)key.getKey());
        if (cache == null) {
            return false;
        }
        cache.cleanUp();
        return cache.estimatedSize() > 0L;
    }

    @Override
    public Long incr(@NonNull CacheKey key) {
        Long old = this.get(key, k -> 0L, new boolean[0]);
        Long newVal = old + 1L;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Long getCounter(CacheKey key, Function<CacheKey, Long> loader) {
        return (Long)this.get(key, new boolean[0]);
    }

    @Override
    public Long incrBy(@NonNull CacheKey key, long increment) {
        Long old = this.get(key, k -> 0L, new boolean[0]);
        Long newVal = old + increment;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Double incrByFloat(@NonNull CacheKey key, double increment) {
        Double old = this.get(key, k -> 0.0, new boolean[0]);
        Double newVal = old + increment;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Long decr(@NonNull CacheKey key) {
        Long old = this.get(key, k -> 0L, new boolean[0]);
        Long newVal = old - 1L;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Long decrBy(@NonNull CacheKey key, long decrement) {
        Long old = this.get(key, k -> 0L, new boolean[0]);
        Long newVal = old - decrement;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Set<String> keys(@NonNull String pattern) {
        if (StrUtil.isEmpty((CharSequence)pattern)) {
            return Collections.emptySet();
        }
        ConcurrentMap map = this.cacheMap.asMap();
        HashSet<String> list = new HashSet<String>();
        map.forEach((k, val) -> {
            if ("*".equals(pattern)) {
                list.add((String)k);
                return;
            }
            if (pattern.contains("?")) {
                return;
            }
            if (pattern.contains("*")) {
                return;
            }
            if (pattern.contains("[") && pattern.contains("]")) {
                return;
            }
        });
        return list;
    }

    @Override
    public List<String> scan(String pattern) {
        return new ArrayList<String>(this.keys(pattern));
    }

    @Override
    public void scanUnlink(String pattern) {
        Set<String> keys = this.keys(pattern);
        this.del((String[])keys.stream().toArray(String[]::new));
    }

    @Override
    public Boolean expire(@NonNull CacheKey key) {
        return true;
    }

    @Override
    public Boolean persist(@NonNull CacheKey key) {
        return true;
    }

    @Override
    public String type(@NonNull CacheKey key) {
        return "caffeine";
    }

    @Override
    public Long ttl(@NonNull CacheKey key) {
        return -1L;
    }

    @Override
    public Long pTtl(@NonNull CacheKey key) {
        return -1L;
    }

    @Override
    public void hSet(@NonNull CacheHashKey key, Object value, boolean ... cacheNullValues) {
        this.set(key.tran(), value, cacheNullValues);
    }

    @Override
    public <T> T hGet(@NonNull CacheHashKey key, boolean ... cacheNullValues) {
        return this.get(key.tran(), cacheNullValues);
    }

    @Override
    public <T> T hGet(@NonNull CacheHashKey key, Function<CacheHashKey, T> loader, boolean ... cacheNullValues) {
        Function<CacheKey, Object> ckLoader = k -> loader.apply(key);
        return (T)this.get(key.tran(), ckLoader, cacheNullValues);
    }

    @Override
    public Boolean hExists(@NonNull CacheHashKey cacheHashKey) {
        return this.exists(cacheHashKey.tran());
    }

    @Override
    public Long hDel(@NonNull String key, Object ... fields) {
        for (Object field : fields) {
            this.cacheMap.invalidate((Object)StrUtil.join((CharSequence)":", (Object[])new Object[]{key, field}));
        }
        return fields.length;
    }

    @Override
    public Long hDel(@NonNull CacheHashKey cacheHashKey) {
        this.cacheMap.invalidate((Object)cacheHashKey.tran().getKey());
        return 1L;
    }

    @Override
    public Long hLen(@NonNull CacheHashKey key) {
        return 0L;
    }

    @Override
    public Long hIncrBy(@NonNull CacheHashKey key, long increment) {
        return this.incrBy(key.tran(), increment);
    }

    @Override
    public Double hIncrBy(@NonNull CacheHashKey key, double increment) {
        return this.incrByFloat(key.tran(), increment);
    }

    @Override
    public Set<Object> hKeys(@NonNull CacheHashKey key) {
        return Collections.emptySet();
    }

    @Override
    public List<Object> hVals(@NonNull CacheHashKey key) {
        return Collections.emptyList();
    }

    @Override
    public <K, V> Map<K, V> hGetAll(CacheHashKey key) {
        return Collections.emptyMap();
    }

    @Override
    public <K, V> Map<K, V> hGetAll(CacheHashKey key, Function<CacheHashKey, Map<K, V>> loader, boolean ... cacheNullValues) {
        return loader.apply(key);
    }

    @Override
    public Long sAdd(@NonNull CacheKey key, Object value) {
        return 0L;
    }

    @Override
    public Long sRem(@NonNull CacheKey key, Object ... members) {
        return 0L;
    }

    @Override
    public Set<Object> sMembers(@NonNull CacheKey key) {
        return Collections.emptySet();
    }

    @Override
    public <T> T sPop(@NonNull CacheKey key) {
        return null;
    }

    @Override
    public Long sCard(@NonNull CacheKey key) {
        return 0L;
    }
}

