/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache.repository.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.NonNull;
import top.tangyh.basic.cache.redis2.CacheResult;
import top.tangyh.basic.cache.redis2.RedisOps;
import top.tangyh.basic.cache.repository.CacheOps;
import top.tangyh.basic.cache.repository.CachePlusOps;
import top.tangyh.basic.model.cache.CacheHashKey;
import top.tangyh.basic.model.cache.CacheKey;

public class RedisOpsImpl
implements CacheOps,
CachePlusOps {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisOpsImpl.class);
    private final RedisOps redisOps;

    public RedisOpsImpl(RedisOps redisOps) {
        this.redisOps = redisOps;
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisOps.getRedisTemplate();
    }

    @Override
    public Long del(CacheKey ... keys) {
        return this.redisOps.del(keys);
    }

    @Override
    public Long del(@NonNull Collection<CacheKey> keys) {
        return this.redisOps.del(keys);
    }

    @Override
    public Long del(String ... keys) {
        return this.redisOps.del(keys);
    }

    @Override
    public Boolean exists(@NonNull CacheKey key) {
        return this.redisOps.exists(key.getKey());
    }

    @Override
    public void set(@NonNull CacheKey key, Object value, boolean ... cacheNullValues) {
        this.redisOps.set(key, value, cacheNullValues);
    }

    @Override
    public <T> CacheResult<T> get(@NonNull CacheKey key, boolean ... cacheNullValues) {
        return this.redisOps.get(key, cacheNullValues);
    }

    @Override
    public <T> CacheResult<T> get(@NonNull String key, boolean ... cacheNullValues) {
        return this.redisOps.get(key, cacheNullValues);
    }

    @Override
    public <T> List<CacheResult<T>> find(@NonNull Collection<CacheKey> keys) {
        return this.redisOps.mGetByCacheKey(keys);
    }

    @Override
    public <T> CacheResult<T> get(@NonNull CacheKey key, Function<CacheKey, ? extends T> loader, boolean ... cacheNullValues) {
        return this.redisOps.get(key, loader, cacheNullValues);
    }

    @Override
    public void flushDb() {
        this.redisOps.getRedisTemplate().execute(connection -> {
            connection.flushDb();
            return "ok";
        });
    }

    @Override
    public Long incr(@NonNull CacheKey key) {
        return this.redisOps.incr(key);
    }

    @Override
    public Long getCounter(CacheKey key, Function<CacheKey, Long> loader) {
        return this.redisOps.getCounter(key, loader);
    }

    @Override
    public Long incrBy(@NonNull CacheKey key, long increment) {
        return this.redisOps.incrBy(key, increment);
    }

    @Override
    public Double incrByFloat(@NonNull CacheKey key, double increment) {
        return this.redisOps.incrByFloat(key, increment);
    }

    @Override
    public Long decr(@NonNull CacheKey key) {
        return this.redisOps.decr(key);
    }

    @Override
    public Long decrBy(@NonNull CacheKey key, long decrement) {
        return this.redisOps.decrBy(key, decrement);
    }

    @Override
    public Set<String> keys(@NonNull String pattern) {
        return this.redisOps.keys(pattern);
    }

    @Override
    public List<String> scan(@NonNull String pattern) {
        return this.redisOps.scan(pattern);
    }

    @Override
    public void scanUnlink(@NonNull String pattern) {
        this.redisOps.scanUnlink(pattern);
    }

    @Override
    public Boolean expire(@NonNull CacheKey key) {
        assert (key.getExpire() != null);
        return this.redisOps.expire(key.getKey(), key.getExpire());
    }

    @Override
    public Boolean persist(@NonNull CacheKey key) {
        return this.redisOps.persist(key.getKey());
    }

    @Override
    public String type(@NonNull CacheKey key) {
        return this.redisOps.type(key.getKey());
    }

    @Override
    public Long ttl(@NonNull CacheKey key) {
        return this.redisOps.ttl(key.getKey());
    }

    @Override
    public Long pTtl(@NonNull CacheKey key) {
        return this.redisOps.pTtl(key.getKey());
    }

    @Override
    public void hSet(@NonNull CacheHashKey key, Object value, boolean ... cacheNullValues) {
        this.redisOps.hSet(key, value, cacheNullValues);
    }

    @Override
    public <T> CacheResult<T> hGet(@NonNull CacheHashKey key, boolean ... cacheNullValues) {
        return this.redisOps.hGet(key, cacheNullValues);
    }

    @Override
    public <T> CacheResult<T> hGet(@NonNull CacheHashKey key, Function<CacheHashKey, T> loader, boolean ... cacheNullValues) {
        return this.redisOps.hGet(key, loader, cacheNullValues);
    }

    @Override
    public Boolean hExists(@NonNull CacheHashKey cacheHashKey) {
        return this.redisOps.hExists(cacheHashKey);
    }

    @Override
    public Long hDel(@NonNull String key, Object ... fields) {
        return this.redisOps.hDel(key, fields);
    }

    @Override
    public Long hDel(@NonNull CacheHashKey cacheHashKey) {
        return this.redisOps.hDel(cacheHashKey.getKey(), cacheHashKey.getField());
    }

    @Override
    public Long hLen(@NonNull CacheHashKey key) {
        return this.redisOps.hLen(key.getKey());
    }

    @Override
    public Long hIncrBy(@NonNull CacheHashKey key, long increment) {
        return this.redisOps.hIncrBy(key, increment);
    }

    @Override
    public Double hIncrBy(@NonNull CacheHashKey key, double increment) {
        return this.redisOps.hIncrByFloat(key, increment);
    }

    @Override
    public <HK> Set<HK> hKeys(@NonNull CacheHashKey key) {
        return this.redisOps.hKeys(key.getKey());
    }

    @Override
    public <HV> List<CacheResult<HV>> hVals(@NonNull CacheHashKey key) {
        return this.redisOps.hVals(key.getKey());
    }

    @Override
    public <K, V> Map<K, CacheResult<V>> hGetAll(@NonNull CacheHashKey key) {
        return this.redisOps.hGetAll(key);
    }

    @Override
    public <K, V> Map<K, CacheResult<V>> hGetAll(@NonNull CacheHashKey key, Function<CacheHashKey, Map<K, V>> loader, boolean ... cacheNullValues) {
        return this.redisOps.hGetAll(key, loader, cacheNullValues);
    }

    @Override
    public Long sAdd(@NonNull CacheKey key, Object value) {
        Long result = this.redisOps.sAdd(key, value);
        if (key.getExpire() != null) {
            this.redisOps.expire(key.getKey(), key.getExpire());
        }
        return result;
    }

    @Override
    public Long sRem(@NonNull CacheKey key, Object ... members) {
        return this.redisOps.sRem(key, members);
    }

    @Override
    public Set<Object> sMembers(@NonNull CacheKey key) {
        return this.redisOps.sMembers(key);
    }

    @Override
    public <T> T sPop(@NonNull CacheKey key) {
        return this.redisOps.sPop(key);
    }

    @Override
    public Long sCard(@NonNull CacheKey key) {
        return this.redisOps.sCard(key);
    }
}

