/*
 * Decompiled with CFR 0.152.
 */
package com.wf.captcha.utils;

import java.io.IOException;
import java.io.OutputStream;

public class Encoder {
    static final int BITS = 12;
    static final int HSIZE = 5003;
    private static final int EOF = -1;
    int nBits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int freeEnt = 0;
    boolean clearFlg = false;
    int gInitBits;
    int clearCode;
    int EofCode;
    int curAccum = 0;
    int curBits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];
    private int imgW;
    private int imgH;
    private byte[] pixAry;
    private int initCodeSize;
    private int remaining;
    private int curPixel;

    Encoder(int width, int height, byte[] pixels, int color_depth) {
        this.imgW = width;
        this.imgH = height;
        this.pixAry = pixels;
        this.initCodeSize = Math.max(2, color_depth);
    }

    void charOut(byte c, OutputStream outs) throws IOException {
        this.accum[this.a_count++] = c;
        if (this.a_count >= 254) {
            this.flushChar(outs);
        }
    }

    void clBlock(OutputStream outs) throws IOException {
        this.clHash(this.hsize);
        this.freeEnt = this.clearCode + 2;
        this.clearFlg = true;
        this.output(this.clearCode, outs);
    }

    void clHash(int hsize) {
        for (int i = 0; i < hsize; ++i) {
            this.htab[i] = -1;
        }
    }

    void compress(int init_bits, OutputStream outs) throws IOException {
        int c;
        int fcode;
        this.gInitBits = init_bits;
        this.clearFlg = false;
        this.nBits = this.gInitBits;
        this.maxcode = this.maxCode(this.nBits);
        this.clearCode = 1 << init_bits - 1;
        this.EofCode = this.clearCode + 1;
        this.freeEnt = this.clearCode + 2;
        this.a_count = 0;
        int ent = this.nextPixel();
        int hshift = 0;
        for (fcode = this.hsize; fcode < 65536; fcode *= 2) {
            ++hshift;
        }
        hshift = 8 - hshift;
        int hsizeReg = this.hsize;
        this.clHash(hsizeReg);
        this.output(this.clearCode, outs);
        block1: while ((c = this.nextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsizeReg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsizeReg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent, outs);
            ent = c;
            if (this.freeEnt < this.maxmaxcode) {
                ++this.freeEnt;
                this.htab[i] = fcode;
                continue;
            }
            this.clBlock(outs);
        }
        this.output(ent, outs);
        this.output(this.EofCode, outs);
    }

    void encode(OutputStream os) throws IOException {
        os.write(this.initCodeSize);
        this.remaining = this.imgW * this.imgH;
        this.curPixel = 0;
        this.compress(this.initCodeSize + 1, os);
        os.write(0);
    }

    void flushChar(OutputStream outs) throws IOException {
        if (this.a_count > 0) {
            outs.write(this.a_count);
            outs.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    final int maxCode(int nBits) {
        return (1 << nBits) - 1;
    }

    private int nextPixel() {
        if (this.remaining == 0) {
            return -1;
        }
        --this.remaining;
        byte pix = this.pixAry[this.curPixel++];
        return pix & 0xFF;
    }

    void output(int code, OutputStream outs) throws IOException {
        this.curAccum &= this.masks[this.curBits];
        this.curAccum = this.curBits > 0 ? (this.curAccum |= code << this.curBits) : code;
        this.curBits += this.nBits;
        while (this.curBits >= 8) {
            this.charOut((byte)(this.curAccum & 0xFF), outs);
            this.curAccum >>= 8;
            this.curBits -= 8;
        }
        if (this.freeEnt > this.maxcode || this.clearFlg) {
            if (this.clearFlg) {
                this.nBits = this.gInitBits;
                this.maxcode = this.maxCode(this.nBits);
                this.clearFlg = false;
            } else {
                ++this.nBits;
                this.maxcode = this.nBits == this.maxbits ? this.maxmaxcode : this.maxCode(this.nBits);
            }
        }
        if (code == this.EofCode) {
            while (this.curBits > 0) {
                this.charOut((byte)(this.curAccum & 0xFF), outs);
                this.curAccum >>= 8;
                this.curBits -= 8;
            }
            this.flushChar(outs);
        }
    }
}

