/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import top.tangyh.basic.base.BaseEnum;

public final class CollHelper {
    private CollHelper() {
    }

    public static Map<String, String> getMap(BaseEnum[] list) {
        return CollHelper.uniqueIndex(Arrays.asList(list), BaseEnum::getCode, BaseEnum::getDesc);
    }

    public static <K, V, M> ImmutableMap<K, M> uniqueIndex(Iterable<V> values, Function<? super V, K> keyFunction, Function<? super V, M> valueFunction) {
        Iterator<V> iterator = values.iterator();
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while (iterator.hasNext()) {
            V value = iterator.next();
            builder.put(keyFunction.apply(value), valueFunction.apply(value));
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException duplicateKeys) {
            throw new IllegalArgumentException(duplicateKeys.getMessage() + ".\u82e5\u8981\u5728\u952e\u4e0b\u7d22\u5f15\u591a\u4e2a\u503c\uff0c\u8bf7\u4f7f\u7528: Multimaps.index.", duplicateKeys);
        }
    }

    public static <K, V, M> Multimap<K, M> iterableToMultiMap(Iterable<V> values, Function<? super V, K> keyFunction, Function<? super V, M> valueFunction) {
        Iterator<V> iterator = values.iterator();
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        ArrayListMultimap builder = ArrayListMultimap.create();
        while (iterator.hasNext()) {
            V value = iterator.next();
            builder.put(keyFunction.apply(value), valueFunction.apply(value));
        }
        try {
            return builder;
        }
        catch (IllegalArgumentException duplicateKeys) {
            throw new IllegalArgumentException(duplicateKeys.getMessage() + ".\u82e5\u8981\u5728\u952e\u4e0b\u7d22\u5f15\u591a\u4e2a\u503c\uff0c\u8bf7\u4f7f\u7528: Multimaps.index.", duplicateKeys);
        }
    }

    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        if (MapUtil.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashBiMap biMap = HashBiMap.create();
        map.forEach((arg_0, arg_1) -> ((HashBiMap)biMap).forcePut(arg_0, arg_1));
        return biMap.inverse();
    }

    public static int initialCapacity(int size, float loadFactor) {
        return (int)((float)size / loadFactor + 1.0f);
    }

    public static int initialCapacity(int size) {
        return CollHelper.initialCapacity(size, 0.75f);
    }

    public static <T> List<String> split(Collection<T> list, Function<? super T, ?> function, CharSequence separator) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.parallelStream().map(function).map(item -> StrUtil.splitToArray((CharSequence)String.valueOf(item), (CharSequence)separator)).flatMap(Arrays::stream).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
    }

    public static <T> List<String> split(Collection<String> list, CharSequence separator) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.parallelStream().map(item -> StrUtil.splitToArray((CharSequence)item, (CharSequence)separator)).flatMap(Arrays::stream).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
    }

    public static <E> List<E> asList(E ... elements) {
        if (elements == null || elements.length == 0) {
            return Collections.emptyList();
        }
        int capacity = CollHelper.computeListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    public static <E> Set<E> asSet(E ... elements) {
        if (elements == null || elements.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet set = new LinkedHashSet(elements.length * 4 / 3 + 1);
        Collections.addAll(set, elements);
        return set;
    }

    public static int computeListCapacity(int arraySize) {
        return (int)Math.min(5L + (long)arraySize + (long)(arraySize / 10), Integer.MAX_VALUE);
    }
}

