/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.context;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ContextUtil {
    private static final ThreadLocal<Map<String, String>> THREAD_LOCAL = new ThreadLocal();

    private ContextUtil() {
    }

    public static void putAll(Map<String, String> map) {
        map.forEach(ContextUtil::set);
    }

    public static void set(String key, Object value) {
        if (ObjectUtil.isEmpty((Object)value) || StrUtil.isBlankOrUndefined((CharSequence)value.toString())) {
            return;
        }
        Map<String, String> map = ContextUtil.getLocalMap();
        map.put(key, value.toString());
    }

    public static <T> T get(String key, Class<T> type) {
        Map<String, String> map = ContextUtil.getLocalMap();
        return (T)Convert.convert(type, (Object)map.get(key));
    }

    public static <T> T get(String key, Class<T> type, Object def) {
        Map<String, String> map = ContextUtil.getLocalMap();
        String value = def == null ? map.get(key) : map.getOrDefault(key, String.valueOf(def));
        return (T)Convert.convert(type, (Object)(StrUtil.isEmpty((CharSequence)value) ? def : value));
    }

    public static String get(String key) {
        Map<String, String> map = ContextUtil.getLocalMap();
        return map.getOrDefault(key, "");
    }

    public static Map<String, String> getLocalMap() {
        Map<String, String> map = THREAD_LOCAL.get();
        if (map == null) {
            map = new ConcurrentHashMap<String, String>(10);
            THREAD_LOCAL.set(map);
        }
        return map;
    }

    public static void setLocalMap(Map<String, String> localMap) {
        THREAD_LOCAL.set(localMap);
    }

    public static Long getUserId() {
        return ContextUtil.get("UserId", Long.class);
    }

    public static void setUserId(Object userId) {
        ContextUtil.set("UserId", userId);
    }

    public static Long getEmployeeId() {
        return ContextUtil.get("EmployeeId", Long.class);
    }

    public static void setEmployeeId(Object employeeId) {
        ContextUtil.set("EmployeeId", employeeId);
    }

    public static boolean isEmptyUserId() {
        return ContextUtil.isEmptyLong("UserId");
    }

    public static boolean isEmptyEmployeeId() {
        return ContextUtil.isEmptyLong("EmployeeId");
    }

    public static boolean isEmptyApplicationId() {
        return ContextUtil.isEmptyLong("ApplicationId");
    }

    public static Long getApplicationId() {
        return ContextUtil.get("ApplicationId", Long.class);
    }

    public static void setApplicationId(Object applicationId) {
        ContextUtil.set("ApplicationId", applicationId);
    }

    public static String getPath() {
        return ContextUtil.get("Path", String.class, "");
    }

    public static void setPath(Object path) {
        ContextUtil.set("Path", path == null ? "" : path);
    }

    public static String getToken() {
        return ContextUtil.get("Token", String.class);
    }

    public static void setToken(String token) {
        ContextUtil.set("Token", token == null ? "" : token);
    }

    public static Long getCurrentCompanyId() {
        return ContextUtil.get("CurrentCompanyId", Long.class);
    }

    public static void setCurrentCompanyId(Object val) {
        ContextUtil.set("CurrentCompanyId", val);
    }

    public static Long getCurrentTopCompanyId() {
        return ContextUtil.get("CurrentTopCompanyId", Long.class);
    }

    public static void setCurrentTopCompanyId(Object val) {
        ContextUtil.set("CurrentTopCompanyId", val);
    }

    public static Long getCurrentDeptId() {
        return ContextUtil.get("CurrentDeptId", Long.class);
    }

    public static void setCurrentDeptId(Object val) {
        ContextUtil.set("CurrentDeptId", val);
    }

    public static String getClientId() {
        return ContextUtil.get("ClientId", String.class);
    }

    public static void setClientId(String val) {
        ContextUtil.set("ClientId", val);
    }

    private static boolean isEmptyLong(String key) {
        String val = ContextUtil.getLocalMap().get(key);
        return StrUtil.isEmpty((CharSequence)val) || "null".equals(val) || "0".equals(val);
    }

    private static boolean isEmptyStr(String key) {
        String val = ContextUtil.getLocalMap().get(key);
        return val == null || "null".equals(val);
    }

    public static String getLogTraceId() {
        return ContextUtil.get("trace", String.class);
    }

    public static void setLogTraceId(String val) {
        ContextUtil.set("trace", val);
    }

    public static Boolean getBoot() {
        return ContextUtil.get("boot", Boolean.class, false);
    }

    public static void setBoot(Boolean val) {
        ContextUtil.set("boot", val);
    }

    public static String getGrayVersion() {
        return ContextUtil.get("gray_version", String.class);
    }

    public static void setGrayVersion(String val) {
        ContextUtil.set("gray_version", val);
    }

    public static Boolean isProceed() {
        String proceed = ContextUtil.get("proceed", String.class);
        return StrUtil.isNotEmpty((CharSequence)proceed);
    }

    public static void setProceed() {
        ContextUtil.set("proceed", "1");
    }

    public static Boolean isStop() {
        String proceed = ContextUtil.get("stop", String.class);
        return StrUtil.isNotEmpty((CharSequence)proceed);
    }

    public static void setStop() {
        ContextUtil.set("stop", "1");
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }
}

