/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.utils.DefValueHelper;

public final class StrHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StrHelper.class);

    private StrHelper() {
    }

    public static String getOrDef(String val, String def) {
        return DefValueHelper.getOrDef(val, def);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object)css)) {
            return true;
        }
        return Stream.of(css).anyMatch(CharSequenceUtil::isBlank);
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object)css)) {
            return false;
        }
        return Stream.of(css).allMatch(CharSequenceUtil::isNotBlank);
    }

    public static String keywordConvert(String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return "";
        }
        value = value.replaceAll("%", "\\\\%");
        value = value.replaceAll("_", "\\\\_");
        return value;
    }

    public static Object keywordConvert(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return StrHelper.keywordConvert(str);
        }
        return value;
    }

    public static String like(Object value, SqlLike sqlType) {
        return SqlUtils.concatLike((Object)StrHelper.keywordConvert(String.valueOf(value)), (SqlLike)sqlType);
    }

    public static String fullLike(String value) {
        return StrHelper.like(value, SqlLike.DEFAULT);
    }

    public static String convertToCamelCase(String name) {
        if (StrUtil.isEmpty((CharSequence)name)) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        String[] camels = name.split("_");
        StringBuilder result = new StringBuilder();
        for (String camel : camels) {
            if (StrUtil.isEmpty((CharSequence)camel)) continue;
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String camelToHyphen(String input) {
        return StrHelper.wordsToHyphenCase(StrHelper.wordsAndHyphenAndCamelToConstantCase(input));
    }

    private static String wordsAndHyphenAndCamelToConstantCase(String input) {
        char[] chars;
        StringBuilder buf = new StringBuilder();
        char previousChar = ' ';
        for (char c : chars = input.toCharArray()) {
            boolean isNotUnderscore;
            boolean isUpperCaseAndPreviousIsLowerCase = Character.isLowerCase(previousChar) && Character.isUpperCase(c);
            boolean previousIsWhitespace = Character.isWhitespace(previousChar);
            boolean lastOneIsNotUnderscore = buf.length() > 0 && buf.charAt(buf.length() - 1) != '_';
            boolean bl = isNotUnderscore = c != '_';
            if (lastOneIsNotUnderscore && (isUpperCaseAndPreviousIsLowerCase || previousIsWhitespace)) {
                buf.append("_");
            } else if (Character.isDigit(previousChar) && Character.isLetter(c)) {
                buf.append("_");
            }
            if (StrHelper.shouldReplace(c) && lastOneIsNotUnderscore) {
                buf.append("_");
            } else if (!Character.isWhitespace(c) && (isNotUnderscore || lastOneIsNotUnderscore)) {
                buf.append(Character.toUpperCase(c));
            }
            previousChar = c;
        }
        if (Character.isWhitespace(previousChar)) {
            buf.append("_");
        }
        return buf.toString();
    }

    private static boolean shouldReplace(char c) {
        return c == '.' || c == '_' || c == '-';
    }

    private static String wordsToHyphenCase(String s) {
        StringBuilder buf = new StringBuilder();
        char lastChar = 'a';
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(lastChar) && !Character.isWhitespace(c) && '-' != c && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append("-");
            }
            if ('_' == c) {
                buf.append("-");
            } else if ('.' == c) {
                buf.append("-");
            } else if (!Character.isWhitespace(c)) {
                buf.append(Character.toLowerCase(c));
            }
            lastChar = c;
        }
        if (Character.isWhitespace(lastChar)) {
            buf.append("-");
        }
        return buf.toString();
    }
}

