/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.database.mybatis;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.exception.BizException;
import top.tangyh.basic.utils.SpringUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class WriteInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(WriteInterceptor.class);

    public Object intercept(Invocation invocation) {
        if (SpringUtils.getApplicationContext() == null) {
            return invocation.proceed();
        }
        if (!((Boolean)SpringUtils.getApplicationContext().getEnvironment().getProperty("lamp.database.isNotWrite", Boolean.class, (Object)false)).booleanValue()) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        if (StrUtil.containsAnyIgnoreCase((CharSequence)mappedStatement.getId(), (CharSequence[])new CharSequence[]{"uid", "resetPassErrorNum", "updateLastLoginTime"})) {
            return invocation.proceed();
        }
        Long userId = ContextUtil.getUserId();
        String tenant = ContextUtil.getTenant();
        log.info("mapper id={}, userId={}", (Object)mappedStatement.getId(), (Object)userId);
        if (Long.valueOf(2L).equals(userId) && SqlCommandType.DELETE.equals((Object)mappedStatement.getSqlCommandType())) {
            throw new BizException(-1, "\u6f14\u793a\u73af\u5883\uff0c\u65e0\u5220\u9664\u6743\u9650\uff0c\u8bf7\u672c\u5730\u90e8\u7f72\u540e\u6d4b\u8bd5");
        }
        boolean isAuthority = StrUtil.containsAnyIgnoreCase((CharSequence)mappedStatement.getId(), (CharSequence[])new CharSequence[]{"Tenant", "GlobalUser", "User", "Menu", "Resource", "Role", "Dictionary", "Parameter", "Application"});
        boolean isWrite = CollectionUtil.contains(Arrays.asList(SqlCommandType.DELETE, SqlCommandType.UPDATE, SqlCommandType.INSERT), (Object)mappedStatement.getSqlCommandType());
        if ("0000".equals(tenant) && isWrite && isAuthority) {
            throw new BizException(-1, "\u6f14\u793a\u73af\u5883\u7981\u6b62\u4fee\u6539\u3001\u5220\u9664\u91cd\u8981\u6570\u636e\uff01\u8bf7\u767b\u5f55\u79df\u6237\u30100000\u3011\uff0c\u8d26\u53f7\u3010lamp_pt\u3011\u521b\u5efa\u5176\u4ed6\u79df\u6237\u7ba1\u7406\u5458\u8d26\u53f7\u540e\u6d4b\u8bd5\u5168\u90e8\u529f\u80fd");
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

