/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.echo.manager;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.annotation.echo.Echo;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.echo.manager.LoadKey;
import top.tangyh.basic.model.LoadService;

public class CacheLoadKeys {
    private static final Logger log = LoggerFactory.getLogger(CacheLoadKeys.class);
    private String api;
    private Set<Serializable> keys = new HashSet<Serializable>();
    private String tenant;
    private LoadService loadService;

    public CacheLoadKeys(Echo rf) {
        this.api = rf.api();
    }

    public CacheLoadKeys(LoadKey lk, LoadService loadService, Set<Serializable> keys) {
        this.api = lk.getApi();
        this.tenant = ContextUtil.getTenant();
        this.loadService = loadService;
        this.keys = keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheLoadKeys that = (CacheLoadKeys)o;
        boolean apiMethod = Objects.equal((Object)this.api, (Object)that.api);
        boolean isEqualsKeys = this.keys.size() == that.keys.size() && this.keys.containsAll(that.keys);
        return apiMethod && isEqualsKeys;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.api, this.keys});
    }

    public Map<Serializable, Object> loadMap() {
        return this.loadService.findByIds(this.keys);
    }

    public String getApi() {
        return this.api;
    }

    public Set<Serializable> getKeys() {
        return this.keys;
    }

    public String getTenant() {
        return this.tenant;
    }

    public LoadService getLoadService() {
        return this.loadService;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setKeys(Set<Serializable> keys) {
        this.keys = keys;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setLoadService(LoadService loadService) {
        this.loadService = loadService;
    }

    public CacheLoadKeys() {
    }

    public String toString() {
        return "CacheLoadKeys(api=" + this.getApi() + ", keys=" + this.getKeys() + ", tenant=" + this.getTenant() + ", loadService=" + this.getLoadService() + ")";
    }
}

