/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.echo.manager;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.annotation.echo.Echo;

public class ClassManager
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ClassManager.class);
    private static final long serialVersionUID = 1L;
    private static final Map<String, List<Field>> CACHE = new HashMap<String, List<Field>>();

    public static List<Field> getFields(Class<?> clazz) {
        if (CACHE.containsKey(clazz.getName())) {
            return CACHE.get(clazz.getName());
        }
        Field[] declaredFields = ReflectUtil.getFields(clazz);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : declaredFields) {
            Echo echo;
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || Modifier.isVolatile(mod) || (echo = field.getDeclaredAnnotation(Echo.class)) == null) continue;
            if (StrUtil.hasEmpty((CharSequence[])new CharSequence[]{echo.api()})) {
                log.warn("\u7c7b {} \u5c5e\u6027 [{}] api \u4e3a\u7a7a\u3002", (Object)clazz.getName(), (Object)field.getName());
                continue;
            }
            fieldList.add(field);
        }
        CACHE.put(clazz.getName(), fieldList);
        return fieldList;
    }
}

