/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.echo.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;
import top.tangyh.basic.annotation.echo.Echo;
import top.tangyh.basic.echo.core.DefCacheLoader;
import top.tangyh.basic.echo.manager.CacheLoadKeys;
import top.tangyh.basic.echo.manager.ClassManager;
import top.tangyh.basic.echo.manager.FieldParam;
import top.tangyh.basic.echo.manager.LoadKey;
import top.tangyh.basic.echo.properties.EchoProperties;
import top.tangyh.basic.interfaces.BaseEnum;
import top.tangyh.basic.interfaces.echo.EchoService;
import top.tangyh.basic.interfaces.echo.EchoVO;
import top.tangyh.basic.interfaces.echo.LoadService;
import top.tangyh.basic.jackson.JsonUtil;

public class EchoServiceImpl
implements EchoService,
EnvironmentCapable,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EchoServiceImpl.class);
    private static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private static final int DEF_MAP_SIZE = 20;
    private static final String[] BASE_TYPES = new String[]{"java.lang.Integer", "java.lang.Byte", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Character", "java.lang.Short", "java.lang.Boolean", "java.lang.String"};
    private static final String[] COLL_TYPES = new String[]{"java.util.List", "java.util.Set", "java.util.Collection"};
    private static final Map<String, FieldParam> CACHE = new HashMap<String, FieldParam>();
    private final Map<String, LoadService> strategyMap = new ConcurrentHashMap<String, LoadService>();
    private final EchoProperties ips;
    private LoadingCache<CacheLoadKeys, Map<Serializable, Object>> caches;
    private Environment environment;

    public EchoServiceImpl(EchoProperties ips, Map<String, LoadService> strategyMap) {
        this.strategyMap.putAll(strategyMap);
        this.ips = ips;
        EchoProperties.GuavaCache guavaCache = ips.getGuavaCache();
        if (guavaCache.getEnabled().booleanValue()) {
            this.caches = CacheBuilder.newBuilder().maximumSize((long)guavaCache.getMaximumSize().intValue()).refreshAfterWrite((long)guavaCache.getRefreshWriteTime().intValue(), TimeUnit.MINUTES).build((CacheLoader)new DefCacheLoader(guavaCache));
        }
    }

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)this.getEnvironment().resolveRequiredPlaceholders(basePackage));
    }

    public final Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new StandardEnvironment();
        }
        return this.environment;
    }

    public void afterPropertiesSet() {
        List<String> basePackages = this.ips.getBasePackages();
        if (CollUtil.isEmpty(basePackages)) {
            return;
        }
        try {
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            SimpleMetadataReaderFactory metadata = new SimpleMetadataReaderFactory();
            for (String basePackage : basePackages) {
                Resource[] resources;
                String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + "/**/*.class";
                for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                    Schema apiModel;
                    MetadataReader metadataReader = metadata.getMetadataReader(resource);
                    String className = metadataReader.getClassMetadata().getClassName();
                    Class<?> clazz = Class.forName(className);
                    if (clazz == null || (apiModel = clazz.getAnnotation(Schema.class)) == null) continue;
                    ClassManager.getFields(clazz);
                }
            }
        }
        catch (Exception e) {
            log.error("======================\u6ce8\u610f\uff1a\u626b\u63cf\u3010{}\u3011\u62a5\u9519", basePackages, (Object)e);
        }
    }

    public void action(Object obj, String ... ignoreFields) {
        this.action(obj, false, ignoreFields);
    }

    public void action(Object obj, boolean isUseCache, String ... ignoreFields) {
        try {
            ConcurrentHashMap<LoadKey, Map<Serializable, Object>> typeMap = new ConcurrentHashMap<LoadKey, Map<Serializable, Object>>(20);
            long parseStart = System.currentTimeMillis();
            this.parse(obj, typeMap, 1, ignoreFields);
            long parseEnd = System.currentTimeMillis();
            if (typeMap.isEmpty()) {
                return;
            }
            this.load(typeMap, isUseCache);
            long echoStart = System.currentTimeMillis();
            this.write(obj, typeMap, 1, new String[0]);
            long echoEnd = System.currentTimeMillis();
            log.info("\u89e3\u6790\u8017\u65f6={} ms", (Object)(parseEnd - parseStart));
            log.info("\u6279\u91cf\u67e5\u8be2\u8017\u65f6={} ms", (Object)(echoStart - parseEnd));
            log.info("\u56de\u663e\u8017\u65f6={} ms", (Object)(echoEnd - echoStart));
        }
        catch (Exception e) {
            log.warn("\u56de\u663e\u5931\u8d25", (Throwable)e);
        }
    }

    private void parse(Object obj, Map<LoadKey, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        if (obj == null) {
            return;
        }
        if (depth > this.ips.getMaxDepth()) {
            log.info("\u9012\u5f52\u56de\u663e\u5c42\u7ea7\u8fc7\u6df1 \u6216 \u51fa\u73b0\u5faa\u73af\u9012\u5f52\uff0c\u6700\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)this.ips.getMaxDepth(), (Object)depth);
            return;
        }
        if (obj instanceof IPage) {
            IPage page = (IPage)obj;
            List records = page.getRecords();
            this.parseList(records, typeMap, depth, ignoreFields);
            return;
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            this.parseList(collection, typeMap, depth, ignoreFields);
            return;
        }
        List<Field> fields = ClassManager.getFields(obj.getClass());
        for (Field field : fields) {
            FieldParam fieldParam = this.getFieldParam(obj, field, typeMap, innerTypeMap -> this.parse(ReflectUtil.getFieldValue((Object)obj, (Field)field), (Map<LoadKey, Map<Serializable, Object>>)innerTypeMap, depth + 1, ignoreFields), ignoreFields);
            if (fieldParam == null) continue;
            LoadKey type = fieldParam.getLoadKey();
            Map valueMap = typeMap.getOrDefault(type, new ConcurrentHashMap(20));
            Serializable serializable = fieldParam.getActualValue();
            if (serializable instanceof Collection) {
                Collection av = (Collection)((Object)serializable);
                av.forEach(item -> valueMap.put((Serializable)item, Collections.emptyMap()));
            } else {
                valueMap.put(fieldParam.getActualValue(), Collections.emptyMap());
            }
            typeMap.put(type, valueMap);
        }
    }

    private void parseList(Collection<?> list, Map<LoadKey, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        for (Object item : list) {
            this.parse(item, typeMap, depth, ignoreFields);
        }
    }

    private void load(Map<LoadKey, Map<Serializable, Object>> typeMap, boolean isUseCache) {
        for (Map.Entry<LoadKey, Map<Serializable, Object>> entries : typeMap.entrySet()) {
            LoadKey type = entries.getKey();
            Map<Serializable, Object> valueMap = entries.getValue();
            Set<Serializable> keys = valueMap.keySet();
            if ("_DEF_ENUM_API".equalsIgnoreCase(type.getApi())) {
                HashMap value = new HashMap();
                valueMap.forEach((k, v) -> {
                    if (k instanceof BaseEnum) {
                        BaseEnum be = (BaseEnum)k;
                        value.put(k, be.getDesc());
                    } else {
                        value.put(k, k);
                    }
                });
                typeMap.put(type, value);
                continue;
            }
            LoadService loadService = this.strategyMap.get(type.getApi());
            if (loadService == null) {
                String tip = "\u5904\u7406\u5b57\u6bb5\u7684\u6570\u636e\u56de\u663e\u65f6\uff0c\u6ca1\u6709\u627e\u5230@Echo\u6ce8\u89e3\u4e2dapi\u5c5e\u6027\u7684\u5b9e\u4f8b\uff1a[{}]\u3002 \u8bf7\u786e\u4fdd[{}]\u5b9e\u73b0\u4e86 LoadService\uff0c\u5e76\u6ce8\u518c\u5230Spring\u5bb9\u5668\u4e2d\u3002\n1. \u82e5api\u6307\u5b9a\u7684\u662fServiceImpl\uff0c\u8bf7\u786e\u4fdd\u5728\u540c\u4e00\u4e2a\u670d\u52a1\u5185\u3002 \n2. \u82e5api\u6307\u5b9a\u7684\u662fFeignClient\uff0c\u8bf7\u786e\u4fdd\u88ab\u56de\u663e\u7684\u670d\u52a1\u80fd\u6b63\u5e38\u8c03\u7528\u8be5Feign\u63a5\u53e3\u3002 \n";
                log.warn(tip, (Object)type.getApi(), (Object)type.getApi());
                continue;
            }
            CacheLoadKeys lk = new CacheLoadKeys(type, loadService, keys);
            Map value = this.ips.getGuavaCache().getEnabled() != false && isUseCache ? (Map)this.caches.get((Object)lk) : lk.loadMap();
            typeMap.put(type, value);
        }
    }

    private void write(Object obj, Map<LoadKey, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        if (obj == null) {
            return;
        }
        if (depth > this.ips.getMaxDepth()) {
            log.info("\u9012\u5f52\u56de\u663e\u5c42\u7ea7\u8fc7\u6df1 \u6216 \u51fa\u73b0\u5faa\u73af\u9012\u5f52\uff0c\u6700\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)this.ips.getMaxDepth(), (Object)depth);
            return;
        }
        if (obj instanceof IPage) {
            IPage page = (IPage)obj;
            List records = page.getRecords();
            this.writeList(records, typeMap, ignoreFields);
            return;
        }
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            this.writeList(coll, typeMap, ignoreFields);
            return;
        }
        this.iterationWrite(obj, typeMap, depth, ignoreFields);
    }

    private void iterationWrite(Object obj, Map<LoadKey, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        List<Field> fields = ClassManager.getFields(obj.getClass());
        for (Field field : fields) {
            Map map;
            FieldParam fieldParam = this.getFieldParam(obj, field, typeMap, innerTypeMap -> this.write(ReflectUtil.getFieldValue((Object)obj, (Field)field), (Map<LoadKey, Map<Serializable, Object>>)innerTypeMap, depth + 1, ignoreFields), ignoreFields);
            if (fieldParam == null) continue;
            Echo inField = fieldParam.getEcho();
            Serializable actualValue = fieldParam.getActualValue();
            Object originalValue = fieldParam.getOriginalValue();
            String fieldName = fieldParam.getFieldName();
            String ref = inField.ref();
            LoadKey loadKey = fieldParam.getLoadKey();
            Object echoValue = this.getEchoValue(inField, actualValue, originalValue, loadKey, typeMap);
            if (echoValue == null || echoValue instanceof Map && (map = (Map)echoValue).isEmpty()) continue;
            if (echoValue instanceof Map && !Object.class.equals((Object)inField.beanClass())) {
                echoValue = JsonUtil.parse((String)JsonUtil.toJson((Object)echoValue), (Class)inField.beanClass());
            }
            if (StrUtil.isNotEmpty((CharSequence)ref)) {
                ReflectUtil.setFieldValue((Object)obj, (String)ref, (Object)echoValue);
            }
            if (obj instanceof EchoVO) {
                EchoVO vo = (EchoVO)obj;
                vo.getEchoMap().put(fieldName, echoValue);
                continue;
            }
            ReflectUtil.setFieldValue((Object)obj, (Field)field, (Object)echoValue);
        }
    }

    private Object getEchoValue(Echo echo, Object actualValue, Object originalValue, LoadKey loadKey, Map<LoadKey, Map<Serializable, Object>> typeMap) {
        if (ObjectUtil.isEmpty((Object)actualValue)) {
            return null;
        }
        Map<Serializable, Object> valueMap = typeMap.get(loadKey);
        if (MapUtil.isEmpty(valueMap)) {
            return null;
        }
        if (actualValue instanceof Collection) {
            Collection actualValues = (Collection)actualValue;
            ArrayList<Object> newVal = new ArrayList<Object>();
            for (Object actual : actualValues) {
                if (actual == null) continue;
                Object value = valueMap.get(actual);
                if (value == null && !(actual instanceof String)) {
                    value = valueMap.get(actual.toString());
                }
                if (value == null) continue;
                newVal.add(value);
            }
            return newVal;
        }
        Object newVal = valueMap.get(actualValue);
        if (ObjectUtil.isNotNull((Object)newVal)) {
            return newVal;
        }
        newVal = valueMap.get(actualValue.toString());
        if (ObjectUtil.isNull((Object)newVal) && StrUtil.isNotEmpty((CharSequence)echo.dictType())) {
            if (originalValue instanceof Collection) {
                Collection originalValues = (Collection)originalValue;
                ArrayList<String> listVal = new ArrayList<String>();
                for (Object original : originalValues) {
                    String value;
                    if (original == null || (value = valueMap.getOrDefault(echo.dictType() + this.ips.getDictSeparator() + original, "").toString()) == null) continue;
                    listVal.add(value);
                }
                return listVal;
            }
            List codes = StrUtil.split((CharSequence)originalValue.toString(), (CharSequence)this.ips.getDictItemSeparator());
            newVal = codes.stream().map(item -> {
                String val = valueMap.getOrDefault(echo.dictType() + this.ips.getDictSeparator() + item, "").toString();
                return val == null ? "" : val;
            }).collect(Collectors.joining(this.ips.getDictItemSeparator()));
        }
        return newVal;
    }

    private void writeList(Collection<?> list, Map<LoadKey, Map<Serializable, Object>> typeMap, String ... ignoreFields) {
        for (Object item : list) {
            this.write(item, typeMap, 1, ignoreFields);
        }
    }

    private FieldParam getFieldParam(Object obj, Field field, Map<LoadKey, Map<Serializable, Object>> typeMap, Consumer<Map<LoadKey, Map<Serializable, Object>>> consumer, String ... ignoreFields) {
        FieldParam fieldParam;
        String key = obj.getClass().getName() + "###" + field.getName();
        if (ArrayUtil.contains((Object[])ignoreFields, (Object)field.getName())) {
            log.debug("\u5df2\u7ecf\u5ffd\u7565{}\u5b57\u6bb5\u7684\u89e3\u6790", (Object)field.getName());
            return null;
        }
        if (this.isNotBaseType(field)) {
            consumer.accept(typeMap);
            return null;
        }
        if (CACHE.containsKey(key)) {
            fieldParam = CACHE.get(key);
        } else {
            Echo echo = field.getDeclaredAnnotation(Echo.class);
            LoadKey loadKey = new LoadKey(echo);
            fieldParam = FieldParam.builder().echo(echo).loadKey(loadKey).fieldName(field.getName()).build();
            CACHE.put(key, fieldParam);
        }
        field.setAccessible(true);
        Object originalValue = ReflectUtil.getFieldValue((Object)obj, (Field)field);
        if (originalValue == null) {
            log.debug("\u5b57\u6bb5[{}]\u4e3a\u7a7a,\u8df3\u8fc7", (Object)field.getName());
            return null;
        }
        Serializable actualValue = this.getActualValue(fieldParam.getEcho(), originalValue);
        if (ObjectUtil.isEmpty((Object)actualValue)) {
            return null;
        }
        fieldParam.setOriginalValue(originalValue);
        fieldParam.setActualValue(actualValue);
        return fieldParam;
    }

    private Serializable getActualValue(Echo echo, Object originalValue) {
        Object actualValue = (Serializable)originalValue;
        String dictType = echo.dictType();
        if (StrUtil.isNotEmpty((CharSequence)dictType)) {
            actualValue = dictType;
        }
        return actualValue;
    }

    private boolean isNotBaseType(Field field) {
        return !this.isBaseType(field);
    }

    private boolean isBaseType(Field field) {
        Type type;
        String typeName = field.getType().getName();
        if (ArrayUtil.contains((Object[])BASE_TYPES, (Object)typeName)) {
            return true;
        }
        if (EnumUtil.isEnum(field.getType())) {
            return true;
        }
        if (ArrayUtil.contains((Object[])COLL_TYPES, (Object)typeName) && (type = TypeUtil.getTypeArgument((Type)field.getGenericType())) != null) {
            return ArrayUtil.contains((Object[])BASE_TYPES, (Object)type.getTypeName());
        }
        return false;
    }
}

