/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.echo;

import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.tangyh.basic.echo.aspect.EchoResultAspect;
import top.tangyh.basic.echo.core.EchoServiceImpl;
import top.tangyh.basic.echo.properties.EchoProperties;
import top.tangyh.basic.interfaces.echo.EchoService;
import top.tangyh.basic.interfaces.echo.LoadService;

@Configuration
@EnableConfigurationProperties(value={EchoProperties.class})
public class EchoAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EchoAutoConfiguration.class);
    private final EchoProperties echoProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="lamp.echo", name={"aop-enabled"}, havingValue="true", matchIfMissing=true)
    public EchoResultAspect getEchoResultAspect(EchoService echoService) {
        return new EchoResultAspect(echoService);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="lamp.echo", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public EchoService getEchoService(Map<String, LoadService> strategyMap) {
        return new EchoServiceImpl(this.echoProperties, strategyMap);
    }

    @Generated
    public EchoAutoConfiguration(EchoProperties echoProperties) {
        this.echoProperties = echoProperties;
    }
}

