/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.log.util;

import java.lang.reflect.Method;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.annotation.log.WebLog;

public final class LogUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogUtil.class);

    private LogUtil() {
    }

    public static String getDescribe(JoinPoint point) {
        WebLog annotation = LogUtil.getTargetAnnotation(point);
        if (annotation == null) {
            return "";
        }
        return annotation.value();
    }

    public static String getDescribe(WebLog annotation) {
        if (annotation == null) {
            return "";
        }
        return annotation.value();
    }

    public static WebLog getTargetAnnotation(JoinPoint point) {
        try {
            MethodSignature ms;
            Method method;
            WebLog annotation = null;
            Signature signature = point.getSignature();
            if (signature instanceof MethodSignature && (method = (ms = (MethodSignature)signature).getMethod()) != null) {
                annotation = method.getAnnotation(WebLog.class);
            }
            return annotation;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6 {}.{} \u7684 @WebLog \u6ce8\u89e3\u5931\u8d25", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), e});
            return null;
        }
    }
}

