/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.log;

import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import top.tangyh.basic.jackson.JsonUtil;
import top.tangyh.basic.log.aspect.SysLogAspect;
import top.tangyh.basic.log.event.SysLogListener;
import top.tangyh.basic.log.monitor.PointUtil;
import top.tangyh.basic.log.properties.OptLogProperties;

@EnableAsync
@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={OptLogProperties.class})
@ConditionalOnProperty(prefix="lamp.log", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LogAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SysLogAspect sysLogAspect() {
        return new SysLogAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="lamp.log", name={"type"}, havingValue="LOGGER", matchIfMissing=true)
    public SysLogListener sysLogListener() {
        return new SysLogListener(log -> PointUtil.debug("0", "OPT_LOG", JsonUtil.toJson((Object)log)));
    }

    @Generated
    public LogAutoConfiguration() {
    }
}

