/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.manager.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.transaction.annotation.Transactional;
import top.tangyh.basic.base.entity.SuperEntity;
import top.tangyh.basic.base.manager.SuperCacheManager;
import top.tangyh.basic.base.manager.impl.SuperManagerImpl;
import top.tangyh.basic.base.mapper.SuperMapper;
import top.tangyh.basic.cache.redis2.CacheResult;
import top.tangyh.basic.cache.repository.CacheOps;
import top.tangyh.basic.database.mybatis.conditions.Wraps;
import top.tangyh.basic.database.mybatis.conditions.query.LbQueryWrap;
import top.tangyh.basic.model.cache.CacheKey;
import top.tangyh.basic.model.cache.CacheKeyBuilder;
import top.tangyh.basic.utils.CollHelper;

public abstract class SuperCacheManagerImpl<M extends SuperMapper<T>, T extends SuperEntity>
extends SuperManagerImpl<M, T>
implements SuperCacheManager<T> {
    protected static final int MAX_BATCH_KEY_SIZE = 500;
    @Autowired
    protected CacheOps cacheOps;

    protected abstract CacheKeyBuilder cacheKeyBuilder();

    @Override
    @Transactional(readOnly=true)
    public T getByIdCache(Serializable id) {
        if (id == null) {
            return null;
        }
        CacheKey cacheKey = this.cacheKeyBuilder().key(new Object[]{id});
        CacheResult result = this.cacheOps.get(cacheKey, k -> (SuperEntity)super.getById(id), new boolean[0]);
        return (T)((SuperEntity)result.getValue());
    }

    @Override
    @Transactional(readOnly=true)
    public <E> Set<E> findCollectByIds(List<Long> keyIdList, Function<Long, CacheKey> cacheBuilder, Function<Long, List<E>> loader) {
        if (CollUtil.isEmpty(keyIdList)) {
            return Collections.emptySet();
        }
        List<CacheKey> cacheKeys = keyIdList.stream().map(cacheBuilder).toList();
        List resultList = this.cacheOps.find(cacheKeys);
        if (resultList.size() != cacheKeys.size()) {
            this.log.warn("key\u548c\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6392\u67e5\u539f\u56e0!");
        }
        HashSet<E> resultIdSet = new HashSet<E>();
        for (int i = 0; i < resultList.size(); ++i) {
            CacheResult result = (CacheResult)resultList.get(i);
            List<E> resultIdList = result.asList();
            if (result.isNull()) {
                Long keyId = keyIdList.get(i);
                List<E> idList = loader.apply(keyId);
                CacheKey cacheKey = cacheKeys.get(i);
                this.cacheOps.set(cacheKey, idList, new boolean[0]);
                resultIdList = idList;
            }
            resultIdSet.addAll(resultIdList);
        }
        return resultIdSet;
    }

    private List<CacheResult<T>> find(List<CacheKey> keys) {
        return this.cacheOps.find(keys);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByIds(@NonNull Collection<? extends Serializable> ids, Function<Collection<? extends Serializable>, Collection<T>> loader) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List<CacheKey> keys = ids.stream().map(arg_0 -> SuperCacheManagerImpl.lambda$findByIds$1(this.cacheKeyBuilder(), arg_0)).toList();
        List partitionKeys = Lists.partition(keys, (int)500);
        List valueList = partitionKeys.stream().map(this::find).flatMap(Collection::stream).toList();
        ArrayList keysList = Lists.newArrayList(ids);
        this.log.debug(StrUtil.format((CharSequence)"keySize={}, valueSize={}", (Object[])new Object[]{keysList.size(), valueList.size()}));
        LinkedHashSet missedIds = Sets.newLinkedHashSet();
        LinkedHashMap<Serializable, SuperEntity> allMap = new LinkedHashMap<Serializable, SuperEntity>();
        for (int i = 0; i < valueList.size(); ++i) {
            CacheResult v2 = (CacheResult)valueList.get(i);
            Serializable k2 = (Serializable)keysList.get(i);
            if (v2 == null || v2.isNull()) {
                missedIds.add(k2);
                allMap.put(k2, null);
                continue;
            }
            allMap.put(k2, (SuperEntity)v2.getValue());
        }
        if (CollUtil.isNotEmpty((Collection)missedIds)) {
            if (loader == null) {
                loader = missIds -> super.listByIds(missIds.stream().filter(Objects::nonNull).map(Convert::toLong).toList());
            }
            Collection<T> missList = loader.apply(missedIds);
            ImmutableMap missMap = CollHelper.uniqueIndex(missList, item -> (Serializable)item.getId(), item -> item);
            allMap.forEach((k, v) -> {
                if (missMap.containsKey(k)) {
                    allMap.put((Serializable)k, (SuperEntity)missMap.get(k));
                }
            });
            for (Serializable missedKey : missedIds) {
                CacheKey key = this.cacheKeyBuilder().key(new Object[]{missedKey});
                this.cacheOps.set(key, missMap.getOrDefault((Object)missedKey, null), new boolean[0]);
            }
        }
        Collection values = allMap.values();
        return Lists.newArrayList(values);
    }

    @Override
    @Transactional(readOnly=true)
    public T getByKey(CacheKey key, Function<CacheKey, Object> loader) {
        CacheResult id = this.cacheOps.get(key, loader, new boolean[0]);
        return id == null ? null : (T)this.getByIdCache(Convert.toLong((Object)id));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeById(Serializable id) {
        boolean bool = super.removeById(id);
        this.delCache(id);
        return bool;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeByIds(Collection<?> idList) {
        if (CollUtil.isEmpty(idList)) {
            return true;
        }
        boolean flag = super.removeByIds(idList);
        this.delCache((T)idList);
        return flag;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean save(T model) {
        boolean save = super.save(model);
        this.setCache(model);
        return save;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateAllById(T model) {
        boolean updateBool = super.updateAllById(model);
        this.delCache(model);
        return updateBool;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(T model) {
        boolean updateBool = super.updateById(model);
        this.delCache(model);
        return updateBool;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.INSERT_ONE);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            sqlSession.insert(sqlStatement, entity);
            this.setCache((T)entity);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        BiPredicate<SqlSession, SuperEntity> predicate = (sqlSession, entity) -> {
            Object idVal = ReflectionKit.getFieldValue((Object)entity, (String)keyProperty);
            return StringUtils.checkValNull((Object)idVal) || CollectionUtils.isEmpty((Collection)sqlSession.selectList(this.getSqlStatement(SqlMethod.SELECT_BY_ID), entity));
        };
        BiConsumer<SqlSession, SuperEntity> consumer = (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(this.getSqlStatement(SqlMethod.UPDATE_BY_ID), (Object)param);
            this.delCache((T)entity);
        };
        String sqlStatement = SqlHelper.getSqlStatement((Class)this.getMapperClass(), (SqlMethod)SqlMethod.INSERT_ONE);
        return SqlHelper.executeBatch(this.getEntityClass(), (Log)this.log, entityList, (int)batchSize, (sqlSession, entity) -> {
            if (predicate.test((SqlSession)sqlSession, (SuperEntity)entity)) {
                sqlSession.insert(sqlStatement, entity);
                this.setCache((T)entity);
            } else {
                consumer.accept((SqlSession)sqlSession, (SuperEntity)entity);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.UPDATE_BY_ID);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
            this.delCache((T)entity);
        });
    }

    @Override
    public void refreshCache(List<Long> ids) {
        LbQueryWrap wrap = null;
        if (CollUtil.isNotEmpty(ids)) {
            wrap = Wraps.lbQ().in(SuperEntity::getId, ids);
        }
        this.list((Wrapper)wrap).forEach(this::setCache);
    }

    @Override
    public void clearCache(List<Long> ids) {
        LbQueryWrap wrap = null;
        if (CollUtil.isNotEmpty(ids)) {
            wrap = Wraps.lbQ().in(SuperEntity::getId, ids);
        }
        this.list((Wrapper)wrap).forEach(this::delCache);
    }

    @Override
    public void delCache(Serializable ... ids) {
        this.delCache((T)Arrays.asList(ids));
    }

    @Override
    public void delCache(Collection<?> idList) {
        CacheKey[] keys = (CacheKey[])idList.stream().map(id -> this.cacheKeyBuilder().key(new Object[]{id})).toArray(CacheKey[]::new);
        this.cacheOps.del(keys);
    }

    @Override
    public void delCache(T model) {
        Object id = this.getId(model);
        if (id != null) {
            CacheKey key = this.cacheKeyBuilder().key(new Object[]{id});
            this.cacheOps.del(new CacheKey[]{key});
        }
    }

    @Override
    public void setCache(T model) {
        Object id = this.getId(model);
        if (id != null) {
            CacheKey key = this.cacheKeyBuilder().key(new Object[]{id});
            this.cacheOps.set(key, model, new boolean[0]);
        }
    }

    protected Object getId(T model) {
        if (model != null) {
            return model.getId();
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        if (tableInfo == null) {
            return null;
        }
        Class keyType = tableInfo.getKeyType();
        if (keyType == null) {
            return null;
        }
        String keyProperty = tableInfo.getKeyProperty();
        Field idField = ReflectUtil.getField(this.getEntityClass(), (String)keyProperty);
        return ReflectUtil.getFieldValue(model, (Field)idField);
    }

    private static /* synthetic */ CacheKey lambda$findByIds$1(CacheKeyBuilder rec$, Object xva$0) {
        return rec$.key(new Object[]{xva$0});
    }
}

